/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaour.api_scanner.servlet;

import com.github.xiaour.api_scanner.logging.Log;
import com.github.xiaour.api_scanner.logging.LogFactory;
import com.github.xiaour.api_scanner.servlet.ApiViewServlet;
import com.github.xiaour.api_scanner.util.Utils;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@WebServlet(name="sapistatic", urlPatterns={"/sapistatic"})
public class SapiStaticServlet
extends HttpServlet {
    private static final Log LOG = LogFactory.getLog(SapiStaticServlet.class);
    protected final String resourcePath;

    public SapiStaticServlet() {
        this.resourcePath = "support/http";
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String contextPath = request.getContextPath();
        String servletPath = request.getServletPath();
        response.setCharacterEncoding("utf-8");
        if (contextPath == null) {
            contextPath = "";
        }
        String resourceFile = request.getParameter("s");
        String uri = contextPath + servletPath;
        try {
            this.returnResourceFile(resourceFile, uri, response);
        }
        catch (ServletException e) {
            LOG.error("Sapi init exception:", e);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    protected void returnResourceFile(String fileName, String uri, HttpServletResponse response) throws ServletException, IOException {
        String text;
        String filePath = new ApiViewServlet().getFilePath(fileName);
        if (filePath.endsWith(".html")) {
            response.setContentType("text/html; charset=utf-8");
        }
        if ((text = Utils.readFromResource(filePath)) == null) {
            response.sendRedirect(uri + "/index.html");
            return;
        }
        if (fileName.endsWith(".css")) {
            response.setContentType("text/css;charset=utf-8");
        } else if (fileName.endsWith(".js")) {
            response.setContentType("text/javascript;charset=utf-8");
        }
        response.getWriter().write(text);
    }
}

