/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.spring.plugin;

import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import com.github.xiaoymin.knife4j.spring.extension.ApiAuthorExtension;
import com.github.xiaoymin.knife4j.spring.extension.ApiOrderExtension;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.swagger.annotations.Api;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.core.annotation.AnnotationUtils;
import springfox.documentation.service.Tag;
import springfox.documentation.service.Tags;
import springfox.documentation.service.VendorExtension;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.ApiListingBuilderPlugin;
import springfox.documentation.spi.service.contexts.ApiListingContext;
import springfox.documentation.swagger.common.SwaggerPluginSupport;

public class ApiSupportListingReaderPlugin
implements ApiListingBuilderPlugin {
    public void apply(ApiListingContext apiListingContext) {
        Optional controller = apiListingContext.getResourceGroup().getControllerClass();
        if (controller.isPresent()) {
            ApiSupport apiSupport;
            String author;
            Optional apiAnnotation = Optional.fromNullable((Object)AnnotationUtils.findAnnotation((Class)((Class)controller.get()), Api.class));
            String description = Strings.emptyToNull((String)((String)apiAnnotation.transform(this.descriptionExtractor()).orNull()));
            Set tagSet = (Set)apiAnnotation.transform(this.tags()).or((Object)Sets.newTreeSet());
            if (tagSet.isEmpty()) {
                tagSet.add(apiListingContext.getResourceGroup().getGroupName());
            }
            Optional apiSupportAnnotation = Optional.fromNullable((Object)AnnotationUtils.findAnnotation((Class)((Class)controller.get()), ApiSupport.class));
            HashSet<Tag> tags = new HashSet<Tag>();
            if (apiSupportAnnotation.isPresent() && !"".equalsIgnoreCase(author = (apiSupport = (ApiSupport)apiSupportAnnotation.get()).author())) {
                Integer order = apiSupport.order();
                if (tagSet.isEmpty()) {
                    Tag tag = new Tag(apiListingContext.getResourceGroup().getGroupName(), description, (List)Lists.newArrayList((Object[])new VendorExtension[]{new ApiOrderExtension(order), new ApiAuthorExtension(author)}));
                    tags.add(tag);
                }
            }
            apiListingContext.apiListingBuilder().description(description).tagNames(tagSet).tags(tags);
        }
    }

    private Function<Api, String> descriptionExtractor() {
        return new Function<Api, String>(){

            public String apply(Api input) {
                return input.description();
            }
        };
    }

    private Function<Api, Set<String>> tags() {
        return new Function<Api, Set<String>>(){

            public Set<String> apply(Api input) {
                return Sets.newTreeSet((Iterable)FluentIterable.from((Iterable)Lists.newArrayList((Object[])input.tags())).filter(Tags.emptyTags()).toSet());
            }
        };
    }

    public boolean supports(DocumentationType delimiter) {
        return SwaggerPluginSupport.pluginDoesApply((DocumentationType)delimiter);
    }
}

