/*
 * Decompiled with CFR 0.152.
 */
package com.github.zuihou.cache;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.zuihou.cache.lock.CaffeineDistributedLock;
import com.github.zuihou.cache.properties.CustomCacheProperties;
import com.github.zuihou.cache.repository.CacheRepository;
import com.github.zuihou.cache.repository.CaffeineRepositoryImpl;
import com.github.zuihou.lock.DistributedLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.CacheManager;
import org.springframework.cache.caffeine.CaffeineCacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;

@ConditionalOnProperty(prefix="zuihou.cache", name={"type"}, havingValue="CAFFEINE")
@EnableConfigurationProperties(value={CustomCacheProperties.class})
public class CaffeineAutoConfigure {
    private static final Logger log = LoggerFactory.getLogger(CaffeineAutoConfigure.class);
    @Autowired
    private CustomCacheProperties cacheProperties;

    @Bean
    @ConditionalOnMissingBean
    public DistributedLock RedisDistributedLock() {
        return new CaffeineDistributedLock();
    }

    @Bean
    @ConditionalOnMissingBean
    public CacheRepository redisRepository() {
        return new CaffeineRepositoryImpl();
    }

    @Bean
    @Primary
    public CacheManager caffeineCacheManager() {
        CaffeineCacheManager cacheManager = new CaffeineCacheManager();
        Caffeine caffeine = Caffeine.newBuilder().recordStats().initialCapacity(500).expireAfterWrite(this.cacheProperties.getDef().getTimeToLive()).maximumSize((long)this.cacheProperties.getDef().getMaxSize());
        cacheManager.setAllowNullValues(this.cacheProperties.getDef().isCacheNullValues());
        cacheManager.setCaffeine(caffeine);
        return cacheManager;
    }
}

