/*
 * Decompiled with CFR 0.152.
 */
package com.github.zuihou.cache.repository;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.github.zuihou.cache.repository.CacheRepository;
import com.github.zuihou.cache.utils.RedisObjectSerializer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.RedisClusterNode;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisServerCommands;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.ListOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;

public class RedisRepositoryImpl
implements CacheRepository {
    private static final Logger log = LoggerFactory.getLogger(RedisRepositoryImpl.class);
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static final RedisObjectSerializer OBJECT_SERIALIZER = new RedisObjectSerializer();
    private RedisTemplate<String, Object> redisTemplate;

    public RedisRepositoryImpl(RedisTemplate<String, Object> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public RedisConnectionFactory getConnectionFactory() {
        return this.redisTemplate.getConnectionFactory();
    }

    public RedisTemplate<String, Object> getRedisTemplate() {
        return this.redisTemplate;
    }

    public void flushDb(RedisClusterNode node) {
        this.redisTemplate.opsForCluster().flushDb(node);
    }

    public void setExpire(byte[] key, byte[] value, long time) {
        this.redisTemplate.execute(connection -> {
            connection.setEx(key, time, value);
            log.debug("[redisTemplate redis]\u653e\u5165 \u7f13\u5b58  url:{} ========\u7f13\u5b58\u65f6\u95f4\u4e3a{}\u79d2", (Object)key, (Object)time);
            return 1L;
        });
    }

    @Override
    public void setExpire(String key, Object value, long time) {
        this.redisTemplate.execute(connection -> {
            RedisSerializer<String> serializer = this.getRedisSerializer();
            byte[] keys = serializer.serialize((Object)key);
            byte[] values = OBJECT_SERIALIZER.serialize(value);
            connection.setEx(keys, time, values);
            return 1L;
        });
    }

    public void setExpire(String[] keys, Object[] values, long time) {
        this.redisTemplate.execute(connection -> {
            RedisSerializer<String> serializer = this.getRedisSerializer();
            for (int i = 0; i < keys.length; ++i) {
                byte[] bKeys = serializer.serialize((Object)keys[i]);
                byte[] bValues = OBJECT_SERIALIZER.serialize(values[i]);
                connection.setEx(bKeys, time, bValues);
            }
            return 1L;
        });
    }

    public void set(String[] keys, Object[] values) {
        this.redisTemplate.execute(connection -> {
            RedisSerializer<String> serializer = this.getRedisSerializer();
            for (int i = 0; i < keys.length; ++i) {
                byte[] bKeys = serializer.serialize((Object)keys[i]);
                byte[] bValues = OBJECT_SERIALIZER.serialize(values[i]);
                connection.set(bKeys, bValues);
            }
            return 1L;
        });
    }

    @Override
    public void set(String key, Object value) {
        this.redisTemplate.execute(connection -> {
            RedisSerializer<String> serializer = this.getRedisSerializer();
            byte[] keys = serializer.serialize((Object)key);
            byte[] values = OBJECT_SERIALIZER.serialize(value);
            connection.set(keys, values);
            log.debug("[redisTemplate redis]\u653e\u5165 \u7f13\u5b58  url:{}", (Object)key);
            return 1L;
        });
    }

    public List<String> willExpire(String key, long time) {
        if (StrUtil.isEmpty((CharSequence)key)) {
            return Collections.emptyList();
        }
        if ("*".equals(key.trim())) {
            throw new IllegalArgumentException("\u7981\u6b62\u6a21\u7cca\u67e5\u8be2\u6240\u6709\u7684key");
        }
        ArrayList<String> keysList = new ArrayList<String>();
        this.redisTemplate.execute(connection -> {
            Set keys = this.redisTemplate.keys((Object)(key + "*"));
            for (String key1 : keys) {
                Long ttl = connection.ttl(key1.getBytes(DEFAULT_CHARSET));
                if (0L > ttl || ttl > 2L * time) continue;
                keysList.add(key1);
            }
            return keysList;
        });
        return keysList;
    }

    public Set<String> keys(String keyPatten) {
        if (StrUtil.isEmpty((CharSequence)keyPatten)) {
            return Collections.emptySet();
        }
        if ("*".equals(keyPatten.trim())) {
            throw new IllegalArgumentException("\u7981\u6b62\u6a21\u7cca\u67e5\u8be2\u6240\u6709\u7684key");
        }
        return (Set)this.redisTemplate.execute(connection -> this.redisTemplate.keys((Object)(keyPatten + "*")));
    }

    public byte[] get(byte[] key) {
        byte[] result = (byte[])this.redisTemplate.execute(connection -> connection.get(key));
        log.debug("[redisTemplate redis]\u53d6\u51fa \u7f13\u5b58  url:{} ", (Object)key);
        return result;
    }

    @Override
    public <T> T get(String key) {
        Object resultStr = this.redisTemplate.execute(connection -> {
            RedisSerializer<String> serializer = this.getRedisSerializer();
            byte[] keys = serializer.serialize((Object)key);
            byte[] values = connection.get(keys);
            return OBJECT_SERIALIZER.deserialize(values);
        });
        log.debug("[redisTemplate redis]\u53d6\u51fa \u7f13\u5b58  url:{} ", (Object)key);
        return (T)resultStr;
    }

    @Override
    public <T> T getOrDef(String key, Function<String, ? extends T> function) {
        T resultStr = this.get(key);
        if (resultStr == null) {
            T value = function.apply(key);
            if (value != null) {
                this.set(key, value);
            }
            return value;
        }
        return resultStr;
    }

    public Map<String, Object> getKeysValues(String keyPatten) {
        log.debug("[redisTemplate redis]  getValues()  patten={} ", (Object)keyPatten);
        return (Map)this.redisTemplate.execute(connection -> {
            RedisSerializer<String> serializer = this.getRedisSerializer();
            HashMap<String, Object> maps = new HashMap<String, Object>(16);
            Set keys = this.redisTemplate.keys((Object)(keyPatten + "*"));
            if (CollectionUtil.isNotEmpty((Collection)keys)) {
                for (String key : keys) {
                    byte[] bKeys = serializer.serialize((Object)key);
                    byte[] bValues = connection.get(bKeys);
                    Object value = OBJECT_SERIALIZER.deserialize(bValues);
                    maps.put(key, value);
                }
            }
            return maps;
        });
    }

    public <T> HashOperations<String, String, T> opsForHash() {
        return this.redisTemplate.opsForHash();
    }

    public void putHashValue(String key, String hashKey, Object hashValue) {
        log.debug("[redisTemplate redis]  putHashValue()  key={},hashKey={},hashValue={} ", new Object[]{key, hashKey, hashValue});
        this.opsForHash().put((Object)key, (Object)hashKey, hashValue);
    }

    public <T> T getHashValues(String key, String hashKey) {
        log.debug("[redisTemplate redis]  getHashValues()  key={},hashKey={}", (Object)key, (Object)hashKey);
        return (T)this.opsForHash().get((Object)key, (Object)hashKey);
    }

    public void delHashValues(String key, Object ... hashKeys) {
        log.debug("[redisTemplate redis]  delHashValues()  key={}", (Object)key);
        this.opsForHash().delete((Object)key, hashKeys);
    }

    public Map<String, Object> getHashValue(String key) {
        log.debug("[redisTemplate redis]  getHashValue()  key={}", (Object)key);
        return this.opsForHash().entries((Object)key);
    }

    public void putHashValues(String key, Map<String, Object> map) {
        this.opsForHash().putAll((Object)key, map);
    }

    public long dbSize() {
        return (Long)this.redisTemplate.execute(RedisServerCommands::dbSize);
    }

    @Override
    public void flushDb() {
        this.redisTemplate.execute(connection -> {
            connection.flushDb();
            return "ok";
        });
    }

    @Override
    public boolean exists(String key) {
        return (Boolean)this.redisTemplate.execute(connection -> connection.exists(key.getBytes(DEFAULT_CHARSET)));
    }

    @Override
    public long del(String ... keys) {
        return (Long)this.redisTemplate.execute(connection -> {
            long result = 0L;
            for (String key : keys) {
                result += connection.del((byte[][])new byte[][]{key.getBytes(DEFAULT_CHARSET)}).longValue();
            }
            return result;
        });
    }

    protected RedisSerializer<String> getRedisSerializer() {
        return this.redisTemplate.getStringSerializer();
    }

    public long incr(String key) {
        return (Long)this.redisTemplate.execute(connection -> {
            RedisSerializer<String> redisSerializer = this.getRedisSerializer();
            return connection.incr(redisSerializer.serialize((Object)key));
        });
    }

    public ListOperations<String, Object> opsForList() {
        return this.redisTemplate.opsForList();
    }

    public Long leftPush(String key, Object value) {
        return this.opsForList().leftPush((Object)key, value);
    }

    public Object leftPop(String key) {
        return this.opsForList().leftPop((Object)key);
    }

    public Long rightPush(String key, Object value) {
        return this.opsForList().rightPush((Object)key, value);
    }

    public Object rightPop(String key) {
        return this.opsForList().rightPop((Object)key);
    }

    public Long length(String key) {
        return this.opsForList().size((Object)key);
    }

    public void remove(String key, long i, Object value) {
        this.opsForList().remove((Object)key, i, value);
    }

    public void set(String key, long index, Object value) {
        this.opsForList().set((Object)key, index, value);
    }

    public <T> List<T> getList(String key, int start, int end) {
        return this.opsForList().range((Object)key, (long)start, (long)end);
    }

    public <V> Long leftPushAll(String key, List<V> list) {
        return this.opsForList().leftPushAll((Object)key, new Object[]{list});
    }

    public void insert(String key, long index, Object value) {
        this.opsForList().set((Object)key, index, value);
    }
}

