/*
 * Decompiled with CFR 0.152.
 */
package com.github.zuihou.cache.model;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.StrUtil;
import com.github.zuihou.cache.model.CacheHashKey;
import com.github.zuihou.cache.model.CacheKey;
import com.github.zuihou.context.BaseContextHandler;
import java.time.Duration;
import java.util.ArrayList;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

@FunctionalInterface
public interface CacheKeyBuilder {
    @NonNull
    default public String getTenant() {
        return BaseContextHandler.getTenant();
    }

    @NonNull
    public String getPrefix();

    @Nullable
    default public Duration getExpire() {
        return null;
    }

    default public CacheKey key(Object ... suffix) {
        String field = suffix.length > 0 ? Convert.toStr((Object)suffix[0], (String)"") : "";
        return this.hashKey(field, suffix);
    }

    default public CacheHashKey hashKey(@NonNull Object field, Object ... suffix) {
        String region;
        String prefix;
        ArrayList<String> regionList = new ArrayList<String>();
        String tenant = this.getTenant();
        if (StrUtil.isNotEmpty((CharSequence)tenant)) {
            regionList.add(tenant);
        }
        if (StrUtil.isNotEmpty((CharSequence)(prefix = this.getPrefix()))) {
            regionList.add(prefix);
        }
        String key = region = CollUtil.join(regionList, (CharSequence)":");
        if (suffix.length > 0) {
            key = StrUtil.join((CharSequence)":", (Object[])new Object[]{region, suffix});
        }
        Assert.hasText((String)key, (String)"key \u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)field, (String)"field \u4e0d\u80fd\u4e3a\u7a7a");
        return new CacheHashKey(key, field, this.getExpire());
    }
}

