/*
 * Decompiled with CFR 0.152.
 */
package com.github.zuihou.cache.redis;

import cn.hutool.core.convert.Convert;
import com.github.zuihou.cache.model.CacheHashKey;
import com.github.zuihou.cache.model.CacheKey;
import com.github.zuihou.cache.redis.NullVal;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.core.DefaultTypedTuple;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.ListOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.SetOperations;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class RedisOps {
    private static final Map<String, Object> KEY_LOCKS = new ConcurrentHashMap<String, Object>();
    private final RedisTemplate<String, Object> redisTemplate;
    private final ValueOperations<String, Object> valueOps;
    private final HashOperations<String, Object, Object> hashOps;
    private final ListOperations<String, Object> listOps;
    private final SetOperations<String, Object> setOps;
    private final ZSetOperations<String, Object> zSetOps;
    private final boolean defaultCacheNullVal;

    public RedisOps(RedisTemplate<String, Object> redisTemplate, boolean defaultCacheNullVal) {
        this.redisTemplate = redisTemplate;
        Assert.notNull(redisTemplate, (String)"redisTemplate \u4e3a\u7a7a");
        this.valueOps = redisTemplate.opsForValue();
        this.hashOps = redisTemplate.opsForHash();
        this.listOps = redisTemplate.opsForList();
        this.setOps = redisTemplate.opsForSet();
        this.zSetOps = redisTemplate.opsForZSet();
        this.defaultCacheNullVal = defaultCacheNullVal;
    }

    private NullVal newNullVal() {
        return new NullVal();
    }

    private <T> boolean isNullVal(T value) {
        return value == null || value.getClass().equals(NullVal.class) || value.getClass().equals(Object.class) || value instanceof Map && ((Map)value).isEmpty();
    }

    public Long del(CacheKey ... keys) {
        return this.redisTemplate.delete((Collection)Arrays.stream(keys).map(CacheKey::getKey).collect(Collectors.toList()));
    }

    public Long del(String ... keys) {
        return this.del(Arrays.asList(keys));
    }

    public Long del(@NonNull Collection<String> keys) {
        return this.redisTemplate.delete(keys);
    }

    public Set<String> keys(@NonNull String pattern) {
        return this.redisTemplate.keys((Object)pattern);
    }

    public Boolean exists(@NonNull String key) {
        return this.redisTemplate.hasKey((Object)key);
    }

    public String randomKey() {
        return (String)this.redisTemplate.randomKey();
    }

    public void rename(@NonNull String oldKey, @NonNull String newKey) {
        this.redisTemplate.rename((Object)oldKey, (Object)newKey);
    }

    public Boolean renameNx(@NonNull String oldKey, String newKey) {
        return this.redisTemplate.renameIfAbsent((Object)oldKey, (Object)newKey);
    }

    public Boolean move(@NonNull String key, int dbIndex) {
        return this.redisTemplate.move((Object)key, dbIndex);
    }

    public Boolean expire(@NonNull String key, long seconds) {
        Assert.hasText((String)key, (String)"key\u4e0d\u80fd\u4e3a\u7a7a");
        return this.redisTemplate.expire((Object)key, seconds, TimeUnit.SECONDS);
    }

    public Boolean expire(@NonNull String key, @NonNull Duration timeout) {
        return this.expire(key, timeout.getSeconds());
    }

    public Boolean expireAt(@NonNull String key, @NonNull Date date) {
        return this.redisTemplate.expireAt((Object)key, date);
    }

    public Boolean expireAt(@NonNull String key, long unixTimestamp) {
        return this.expireAt(key, new Date(unixTimestamp));
    }

    public Boolean pExpire(@NonNull String key, long milliseconds) {
        return this.redisTemplate.expire((Object)key, milliseconds, TimeUnit.MILLISECONDS);
    }

    public Boolean persist(@NonNull String key) {
        return this.redisTemplate.persist((Object)key);
    }

    public String type(@NonNull String key) {
        DataType type = this.redisTemplate.type((Object)key);
        return type == null ? DataType.NONE.code() : type.code();
    }

    public Long ttl(@NonNull String key) {
        return this.redisTemplate.getExpire((Object)key);
    }

    public Long pTtl(@NonNull String key) {
        return this.redisTemplate.getExpire((Object)key, TimeUnit.MILLISECONDS);
    }

    public void set(@NonNull String key, Object value, boolean ... cacheNullValues) {
        boolean cacheNullVal;
        Assert.notNull((Object)key, (String)"key\u4e0d\u80fd\u4e3a\u7a7a");
        boolean bl = cacheNullVal = cacheNullValues.length > 0 ? cacheNullValues[0] : this.defaultCacheNullVal;
        if (!cacheNullVal && value == null) {
            return;
        }
        this.valueOps.set((Object)key, value == null ? this.newNullVal() : value);
    }

    public void set(@NonNull CacheKey cacheKey, Object value, boolean ... cacheNullValues) {
        boolean cacheNullVal = cacheNullValues.length > 0 ? cacheNullValues[0] : this.defaultCacheNullVal;
        Assert.notNull((Object)cacheKey, (String)"CacheKey\u4e0d\u80fd\u4e3a\u7a7a");
        String key = cacheKey.getKey();
        Duration expire = cacheKey.getExpire();
        if (expire == null) {
            this.set(key, value, cacheNullVal);
        } else {
            this.setEx(key, value, expire, cacheNullVal);
        }
    }

    public void setEx(@NonNull String key, Object value, Duration timeout, boolean ... cacheNullValues) {
        boolean cacheNullVal;
        Assert.notNull((Object)key, (String)"key\u4e0d\u80fd\u4e3a\u7a7a");
        boolean bl = cacheNullVal = cacheNullValues.length > 0 ? cacheNullValues[0] : this.defaultCacheNullVal;
        if (!cacheNullVal && value == null) {
            return;
        }
        this.valueOps.set((Object)key, value == null ? this.newNullVal() : value, timeout);
    }

    public void setEx(@NonNull String key, Object value, long seconds, boolean ... cacheNullValues) {
        this.setEx(key, value, Duration.ofSeconds(seconds), cacheNullValues);
    }

    @Nullable
    public Boolean setXx(@NonNull String key, String value, boolean ... cacheNullValues) {
        boolean cacheNullVal = cacheNullValues.length > 0 ? cacheNullValues[0] : this.defaultCacheNullVal;
        return this.valueOps.setIfPresent((Object)key, cacheNullVal && value == null ? this.newNullVal() : value);
    }

    @Nullable
    public Boolean setXx(@NonNull String key, String value, long seconds, boolean ... cacheNullValues) {
        boolean cacheNullVal = cacheNullValues.length > 0 ? cacheNullValues[0] : this.defaultCacheNullVal;
        return this.valueOps.setIfPresent((Object)key, cacheNullVal && value == null ? this.newNullVal() : value, seconds, TimeUnit.SECONDS);
    }

    @Nullable
    public Boolean setXx(@NonNull String key, String value, Duration timeout, boolean ... cacheNullValues) {
        boolean cacheNullVal = cacheNullValues.length > 0 ? cacheNullValues[0] : this.defaultCacheNullVal;
        return this.valueOps.setIfPresent((Object)key, cacheNullVal && value == null ? this.newNullVal() : value, timeout);
    }

    @Nullable
    public Boolean setNx(@NonNull String key, String value, boolean ... cacheNullValues) {
        boolean cacheNullVal = cacheNullValues.length > 0 ? cacheNullValues[0] : this.defaultCacheNullVal;
        return this.valueOps.setIfAbsent((Object)key, cacheNullVal && value == null ? this.newNullVal() : value);
    }

    @Nullable
    public <T> T get(@NonNull String key, boolean ... cacheNullValues) {
        boolean cacheNullVal = cacheNullValues.length > 0 ? cacheNullValues[0] : this.defaultCacheNullVal;
        Object value = this.valueOps.get((Object)key);
        if (value == null && cacheNullVal) {
            this.set(key, (Object)this.newNullVal(), true);
        }
        return (T)(this.isNullVal(value) ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <T> T get(@NonNull String key, Function<String, T> loader, boolean ... cacheNullValues) {
        boolean cacheNullVal = cacheNullValues.length > 0 ? cacheNullValues[0] : this.defaultCacheNullVal;
        T value = this.get(key, false);
        if (value != null) {
            return this.isNullVal(value) ? null : (T)value;
        }
        Object object = KEY_LOCKS.computeIfAbsent(key, v -> new Object());
        synchronized (object) {
            value = this.get(key, false);
            if (value != null) {
                return this.isNullVal(value) ? null : (T)value;
            }
            try {
                value = loader.apply(key);
                this.set(key, value, cacheNullVal);
            }
            finally {
                KEY_LOCKS.remove(key);
            }
        }
        return this.isNullVal(value) ? null : (T)value;
    }

    public <T> T getSet(@NonNull String key, Object value) {
        Object val = this.valueOps.getAndSet((Object)key, value == null ? this.newNullVal() : value);
        return (T)(this.isNullVal(val) ? null : val);
    }

    @Nullable
    public <T> T get(@NonNull CacheKey key, boolean ... cacheNullValues) {
        boolean cacheNullVal = cacheNullValues.length > 0 ? cacheNullValues[0] : this.defaultCacheNullVal;
        Assert.notNull((Object)key, (String)"CacheKey\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)key.getKey(), (String)"Key\u4e0d\u80fd\u4e3a\u7a7a");
        Object value = this.valueOps.get((Object)key.getKey());
        if (value == null && cacheNullVal) {
            this.set(key, (Object)this.newNullVal(), true);
        }
        return (T)(this.isNullVal(value) ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <T> T get(@NonNull CacheKey key, Function<CacheKey, T> loader, boolean ... cacheNullValues) {
        boolean cacheNullVal = cacheNullValues.length > 0 ? cacheNullValues[0] : this.defaultCacheNullVal;
        T value = this.get(key, false);
        if (value != null) {
            return this.isNullVal(value) ? null : (T)value;
        }
        Object object = KEY_LOCKS.computeIfAbsent(key.getKey(), v -> new Object());
        synchronized (object) {
            value = this.get(key, false);
            if (value != null) {
                return this.isNullVal(value) ? null : (T)value;
            }
            try {
                value = loader.apply(key);
                this.set(key, value, cacheNullVal);
            }
            finally {
                KEY_LOCKS.remove(key.getKey());
            }
        }
        return this.isNullVal(value) ? null : (T)value;
    }

    @Nullable
    public Long strLen(@NonNull String key) {
        return this.valueOps.size((Object)key);
    }

    @Nullable
    public Integer append(@NonNull String key, String value) {
        return this.valueOps.append((Object)key, value);
    }

    public void setRange(@NonNull String key, String value, long offset) {
        this.valueOps.set((Object)key, (Object)value, offset);
    }

    public String getRange(@NonNull String key, long start, long end) {
        return this.valueOps.get((Object)key, start, end);
    }

    public void mSet(@NonNull Map<String, Object> map, boolean cacheNullVal) {
        Map<String, Object> mSetMap = this.mSetMap(map, cacheNullVal);
        this.valueOps.multiSet(mSetMap);
    }

    public void mSet(@NonNull Map<String, Object> map) {
        this.mSet(map, this.defaultCacheNullVal);
    }

    public void mSetNx(@NonNull Map<String, Object> map, boolean cacheNullVal) {
        Map<String, Object> mSetMap = this.mSetMap(map, cacheNullVal);
        this.valueOps.multiSetIfAbsent(mSetMap);
    }

    public void mSetNx(@NonNull Map<String, Object> map) {
        this.mSetNx(map, this.defaultCacheNullVal);
    }

    private Map<String, Object> mSetMap(@NonNull Map<String, Object> map, boolean cacheNullVal) {
        HashMap<String, Object> mSetMap = new HashMap<String, Object>((int)((double)map.size() * 1.5));
        map.forEach((k, v) -> {
            if (v == null && cacheNullVal) {
                mSetMap.put((String)k, this.newNullVal());
            } else {
                mSetMap.put((String)k, v);
            }
        });
        return mSetMap;
    }

    public <T> List<T> mGet(String ... keys) {
        return this.mGet(Arrays.asList(keys));
    }

    public <T> List<T> mGet(CacheKey ... keys) {
        return this.mGetByCacheKey(Arrays.asList(keys));
    }

    public <T> List<T> mGet(@NonNull Collection<String> keys) {
        List list = this.valueOps.multiGet(keys);
        return list == null ? null : list.stream().map(item -> this.isNullVal(item) ? null : item).collect(Collectors.toList());
    }

    public <T> List<T> mGetByCacheKey(@NonNull Collection<CacheKey> cacheKeys) {
        List keys = cacheKeys.stream().map(CacheKey::getKey).collect(Collectors.toList());
        List list = this.valueOps.multiGet(keys);
        return list == null ? null : list.stream().map(item -> this.isNullVal(item) ? null : item).collect(Collectors.toList());
    }

    public Long incr(@NonNull String key) {
        return this.valueOps.increment((Object)key);
    }

    public Long incrBy(@NonNull String key, long increment) {
        return this.valueOps.increment((Object)key, increment);
    }

    public Double incrByFloat(@NonNull String key, double increment) {
        return this.valueOps.increment((Object)key, increment);
    }

    public Long getCounter(@NonNull String key, Long ... defaultValue) {
        Object val = this.valueOps.get((Object)key);
        if (this.isNullVal(val)) {
            return defaultValue.length > 0 ? Convert.toLong((Object)defaultValue[0]) : null;
        }
        return Convert.toLong((Object)val);
    }

    public Long decr(@NonNull String key) {
        return this.valueOps.decrement((Object)key);
    }

    public Long decrBy(@NonNull String key, long decrement) {
        return this.valueOps.decrement((Object)key, decrement);
    }

    public void hSet(@NonNull String key, @NonNull Object field, Object value, boolean ... cacheNullValues) {
        boolean cacheNullVal;
        Assert.hasText((String)key, (String)"key\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)field, (String)"field\u4e0d\u80fd\u4e3a\u7a7a");
        boolean bl = cacheNullVal = cacheNullValues.length > 0 ? cacheNullValues[0] : this.defaultCacheNullVal;
        if (!cacheNullVal && value == null) {
            return;
        }
        this.hashOps.put((Object)key, field, value == null ? this.newNullVal() : value);
    }

    public void hSet(@NonNull CacheHashKey cacheHashKey, Object value, boolean ... cacheNullValues) {
        Assert.notNull((Object)cacheHashKey, (String)"CacheHashKey\u4e0d\u80fd\u4e3a\u7a7a");
        this.hSet(cacheHashKey.getKey(), cacheHashKey.getField(), value, cacheNullValues);
        if (cacheHashKey.getExpire() != null) {
            this.expire(cacheHashKey.getKey(), cacheHashKey.getExpire());
        }
    }

    @Nullable
    public <T> T hGet(@NonNull String key, @NonNull Object field, boolean ... cacheNullValues) {
        boolean cacheNullVal = cacheNullValues.length > 0 ? cacheNullValues[0] : this.defaultCacheNullVal;
        Object value = this.hashOps.get((Object)key, field);
        if (value == null && cacheNullVal) {
            this.hSet(key, field, this.newNullVal(), true);
        }
        return (T)(this.isNullVal(value) ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <T> T hGet(@NonNull String key, @NonNull Object field, BiFunction<String, Object, T> loader, boolean ... cacheNullValues) {
        boolean cacheNullVal = cacheNullValues.length > 0 ? cacheNullValues[0] : this.defaultCacheNullVal;
        T value = this.hGet(key, field, false);
        if (value != null) {
            return this.isNullVal(value) ? null : (T)value;
        }
        String lockKey = key + "@" + field;
        Object object = KEY_LOCKS.computeIfAbsent(lockKey, v -> new Object());
        synchronized (object) {
            value = this.hGet(key, field, false);
            if (value != null) {
                return this.isNullVal(value) ? null : (T)value;
            }
            try {
                value = loader.apply(key, field);
                this.hSet(key, field, value, cacheNullVal);
            }
            finally {
                KEY_LOCKS.remove(lockKey);
            }
        }
        return this.isNullVal(value) ? null : (T)value;
    }

    @Nullable
    public <T> T hGet(@NonNull CacheHashKey key, boolean ... cacheNullValues) {
        boolean cacheNullVal = cacheNullValues.length > 0 ? cacheNullValues[0] : this.defaultCacheNullVal;
        Assert.notNull((Object)key, (String)"CacheHashKey\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)key.getKey(), (String)"key\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)key.getField(), (String)"field\u4e0d\u80fd\u4e3a\u7a7a");
        Object value = this.hashOps.get((Object)key.getKey(), key.getField());
        if (value == null && cacheNullVal) {
            this.hSet(key, (Object)this.newNullVal(), true);
        }
        return (T)(this.isNullVal(value) ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <T> T hGet(@NonNull CacheHashKey key, Function<CacheHashKey, T> loader, boolean ... cacheNullValues) {
        boolean cacheNullVal = cacheNullValues.length > 0 ? cacheNullValues[0] : this.defaultCacheNullVal;
        T value = this.hGet(key, false);
        if (value != null) {
            return this.isNullVal(value) ? null : (T)value;
        }
        String lockKey = key.getKey() + "@" + key.getField();
        Object object = KEY_LOCKS.computeIfAbsent(lockKey, v -> new Object());
        synchronized (object) {
            value = this.hGet(key, false);
            if (value != null) {
                return this.isNullVal(value) ? null : (T)value;
            }
            try {
                value = loader.apply(key);
                this.hSet(key, value, cacheNullVal);
            }
            finally {
                KEY_LOCKS.remove(key.getKey());
            }
        }
        return this.isNullVal(value) ? null : (T)value;
    }

    public Boolean hExists(@NonNull String key, @NonNull Object field) {
        return this.hashOps.hasKey((Object)key, field);
    }

    public Boolean hExists(@NonNull CacheHashKey cacheHashKey) {
        return this.hashOps.hasKey((Object)cacheHashKey.getKey(), cacheHashKey.getField());
    }

    public Long hDel(@NonNull String key, Object ... fields) {
        return this.hashOps.delete((Object)key, fields);
    }

    public Long hLen(@NonNull String key) {
        return this.hashOps.size((Object)key);
    }

    public Long hStrLen(@NonNull String key, @NonNull Object field) {
        return this.hashOps.lengthOfValue((Object)key, field);
    }

    public Long hIncrBy(@NonNull String key, @NonNull Object field, long increment) {
        return this.hashOps.increment((Object)key, field, increment);
    }

    public Double hIncrByFloat(@NonNull String key, @NonNull Object field, double increment) {
        return this.hashOps.increment((Object)key, field, increment);
    }

    public void hmSet(@NonNull String key, @NonNull Map<Object, Object> hash, boolean ... cacheNullValues) {
        boolean cacheNullVal = cacheNullValues.length > 0 ? cacheNullValues[0] : this.defaultCacheNullVal;
        HashMap newMap = new HashMap((int)((double)hash.size() * 1.5));
        hash.forEach((k, v) -> {
            if (v == null && cacheNullVal) {
                newMap.put(k, this.newNullVal());
            } else {
                newMap.put(k, v);
            }
        });
        this.hashOps.putAll((Object)key, newMap);
    }

    public List<Object> hmGet(@NonNull String key, Object ... fields) {
        return this.hmGet(key, Arrays.asList(fields));
    }

    public List<Object> hmGet(@NonNull String key, @NonNull Collection<Object> fields) {
        List list = this.hashOps.multiGet((Object)key, fields);
        return list.stream().map(item -> this.isNullVal(item) ? null : item).collect(Collectors.toList());
    }

    public Set<Object> hKeys(@NonNull String key) {
        return this.hashOps.keys((Object)key);
    }

    public List<Object> hVals(@NonNull String key) {
        return this.hashOps.values((Object)key);
    }

    public Map<Object, Object> hGetAll(@NonNull String key) {
        return this.hashOps.entries((Object)key);
    }

    @Nullable
    public Long lPush(@NonNull String key, Object ... values) {
        return this.listOps.leftPushAll((Object)key, values);
    }

    @Nullable
    public Long lPush(@NonNull String key, Collection<Object> values) {
        return this.listOps.leftPushAll((Object)key, values);
    }

    @Nullable
    public Long lPushX(@NonNull String key, Object values) {
        return this.listOps.leftPushIfPresent((Object)key, values);
    }

    @Nullable
    public Long rPush(@NonNull String key, Object ... values) {
        return this.listOps.rightPushAll((Object)key, values);
    }

    @Nullable
    public Long rPush(@NonNull String key, Collection<Object> values) {
        return this.listOps.rightPushAll((Object)key, values);
    }

    @Nullable
    public Long rPushX(@NonNull String key, Object value) {
        return this.listOps.rightPushIfPresent((Object)key, value);
    }

    @Nullable
    public <T> T lPop(@NonNull String key) {
        return (T)this.listOps.leftPop((Object)key);
    }

    public <T> T rPop(@NonNull String key) {
        return (T)this.listOps.rightPop((Object)key);
    }

    public <T> T rPoplPush(String sourceKey, String destinationKey) {
        return (T)this.listOps.rightPopAndLeftPush((Object)sourceKey, (Object)destinationKey);
    }

    @Nullable
    public Long lRem(@NonNull String key, long count, Object value) {
        return this.listOps.remove((Object)key, count, value);
    }

    @Nullable
    public Long lLen(@NonNull String key) {
        return this.listOps.size((Object)key);
    }

    @Nullable
    public <T> T lIndex(@NonNull String key, long index) {
        return (T)this.listOps.index((Object)key, index);
    }

    @Nullable
    public Long lInsert(@NonNull String key, Object pivot, Object value) {
        return this.listOps.leftPush((Object)key, pivot, value);
    }

    @Nullable
    public Long rInsert(@NonNull String key, Object pivot, Object value) {
        return this.listOps.rightPush((Object)key, pivot, value);
    }

    public void lSet(@NonNull String key, long index, Object value) {
        this.listOps.set((Object)key, index, value);
    }

    @Nullable
    public List<Object> lRange(@NonNull String key, long start, long end) {
        return this.listOps.range((Object)key, start, end);
    }

    public void lTrim(@NonNull String key, long start, long end) {
        this.listOps.trim((Object)key, start, end);
    }

    public Long sAdd(@NonNull String key, Object ... members) {
        return this.setOps.add((Object)key, members);
    }

    public Long sAdd(@NonNull String key, Collection<Object> members) {
        return this.setOps.add((Object)key, members.toArray());
    }

    public Boolean sIsMember(@NonNull String key, Object member) {
        return this.setOps.isMember((Object)key, member);
    }

    @Nullable
    public <T> T sPop(@NonNull String key) {
        return (T)this.setOps.pop((Object)key);
    }

    @Nullable
    public <T> T sRandMember(@NonNull String key) {
        return (T)this.setOps.randomMember((Object)key);
    }

    @Nullable
    public Set<Object> sRandMember(@NonNull String key, long count) {
        return this.setOps.distinctRandomMembers((Object)key, count);
    }

    @Nullable
    public List<Object> sRandMembers(@NonNull String key, long count) {
        return this.setOps.randomMembers((Object)key, count);
    }

    @Nullable
    public Long sRem(@NonNull String key, Object ... members) {
        return this.setOps.remove((Object)key, members);
    }

    public Boolean sMove(@NonNull String sourceKey, String destinationKey, Object value) {
        return this.setOps.move((Object)sourceKey, value, (Object)destinationKey);
    }

    public Long sCard(@NonNull String key) {
        return this.setOps.size((Object)key);
    }

    @Nullable
    public Set<Object> sMembers(@NonNull String key) {
        return this.setOps.members((Object)key);
    }

    @Nullable
    public Set<Object> sInter(@NonNull String key, @NonNull String otherKey) {
        return this.setOps.intersect((Object)key, (Object)otherKey);
    }

    @Nullable
    public Set<Object> sInter(@NonNull String key, Collection<String> otherKeys) {
        return this.setOps.intersect((Object)key, otherKeys);
    }

    @Nullable
    public Set<Object> sInter(Collection<String> otherKeys) {
        return this.setOps.intersect(otherKeys);
    }

    @Nullable
    public Long sInterStore(@NonNull String key, @NonNull String otherKey, @NonNull String destKey) {
        return this.setOps.intersectAndStore((Object)key, (Object)otherKey, (Object)destKey);
    }

    @Nullable
    public Long sInterStore(@NonNull String key, Collection<String> otherKeys, @NonNull String destKey) {
        return this.setOps.intersectAndStore((Object)key, otherKeys, (Object)destKey);
    }

    @Nullable
    public Long sInterStore(Collection<String> otherKeys, @NonNull String destKey) {
        return this.setOps.intersectAndStore(otherKeys, (Object)destKey);
    }

    @Nullable
    public Set<Object> sUnion(@NonNull String key, @NonNull String otherKey) {
        return this.setOps.union((Object)key, (Object)otherKey);
    }

    @Nullable
    public Set<Object> sUnion(@NonNull String key, Collection<String> otherKeys) {
        return this.setOps.union((Object)key, otherKeys);
    }

    @Nullable
    public Set<Object> sUnion(Collection<String> otherKeys) {
        return this.setOps.union(otherKeys);
    }

    public Long sUnionStore(@NonNull String key, @NonNull String otherKey, @NonNull String distKey) {
        return this.setOps.unionAndStore((Object)key, (Object)otherKey, (Object)distKey);
    }

    public Long sUnionStore(Collection<String> otherKeys, @NonNull String distKey) {
        return this.setOps.unionAndStore(otherKeys, (Object)distKey);
    }

    @Nullable
    public Set<Object> sDiff(@NonNull String key, @NonNull String otherKey) {
        return this.setOps.difference((Object)key, (Object)otherKey);
    }

    public Set<Object> sDiff(Collection<String> otherKeys) {
        return this.setOps.difference(otherKeys);
    }

    public Long sDiffStore(@NonNull String key, @NonNull String otherKey, @NonNull String distKey) {
        return this.setOps.differenceAndStore((Object)key, (Object)otherKey, (Object)distKey);
    }

    public Long sDiffStore(Collection<String> otherKeys, @NonNull String distKey) {
        return this.setOps.differenceAndStore(otherKeys, (Object)distKey);
    }

    public Boolean zAdd(@NonNull String key, Object member, double score) {
        return this.zSetOps.add((Object)key, member, score);
    }

    public Long zAdd(@NonNull String key, Map<Object, Double> scoreMembers) {
        HashSet tuples = new HashSet();
        scoreMembers.forEach((score, member) -> tuples.add(new DefaultTypedTuple(score, member)));
        return this.zSetOps.add((Object)key, tuples);
    }

    public Double zScore(@NonNull String key, Object member) {
        return this.zSetOps.score((Object)key, member);
    }

    public Double zIncrBy(@NonNull String key, Object member, double score) {
        return this.zSetOps.incrementScore((Object)key, member, score);
    }

    public Long zCard(@NonNull String key) {
        return this.zSetOps.zCard((Object)key);
    }

    public Long zCount(@NonNull String key, double min, double max) {
        return this.zSetOps.count((Object)key, min, max);
    }

    @Nullable
    public Set<Object> zRange(@NonNull String key, long start, long end) {
        return this.zSetOps.range((Object)key, start, end);
    }

    @Nullable
    public Set<ZSetOperations.TypedTuple<Object>> zRangeWithScores(@NonNull String key, long start, long end) {
        return this.zSetOps.rangeWithScores((Object)key, start, end);
    }

    @Nullable
    public Set<Object> zRevrange(@NonNull String key, long start, long end) {
        return this.zSetOps.reverseRange((Object)key, start, end);
    }

    @Nullable
    public Set<ZSetOperations.TypedTuple<Object>> zRevrangeWithScores(@NonNull String key, long start, long end) {
        return this.zSetOps.reverseRangeWithScores((Object)key, start, end);
    }

    public Set<Object> zRangeByScore(@NonNull String key, double min, double max) {
        return this.zSetOps.rangeByScore((Object)key, min, max);
    }

    public Set<ZSetOperations.TypedTuple<Object>> zRangeByScoreWithScores(@NonNull String key, double min, double max) {
        return this.zSetOps.rangeByScoreWithScores((Object)key, min, max);
    }

    public Set<Object> zReverseRange(@NonNull String key, double min, double max) {
        return this.zSetOps.reverseRangeByScore((Object)key, min, max);
    }

    public Set<ZSetOperations.TypedTuple<Object>> zReverseRangeByScoreWithScores(@NonNull String key, double min, double max) {
        return this.zSetOps.reverseRangeByScoreWithScores((Object)key, min, max);
    }

    @Nullable
    public Long zRank(@NonNull String key, Object member) {
        return this.zSetOps.rank((Object)key, member);
    }

    public Long zRevrank(@NonNull String key, Object member) {
        return this.zSetOps.reverseRank((Object)key, member);
    }

    public Long zRem(@NonNull String key, Object ... members) {
        return this.zSetOps.remove((Object)key, members);
    }

    public Long zRem(@NonNull String key, long start, long end) {
        return this.zSetOps.removeRange((Object)key, start, end);
    }

    public Long zRemRangeByScore(@NonNull String key, double min, double max) {
        return this.zSetOps.removeRangeByScore((Object)key, min, max);
    }

    public RedisTemplate<String, Object> getRedisTemplate() {
        return this.redisTemplate;
    }

    public ValueOperations<String, Object> getValueOps() {
        return this.valueOps;
    }

    public HashOperations<String, Object, Object> getHashOps() {
        return this.hashOps;
    }

    public ListOperations<String, Object> getListOps() {
        return this.listOps;
    }

    public SetOperations<String, Object> getSetOps() {
        return this.setOps;
    }

    public ZSetOperations<String, Object> getZSetOps() {
        return this.zSetOps;
    }

    public boolean isDefaultCacheNullVal() {
        return this.defaultCacheNullVal;
    }
}

