/*
 * Decompiled with CFR 0.152.
 */
package com.github.zuihou.cache.repository.impl;

import cn.hutool.core.util.StrUtil;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.zuihou.cache.model.CacheHashKey;
import com.github.zuihou.cache.model.CacheKey;
import com.github.zuihou.cache.repository.CacheOps;
import com.github.zuihou.cache.repository.CachePlusOps;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Collectors;

public class CaffeineOpsImpl
implements CacheOps,
CachePlusOps {
    long DEF_MAX_SIZE = 1000L;
    private final Cache<String, Cache<String, Object>> cacheMap = Caffeine.newBuilder().maximumSize(this.DEF_MAX_SIZE).build();

    @Override
    public Long del(CacheKey ... keys) {
        for (CacheKey key : keys) {
            this.cacheMap.invalidate((Object)key.getKey());
        }
        return keys.length;
    }

    @Override
    public void set(CacheKey key, Object value, boolean ... cacheNullValues) {
        if (value == null) {
            return;
        }
        Caffeine builder = Caffeine.newBuilder().maximumSize(this.DEF_MAX_SIZE);
        if (key.getExpire() != null) {
            builder.expireAfterWrite(key.getExpire());
        }
        Cache cache = builder.build();
        cache.put((Object)key.getKey(), value);
        this.cacheMap.put((Object)key.getKey(), (Object)cache);
    }

    @Override
    public <T> T get(CacheKey key, boolean ... cacheNullValues) {
        Cache ifPresent = (Cache)this.cacheMap.getIfPresent((Object)key.getKey());
        if (ifPresent == null) {
            return null;
        }
        return (T)ifPresent.getIfPresent((Object)key);
    }

    @Override
    public <T> List<T> find(Collection<CacheKey> keys) {
        return keys.stream().map(k -> this.get((CacheKey)k, false)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public <T> T get(CacheKey key, Function<CacheKey, ? extends T> loader, boolean ... cacheNullValues) {
        Cache cache = (Cache)this.cacheMap.get((Object)key.getKey(), k -> {
            Caffeine builder = Caffeine.newBuilder().maximumSize(this.DEF_MAX_SIZE);
            if (key.getExpire() != null) {
                builder.expireAfterWrite(key.getExpire());
            }
            Cache newCache = builder.build();
            newCache.get(k, tk -> loader.apply(new CacheKey((String)tk)));
            return newCache;
        });
        return (T)cache.getIfPresent((Object)key.getKey());
    }

    @Override
    public void flushDb() {
        this.cacheMap.invalidateAll();
    }

    @Override
    public Boolean exists(CacheKey key) {
        Cache cache = (Cache)this.cacheMap.getIfPresent((Object)key.getKey());
        if (cache == null) {
            return false;
        }
        cache.cleanUp();
        return cache.estimatedSize() > 0L;
    }

    @Override
    public Long incr(CacheKey key) {
        Long old = this.get(key, k -> 0L, new boolean[0]);
        Long newVal = old + 1L;
        this.set(key, newVal, new boolean[0]);
        return newVal;
    }

    @Override
    public Long incrBy(CacheKey key, long increment) {
        Long old = this.get(key, k -> 0L, new boolean[0]);
        Long newVal = old + increment;
        this.set(key, newVal, new boolean[0]);
        return newVal;
    }

    @Override
    public Double incrByFloat(CacheKey key, double increment) {
        Double old = this.get(key, k -> 0.0, new boolean[0]);
        Double newVal = old + increment;
        this.set(key, newVal, new boolean[0]);
        return newVal;
    }

    @Override
    public Long decr(CacheKey key) {
        Long old = this.get(key, k -> 0L, new boolean[0]);
        Long newVal = old - 1L;
        this.set(key, newVal, new boolean[0]);
        return newVal;
    }

    @Override
    public Long decrBy(CacheKey key, long decrement) {
        Long old = this.get(key, k -> 0L, new boolean[0]);
        Long newVal = old - decrement;
        this.set(key, newVal, new boolean[0]);
        return newVal;
    }

    @Override
    public Set<String> keys(String pattern) {
        if (StrUtil.isEmpty((CharSequence)pattern)) {
            return Collections.emptySet();
        }
        ConcurrentMap map = this.cacheMap.asMap();
        Set<String> list = Collections.emptySet();
        map.forEach((k, val) -> {
            if ("*".equals(pattern)) {
                list.add((String)k);
                return;
            }
            if (pattern.contains("?")) {
                return;
            }
            if (pattern.contains("*")) {
                return;
            }
            if (pattern.contains("[") && pattern.contains("]")) {
                return;
            }
        });
        return list;
    }

    @Override
    public Boolean expire(CacheKey key) {
        return true;
    }

    @Override
    public Boolean persist(CacheKey key) {
        return true;
    }

    @Override
    public String type(CacheKey key) {
        return "caffeine";
    }

    @Override
    public Long ttl(CacheKey key) {
        return -1L;
    }

    @Override
    public Long pTtl(CacheKey key) {
        return -1L;
    }

    @Override
    public void hSet(CacheHashKey key, Object value, boolean ... cacheNullValues) {
        this.set(key.tran(), value, cacheNullValues);
    }

    @Override
    public <T> T hGet(CacheHashKey key, boolean ... cacheNullValues) {
        return this.get(key.tran(), cacheNullValues);
    }

    @Override
    public <T> T hGet(CacheHashKey key, Function<CacheHashKey, T> loader, boolean ... cacheNullValues) {
        Function<CacheKey, Object> ckLoader = k -> loader.apply(key);
        return (T)this.get(key.tran(), ckLoader, cacheNullValues);
    }

    @Override
    public Boolean hExists(CacheHashKey cacheHashKey) {
        return this.exists(cacheHashKey.tran());
    }

    @Override
    public Long hDel(String key, Object ... fields) {
        for (Object field : fields) {
            this.cacheMap.invalidate((Object)StrUtil.join((CharSequence)":", (Object[])new Object[]{key, field}));
        }
        return fields.length;
    }

    @Override
    public Long hDel(CacheHashKey cacheHashKey) {
        this.cacheMap.invalidate((Object)cacheHashKey.tran().getKey());
        return 1L;
    }

    @Override
    public Long hLen(CacheHashKey key) {
        return 1L;
    }

    @Override
    public Long hIncrBy(CacheHashKey key, long increment) {
        return this.incrBy(key.tran(), increment);
    }

    @Override
    public Double hIncrBy(CacheHashKey key, double increment) {
        return this.incrByFloat(key.tran(), increment);
    }

    @Override
    public Set<Object> hKeys(CacheHashKey key) {
        return Collections.emptySet();
    }

    @Override
    public List<Object> hVals(CacheHashKey key) {
        return Collections.emptyList();
    }

    @Override
    public Map<Object, Object> hGetAll(CacheHashKey key) {
        return Collections.emptyMap();
    }
}

