/*
 * Decompiled with CFR 0.152.
 */
package com.github.zuihou.cache.repository.impl;

import com.github.zuihou.cache.model.CacheHashKey;
import com.github.zuihou.cache.model.CacheKey;
import com.github.zuihou.cache.redis.RedisOps;
import com.github.zuihou.cache.repository.CacheOps;
import com.github.zuihou.cache.repository.CachePlusOps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisOpsImpl
implements CacheOps,
CachePlusOps {
    private static final Logger log = LoggerFactory.getLogger(RedisOpsImpl.class);
    private RedisOps redisOps;

    public RedisOpsImpl(RedisOps redisOps) {
        this.redisOps = redisOps;
    }

    public RedisTemplate<String, Object> getRedisTemplate() {
        return this.redisOps.getRedisTemplate();
    }

    @Override
    public Long del(CacheKey ... keys) {
        return this.redisOps.del(keys);
    }

    @Override
    public Boolean exists(CacheKey key) {
        return this.redisOps.exists(key.getKey());
    }

    @Override
    public void set(CacheKey key, Object value, boolean ... cacheNullValues) {
        this.redisOps.set(key, value, cacheNullValues);
    }

    @Override
    public <T> T get(CacheKey key, boolean ... cacheNullValues) {
        return this.redisOps.get(key, cacheNullValues);
    }

    @Override
    public <T> List<T> find(Collection<CacheKey> keys) {
        return this.redisOps.mGetByCacheKey(keys);
    }

    @Override
    public <T> T get(CacheKey key, Function<CacheKey, ? extends T> loader, boolean ... cacheNullValues) {
        return this.redisOps.get(key, loader, cacheNullValues);
    }

    @Override
    public void flushDb() {
        this.redisOps.getRedisTemplate().execute(connection -> {
            connection.flushDb();
            return "ok";
        });
    }

    @Override
    public Long incr(CacheKey key) {
        return this.redisOps.incr(key.getKey());
    }

    @Override
    public Long incrBy(CacheKey key, long increment) {
        return this.redisOps.incrBy(key.getKey(), increment);
    }

    @Override
    public Double incrByFloat(CacheKey key, double increment) {
        return this.redisOps.incrByFloat(key.getKey(), increment);
    }

    @Override
    public Long decr(CacheKey key) {
        return this.redisOps.decr(key.getKey());
    }

    @Override
    public Long decrBy(CacheKey key, long decrement) {
        return this.redisOps.decrBy(key.getKey(), decrement);
    }

    @Override
    public Set<String> keys(String pattern) {
        return this.redisOps.keys(pattern);
    }

    @Override
    public Boolean expire(CacheKey key) {
        return this.redisOps.expire(key.getKey(), key.getExpire());
    }

    @Override
    public Boolean persist(CacheKey key) {
        return this.redisOps.persist(key.getKey());
    }

    @Override
    public String type(CacheKey key) {
        return this.redisOps.type(key.getKey());
    }

    @Override
    public Long ttl(CacheKey key) {
        return this.redisOps.ttl(key.getKey());
    }

    @Override
    public Long pTtl(CacheKey key) {
        return this.redisOps.pTtl(key.getKey());
    }

    @Override
    public void hSet(CacheHashKey key, Object value, boolean ... cacheNullValues) {
        this.redisOps.hSet(key, value, cacheNullValues);
    }

    @Override
    public <T> T hGet(CacheHashKey key, boolean ... cacheNullValues) {
        return this.redisOps.hGet(key, cacheNullValues);
    }

    @Override
    public <T> T hGet(CacheHashKey key, Function<CacheHashKey, T> loader, boolean ... cacheNullValues) {
        return this.redisOps.hGet(key, loader, cacheNullValues);
    }

    @Override
    public Boolean hExists(CacheHashKey cacheHashKey) {
        return this.redisOps.hExists(cacheHashKey);
    }

    @Override
    public Long hDel(String key, Object ... fields) {
        return this.redisOps.hDel(key, fields);
    }

    @Override
    public Long hDel(CacheHashKey cacheHashKey) {
        return this.redisOps.hDel(cacheHashKey.getKey(), cacheHashKey.getField());
    }

    @Override
    public Long hLen(CacheHashKey key) {
        return this.redisOps.hLen(key.getKey());
    }

    @Override
    public Long hIncrBy(CacheHashKey key, long increment) {
        return this.redisOps.hIncrBy(key.getKey(), key.getField(), increment);
    }

    @Override
    public Double hIncrBy(CacheHashKey key, double increment) {
        return this.redisOps.hIncrByFloat(key.getKey(), key.getField(), increment);
    }

    @Override
    public Set<Object> hKeys(CacheHashKey key) {
        return this.redisOps.hKeys(key.getKey());
    }

    @Override
    public List<Object> hVals(CacheHashKey key) {
        return this.redisOps.hVals(key.getKey());
    }

    @Override
    public Map<Object, Object> hGetAll(CacheHashKey key) {
        return this.redisOps.hGetAll(key.getKey());
    }
}

