/*
 * Decompiled with CFR 0.152.
 */
package com.github.zuihou.injection.aspect;

import com.github.zuihou.injection.annonation.InjectionResult;
import com.github.zuihou.injection.core.InjectionCore;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class InjectionResultAspect {
    private static final Logger log = LoggerFactory.getLogger(InjectionResultAspect.class);
    private InjectionCore injectionCore;

    @Pointcut(value="@annotation(com.github.zuihou.injection.annonation.InjectionResult)")
    public void methodPointcut() {
    }

    @Around(value="methodPointcut()&&@annotation(anno)")
    public Object interceptor(ProceedingJoinPoint pjp, InjectionResult anno) throws Throwable {
        Object proceed = pjp.proceed();
        try {
            this.injectionCore.injection(proceed, anno.isUseCache(), new String[0]);
        }
        catch (Exception e) {
            log.error("AOP\u62e6\u622a@RemoteResult\u51fa\u9519", (Throwable)e);
        }
        return proceed;
    }

    public InjectionResultAspect(InjectionCore injectionCore) {
        this.injectionCore = injectionCore;
    }
}

