/*
 * Decompiled with CFR 0.152.
 */
package com.github.zuihou.injection.core;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.github.zuihou.context.BaseContextHandler;
import com.github.zuihou.injection.annonation.InjectionField;
import com.github.zuihou.injection.core.FieldParam;
import com.github.zuihou.injection.core.InjectionFieldExtPo;
import com.github.zuihou.injection.core.InjectionFieldPo;
import com.github.zuihou.injection.properties.InjectionProperties;
import com.github.zuihou.jackson.JsonUtil;
import com.github.zuihou.model.RemoteData;
import com.github.zuihou.utils.SpringUtils;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InjectionCore {
    private static final Logger log = LoggerFactory.getLogger(InjectionCore.class);
    private static final int DEF_MAP_SIZE = 20;
    private final InjectionProperties ips;
    private ListeningExecutorService backgroundRefreshPools;
    private LoadingCache<InjectionFieldExtPo, Map<Serializable, Object>> caches;

    public InjectionCore(InjectionProperties ips) {
        this.ips = ips;
        InjectionProperties.GuavaCache guavaCache = ips.getGuavaCache();
        if (guavaCache.getEnabled().booleanValue()) {
            this.backgroundRefreshPools = MoreExecutors.listeningDecorator((ExecutorService)new ThreadPoolExecutor(guavaCache.getRefreshThreadPoolSize(), guavaCache.getRefreshThreadPoolSize(), 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>()));
            CacheLoader<InjectionFieldExtPo, Map<Serializable, Object>> cacheLoader = new CacheLoader<InjectionFieldExtPo, Map<Serializable, Object>>(){

                public Map<Serializable, Object> load(InjectionFieldExtPo type) {
                    log.info("\u9996\u6b21\u8bfb\u53d6\u7f13\u5b58: " + type);
                    return InjectionCore.this.loadMap(type);
                }

                public ListenableFuture<Map<Serializable, Object>> reload(InjectionFieldExtPo key, Map<Serializable, Object> oldValue) {
                    return InjectionCore.this.backgroundRefreshPools.submit(() -> {
                        BaseContextHandler.setTenant((String)key.getTenant());
                        return this.load(key);
                    });
                }
            };
            this.caches = CacheBuilder.newBuilder().maximumSize((long)guavaCache.getMaximumSize().intValue()).refreshAfterWrite((long)guavaCache.getRefreshWriteTime().intValue(), TimeUnit.MINUTES).build((CacheLoader)cacheLoader);
        }
    }

    private Map<Serializable, Object> loadMap(InjectionFieldExtPo type) {
        Object bean;
        if (StrUtil.isNotEmpty((CharSequence)type.getApi())) {
            bean = SpringUtils.getBean((String)type.getApi());
            log.info("\u5efa\u8bae\u5728\u65b9\u6cd5\uff1a [{}.{}]\uff0c\u4e0a\u52a0\u5165\u7f13\u5b58\uff0c\u52a0\u901f\u67e5\u8be2", (Object)type.getApi(), (Object)type.getMethod());
        } else {
            bean = SpringUtils.getBean(type.getApiClass());
            log.info("\u5efa\u8bae\u5728\u65b9\u6cd5\uff1a [{}.{}]\uff0c\u4e0a\u52a0\u5165\u7f13\u5b58\uff0c\u52a0\u901f\u67e5\u8be2", (Object)type.getApiClass().toString(), (Object)type.getMethod());
        }
        return (Map)ReflectUtil.invoke((Object)bean, (String)type.getMethod(), (Object[])new Object[]{type.getKeys()});
    }

    public void injection(Object obj, boolean isUseCache, String ... ignoreFields) {
        try {
            ConcurrentHashMap<InjectionFieldPo, Map<Serializable, Object>> typeMap = new ConcurrentHashMap<InjectionFieldPo, Map<Serializable, Object>>(20);
            long parseStart = System.currentTimeMillis();
            this.parse(obj, typeMap, 1, ignoreFields);
            long parseEnd = System.currentTimeMillis();
            log.info("\u89e3\u6790\u8017\u65f6={} ms", (Object)(parseEnd - parseStart));
            if (typeMap.isEmpty()) {
                return;
            }
            for (Map.Entry entries : typeMap.entrySet()) {
                InjectionFieldPo type = (InjectionFieldPo)entries.getKey();
                Map valueMap = (Map)entries.getValue();
                Set<Serializable> keys = valueMap.keySet();
                try {
                    InjectionFieldExtPo extPo = new InjectionFieldExtPo(type, keys);
                    Map value = this.ips.getGuavaCache().getEnabled() != false && isUseCache ? (Map)this.caches.get((Object)extPo) : this.loadMap(extPo);
                    typeMap.put(type, value);
                }
                catch (Exception e) {
                    log.error("\u8fdc\u7a0b\u8c03\u7528\u65b9\u6cd5 [{}({}).{}] \u5931\u8d25\uff0c \u8bf7\u786e\u4fdd\u7cfb\u7edf\u5b58\u5728\u8be5\u65b9\u6cd5", new Object[]{type.getApi(), type.getApiClass().toString(), type.getMethod(), e});
                }
            }
            long injectionStart = System.currentTimeMillis();
            log.info("\u6279\u91cf\u67e5\u8be2\u8017\u65f6={} ms", (Object)(injectionStart - parseEnd));
            this.injection(obj, typeMap, 1, new String[0]);
            long injectionEnd = System.currentTimeMillis();
            log.info("\u6ce8\u5165\u8017\u65f6={} ms", (Object)(injectionEnd - injectionStart));
        }
        catch (Exception e) {
            log.warn("\u6ce8\u5165\u5931\u8d25", (Throwable)e);
        }
    }

    public void injection(Object obj, String ... ignoreFields) {
        this.injection(obj, false, ignoreFields);
    }

    private boolean isNotBaseType(Field field) {
        return !this.isBaseType(field);
    }

    private boolean isBaseType(Field field) {
        String typeName = field.getType().getName();
        return "java.lang.Integer".equals(typeName) || "java.lang.Byte".equals(typeName) || "java.lang.Long".equals(typeName) || "java.lang.Double".equals(typeName) || "java.lang.Float".equals(typeName) || "java.lang.Character".equals(typeName) || "java.lang.Short".equals(typeName) || "java.lang.Boolean".equals(typeName) || "java.lang.String".equals(typeName) || "com.github.zuihou.model.RemoteData".equals(typeName);
    }

    private void parse(Object obj, Map<InjectionFieldPo, Map<Serializable, Object>> typeMap, int depth, String ... ignoreFields) {
        Field[] fields;
        if (obj == null) {
            return;
        }
        if (depth > this.ips.getMaxDepth()) {
            log.info("\u51fa\u73b0\u5faa\u73af\u4f9d\u8d56\uff0c\u6700\u591a\u6267\u884c {} \u6b21\uff0c \u5df2\u6267\u884c {} \u6b21\uff0c\u5df2\u4e3a\u60a8\u8df3\u51fa\u5faa\u73af", (Object)this.ips.getMaxDepth(), (Object)depth);
            return;
        }
        if (typeMap == null) {
            typeMap = new ConcurrentHashMap<InjectionFieldPo, Map<Serializable, Object>>(20);
        }
        if (obj instanceof IPage) {
            List records = ((IPage)obj).getRecords();
            this.parseList(records, typeMap, depth, ignoreFields);
            return;
        }
        if (obj instanceof Collection) {
            this.parseList((Collection)obj, typeMap, depth, ignoreFields);
            return;
        }
        for (Field field : fields = ReflectUtil.getFields(obj.getClass())) {
            FieldParam fieldParam = this.getFieldParam(obj, field, typeMap, innerTypeMap -> this.parse(ReflectUtil.getFieldValue((Object)obj, (Field)field), (Map<InjectionFieldPo, Map<Serializable, Object>>)innerTypeMap, depth + 1, ignoreFields), ignoreFields);
            if (fieldParam == null) continue;
            InjectionFieldPo type = new InjectionFieldPo(fieldParam.getInjection());
            Map valueMap = typeMap.getOrDefault(type, new ConcurrentHashMap(20));
            valueMap.put(fieldParam.getQueryKey(), Collections.emptyMap());
            typeMap.put(type, valueMap);
        }
    }

    private void parseList(Collection<?> list, Map<InjectionFieldPo, Map<Serializable, Object>> typeMap, int depth, String ... ignoreFields) {
        for (Object item : list) {
            this.parse(item, typeMap, depth, ignoreFields);
        }
    }

    private void injection(Object obj, Map<InjectionFieldPo, Map<Serializable, Object>> typeMap, int depth, String ... ignoreFields) {
        Field[] fields;
        if (obj == null) {
            return;
        }
        if (depth > this.ips.getMaxDepth()) {
            log.info("\u51fa\u73b0\u5faa\u73af\u4f9d\u8d56\uff0c\u6700\u591a\u6267\u884c {} \u6b21\uff0c \u5df2\u6267\u884c {} \u6b21\uff0c\u5df2\u4e3a\u60a8\u8df3\u51fa\u5faa\u73af", (Object)this.ips.getMaxDepth(), (Object)depth);
            return;
        }
        if (typeMap == null || typeMap.isEmpty()) {
            return;
        }
        if (obj instanceof IPage) {
            List records = ((IPage)obj).getRecords();
            this.injectionList(records, typeMap, ignoreFields);
            return;
        }
        if (obj instanceof Collection) {
            this.injectionList((Collection)obj, typeMap, ignoreFields);
            return;
        }
        for (Field field : fields = ReflectUtil.getFields(obj.getClass())) {
            FieldParam fieldParam = this.getFieldParam(obj, field, typeMap, innerTypeMap -> this.injection(ReflectUtil.getFieldValue((Object)obj, (Field)field), (Map<InjectionFieldPo, Map<Serializable, Object>>)innerTypeMap, depth + 1, ignoreFields), ignoreFields);
            if (fieldParam == null) continue;
            InjectionField inField = fieldParam.getInjection();
            Serializable queryKey = fieldParam.getQueryKey();
            Object fieldValue = fieldParam.getFieldValue();
            Object newVal = this.getNewVal(inField, queryKey, typeMap);
            if (newVal == null || newVal instanceof Map && ((Map)newVal).isEmpty()) continue;
            if (fieldValue instanceof RemoteData) {
                RemoteData remoteData = (RemoteData)fieldValue;
                if (newVal instanceof Map && !Object.class.equals(inField.beanClass())) {
                    newVal = JsonUtil.parse((String)JsonUtil.toJson((Object)newVal), inField.beanClass());
                }
                remoteData.setData(newVal);
                continue;
            }
            ReflectUtil.setFieldValue((Object)obj, (Field)field, (Object)newVal);
        }
    }

    private Object getNewVal(InjectionField inField, Object queryKey, Map<InjectionFieldPo, Map<Serializable, Object>> typeMap) {
        InjectionFieldPo type = new InjectionFieldPo(inField);
        Map<Serializable, Object> valueMap = typeMap.get(type);
        if (CollUtil.isEmpty(valueMap)) {
            return null;
        }
        Object newVal = valueMap.get(queryKey);
        if (ObjectUtil.isNull((Object)newVal) && ObjectUtil.isNotEmpty((Object)queryKey) && ObjectUtil.isNull((Object)(newVal = valueMap.get(queryKey.toString()))) && StrUtil.contains((CharSequence)queryKey.toString(), (CharSequence)this.ips.getDictItemSeparator())) {
            String[] typeCodes = StrUtil.split((CharSequence)queryKey.toString(), (CharSequence)this.ips.getDictSeparator());
            String[] codes = StrUtil.split((CharSequence)typeCodes[1], (CharSequence)this.ips.getDictItemSeparator());
            newVal = Arrays.stream(codes).map(item -> {
                String val = valueMap.getOrDefault(typeCodes[0] + this.ips.getDictSeparator() + item, "").toString();
                return val == null ? "" : val;
            }).collect(Collectors.joining(this.ips.getDictItemSeparator()));
        }
        return newVal;
    }

    private void injectionList(Collection<?> list, Map<InjectionFieldPo, Map<Serializable, Object>> typeMap, String ... ignoreFields) {
        for (Object item : list) {
            this.injection(item, typeMap, 1, ignoreFields);
        }
    }

    private FieldParam getFieldParam(Object obj, Field field, Map<InjectionFieldPo, Map<Serializable, Object>> typeMap, Consumer<Map<InjectionFieldPo, Map<Serializable, Object>>> consumer, String ... ignoreFields) {
        InjectionField inField = field.getDeclaredAnnotation(InjectionField.class);
        if (inField == null) {
            return null;
        }
        if (ArrayUtil.contains((Object[])ignoreFields, (Object)field.getName())) {
            log.debug("\u5df2\u7ecf\u5ffd\u7565{}\u5b57\u6bb5\u7684\u89e3\u6790", (Object)field.getName());
            return null;
        }
        field.setAccessible(true);
        if (this.isNotBaseType(field)) {
            consumer.accept(typeMap);
            return null;
        }
        String api = inField.api();
        Class<? extends Object> feign = inField.apiClass();
        if (StrUtil.isEmpty((CharSequence)api) && Object.class.equals(feign)) {
            log.warn("\u5ffd\u7565\u6ce8\u5165\u5b57\u6bb5: {}.{}", field.getType(), (Object)field.getName());
            return null;
        }
        Object fieldValue = ReflectUtil.getFieldValue((Object)obj, (Field)field);
        if (fieldValue == null) {
            log.debug("\u5b57\u6bb5[{}]\u4e3a\u7a7a,\u8df3\u8fc7", (Object)field.getName());
            return null;
        }
        Serializable queryKey = this.getQueryKey(inField, fieldValue);
        if (ObjectUtil.isEmpty((Object)queryKey)) {
            return null;
        }
        return new FieldParam(inField, queryKey, fieldValue);
    }

    private Serializable getQueryKey(InjectionField injectionField, Object fieldValue) {
        Object queryKey;
        String key = injectionField.key();
        String dictType = injectionField.dictType();
        if (StrUtil.isNotEmpty((CharSequence)key)) {
            queryKey = key;
        } else if (fieldValue instanceof RemoteData) {
            RemoteData remoteData = (RemoteData)fieldValue;
            queryKey = (Serializable)remoteData.getKey();
        } else {
            queryKey = (Serializable)fieldValue;
        }
        if (ObjectUtil.isNotEmpty((Object)queryKey) && StrUtil.isNotEmpty((CharSequence)dictType)) {
            queryKey = StrUtil.join((CharSequence)this.ips.getDictSeparator(), (Object[])new Object[]{dictType, queryKey});
        }
        return queryKey;
    }
}

