/*
 * Decompiled with CFR 0.152.
 */
package com.github.zuihou.j2cache;

import cn.hutool.core.collection.CollUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.CachingConfigurerSupport;
import org.springframework.cache.interceptor.CacheResolver;
import org.springframework.cache.interceptor.KeyGenerator;

public class MyCacheConfig
extends CachingConfigurerSupport {
    private final CacheManager cacheManager;

    public MyCacheConfig(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public KeyGenerator keyGenerator() {
        return (target, method, objects) -> "";
    }

    public CacheResolver cacheResolver() {
        return context -> {
            Collection cacheNames = null;
            CacheConfig annotation = context.getTarget().getClass().getAnnotation(CacheConfig.class);
            if (annotation != null) {
                cacheNames = CollUtil.toList((Object[])annotation.cacheNames());
            }
            if (cacheNames == null || cacheNames.isEmpty()) {
                cacheNames = context.getOperation().getCacheNames();
            }
            if (cacheNames == null || cacheNames.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<Cache> result = new ArrayList<Cache>(cacheNames.size());
            for (String cacheName : cacheNames) {
                Cache cache = this.cacheManager.getCache(cacheName);
                if (cache == null) {
                    throw new IllegalArgumentException("Cannot find cache named '" + cacheName + "' for " + context.getOperation());
                }
                result.add(cache);
            }
            return result;
        };
    }
}

