/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.cache.support.util;

import java.util.Map;
import java.util.Set;
import net.oschina.j2cache.J2CacheConfig;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.StandardEnvironment;

public class SpringJ2CacheConfigUtil {
    public static final J2CacheConfig initFromConfig(StandardEnvironment environment) {
        J2CacheConfig config = new J2CacheConfig();
        config.setSerialization(environment.getProperty("j2cache.serialization"));
        config.setBroadcast(environment.getProperty("j2cache.broadcast"));
        config.setL1CacheName(environment.getProperty("j2cache.L1.provider_class"));
        config.setL2CacheName(environment.getProperty("j2cache.L2.provider_class"));
        config.setSyncTtlToRedis(!"false".equalsIgnoreCase(environment.getProperty("j2cache.sync_ttl_to_redis")));
        config.setDefaultCacheNullObject("true".equalsIgnoreCase(environment.getProperty("j2cache.default_cache_null_object")));
        String l2_config_section = environment.getProperty("j2cache.L2.config_section");
        if (l2_config_section == null || l2_config_section.trim().equals("")) {
            l2_config_section = config.getL2CacheName();
        }
        String l2_section = l2_config_section;
        environment.getPropertySources().forEach(a -> {
            String[] propertyNames = new String[]{};
            if (a instanceof MapPropertySource) {
                MapPropertySource c = (MapPropertySource)a;
                Map source = (Map)c.getSource();
                if (source != null && !source.isEmpty()) {
                    Set strings = source.keySet();
                    propertyNames = (String[])strings.stream().toArray(String[]::new);
                }
            } else if (a instanceof CompositePropertySource) {
                CompositePropertySource cps = (CompositePropertySource)a;
                propertyNames = cps.getPropertyNames();
            } else if (a instanceof EnumerablePropertySource) {
                EnumerablePropertySource eps = (EnumerablePropertySource)a;
                propertyNames = eps.getPropertyNames();
            }
            SpringJ2CacheConfigUtil.setProperty(config, environment, l2_section, propertyNames);
        });
        return config;
    }

    private static void setProperty(J2CacheConfig config, StandardEnvironment environment, String l2_section, String[] propertyNames) {
        for (String key : propertyNames) {
            String v;
            String k;
            if (key.startsWith(config.getBroadcast() + ".")) {
                k = key.substring((config.getBroadcast() + ".").length());
                v = environment.getProperty(key);
                config.getBroadcastProperties().setProperty(k, v);
            }
            if (key.startsWith(config.getL1CacheName() + ".")) {
                k = key.substring((config.getL1CacheName() + ".").length());
                v = environment.getProperty(key, "");
                config.getL1CacheProperties().setProperty(k, v);
            }
            if (!key.startsWith(l2_section + ".")) continue;
            k = key.substring((l2_section + ".").length());
            v = environment.getProperty(key, "");
            config.getL2CacheProperties().setProperty(k, v);
        }
    }
}

