/*
 * Decompiled with CFR 0.152.
 */
package com.github.zuihou.validator.controller;

import cn.hutool.core.util.StrUtil;
import com.github.zuihou.validator.extract.IConstraintExtract;
import com.github.zuihou.validator.model.FieldValidatorDesc;
import com.github.zuihou.validator.model.ValidConstraint;
import com.github.zuihou.validator.wrapper.HttpServletRequestValidatorWrapper;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import org.springframework.core.MethodParameter;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@RequestMapping
public class FormValidatorController {
    private static final String FORM_VALIDATOR_URL = "/form/validator";
    private final RequestMappingHandlerMapping requestMappingHandlerMapping;
    private final IConstraintExtract constraintExtract;

    public FormValidatorController(IConstraintExtract constraintExtract, RequestMappingHandlerMapping requestMappingHandlerMapping) {
        this.constraintExtract = constraintExtract;
        this.requestMappingHandlerMapping = requestMappingHandlerMapping;
    }

    @RequestMapping(value={"/form/validator/**"})
    @ResponseBody
    public Collection<FieldValidatorDesc> standardByPathVar(HttpServletRequest request) throws Exception {
        String requestUri = request.getRequestURI();
        String formPath = StrUtil.subAfter((CharSequence)requestUri, (CharSequence)FORM_VALIDATOR_URL, (boolean)false);
        return this.localFieldValidatorDescribe(request, formPath);
    }

    @RequestMapping(value={"/form/validator"})
    @ResponseBody
    public Collection<FieldValidatorDesc> standardByQueryParam(@RequestParam(value="formPath", required=false) String formPath, HttpServletRequest request) throws Exception {
        return this.localFieldValidatorDescribe(request, formPath);
    }

    private Collection<FieldValidatorDesc> localFieldValidatorDescribe(HttpServletRequest request, String formPath) throws Exception {
        HandlerExecutionChain chains = this.requestMappingHandlerMapping.getHandler((HttpServletRequest)new HttpServletRequestValidatorWrapper(request, formPath));
        if (chains == null) {
            return Collections.emptyList();
        }
        HandlerMethod method = (HandlerMethod)chains.getHandler();
        if (method == null) {
            return Collections.emptyList();
        }
        return this.loadValidatorDescribe(method);
    }

    private Collection<FieldValidatorDesc> loadValidatorDescribe(HandlerMethod handlerMethod) throws Exception {
        Method method = handlerMethod.getMethod();
        Parameter[] methodParams = method.getParameters();
        if (methodParams == null || methodParams.length < 1) {
            return Collections.EMPTY_LIST;
        }
        MethodParameter[] methodParameters = handlerMethod.getMethodParameters();
        if (methodParameters == null || methodParameters.length < 1) {
            return Collections.EMPTY_LIST;
        }
        Validated classValidated = method.getDeclaringClass().getAnnotation(Validated.class);
        ArrayList<ValidConstraint> validatorStandard = new ArrayList<ValidConstraint>();
        for (int i = 0; i < methodParameters.length; ++i) {
            MethodParameter methodParameter = methodParameters[i];
            Parameter methodParam = methodParams[i];
            Validated methodParamValidate = methodParam.getAnnotation(Validated.class);
            if (methodParamValidate == null && classValidated == null) continue;
            Class[] group = null;
            if (methodParamValidate != null) {
                group = methodParamValidate.value();
            }
            if (group == null && classValidated != null) {
                group = classValidated.value();
            }
            validatorStandard.add(new ValidConstraint(methodParameter.getParameterType(), group));
        }
        if (validatorStandard.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return this.constraintExtract.extract(validatorStandard);
    }
}

