/*
 * Decompiled with CFR 0.152.
 */
package com.github.zuihou.xss.converter;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.github.zuihou.xss.utils.XssUtils;
import java.io.IOException;
import java.util.ArrayList;

public class XssStringJsonDeserializer
extends JsonDeserializer<String> {
    public String deserialize(JsonParser p, DeserializationContext dc) throws IOException, JsonProcessingException {
        if (p.hasToken(JsonToken.VALUE_STRING)) {
            String value = p.getValueAsString();
            if (value == null || "".equals(value)) {
                return value;
            }
            ArrayList<String> list = new ArrayList<String>();
            list.add("<script>");
            list.add("</script>");
            list.add("<iframe>");
            list.add("</iframe>");
            list.add("<noscript>");
            list.add("</noscript>");
            list.add("<frameset>");
            list.add("</frameset>");
            list.add("<frame>");
            list.add("</frame>");
            list.add("<noframes>");
            list.add("</noframes>");
            boolean flag = list.stream().anyMatch(item -> value.contains((CharSequence)item));
            if (flag) {
                return XssUtils.xssClean(value, null);
            }
            return value;
        }
        return null;
    }
}

