/*
 * Decompiled with CFR 0.152.
 */
package com.github.zuihou.xss.converter;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.github.zuihou.xss.utils.XssUtils;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XssStringJsonSerializer
extends JsonSerializer<String> {
    private static final Logger log = LoggerFactory.getLogger(XssStringJsonSerializer.class);

    public Class<String> handledType() {
        return String.class;
    }

    public void serialize(String value, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (value != null) {
            try {
                String encodedValue = XssUtils.xssClean(value, null);
                jsonGenerator.writeString(encodedValue);
            }
            catch (Exception e) {
                log.error("\u5e8f\u5217\u5316\u5931\u8d25:[{}]", (Object)value, (Object)e);
            }
        }
    }
}

