/*
 * Decompiled with CFR 0.152.
 */
package com.github.zuihou.xss.filter;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.github.zuihou.xss.wrapper.XssRequestWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.AntPathMatcher;

public class XssFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(XssFilter.class);
    public static final String IGNORE_PATH = "ignorePath";
    public static final String IGNORE_PARAM_VALUE = "ignoreParamValue";
    private static final AntPathMatcher ANT_PATH_MATCHER = new AntPathMatcher();
    private static final String CAS_LOGOUT_RESPONSE_TAG = "samlp:LogoutRequest";
    private List<String> ignorePathList;
    private List<String> ignoreParamValueList;

    public void init(FilterConfig filterConfig) throws ServletException {
        log.debug("XSS fiter [XSSFilter] init start ...");
        String ignorePaths = filterConfig.getInitParameter(IGNORE_PATH);
        String ignoreParamValues = filterConfig.getInitParameter(IGNORE_PARAM_VALUE);
        if (!StrUtil.isBlank((CharSequence)ignorePaths)) {
            String[] ignorePathArr = ignorePaths.split(",");
            this.ignorePathList = new ArrayList<String>(Arrays.asList(ignorePathArr));
        }
        if (!StrUtil.isBlank((CharSequence)ignoreParamValues)) {
            String[] ignoreParamValueArr = ignoreParamValues.split(",");
            this.ignoreParamValueList = new ArrayList<String>(Arrays.asList(ignoreParamValueArr));
            if (!this.ignoreParamValueList.contains(CAS_LOGOUT_RESPONSE_TAG)) {
                this.ignoreParamValueList.add(CAS_LOGOUT_RESPONSE_TAG);
            }
        } else {
            this.ignoreParamValueList = new ArrayList<String>();
            this.ignoreParamValueList.add(CAS_LOGOUT_RESPONSE_TAG);
        }
        log.debug("XSS fiter [XSSFilter] init end");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        log.debug("XSS fiter [XSSFilter] starting");
        String uriPath = ((HttpServletRequest)request).getRequestURI();
        if (this.isIgnorePath(uriPath)) {
            log.debug("ignore xssfilter,path[" + uriPath + "] pass through XssFilter, go ahead...");
            chain.doFilter(request, response);
            return;
        }
        log.debug("has xssfiter path[" + uriPath + "] need XssFilter, go to XssRequestWrapper");
        chain.doFilter((ServletRequest)new XssRequestWrapper((HttpServletRequest)request, this.ignoreParamValueList), response);
        log.debug("XSS fiter [XSSFilter] stop");
    }

    public void destroy() {
        log.debug("XSS fiter [XSSFilter] destroy");
    }

    private boolean isIgnorePath(String uriPath) {
        if (StrUtil.isBlank((CharSequence)uriPath)) {
            return true;
        }
        if (CollectionUtil.isEmpty(this.ignorePathList)) {
            return false;
        }
        return this.ignorePathList.stream().anyMatch(url -> uriPath.startsWith((String)url) || ANT_PATH_MATCHER.match(url, uriPath));
    }
}

