/*
 * Decompiled with CFR 0.152.
 */
package com.github.zuihou.xss.utils;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.owasp.validator.html.AntiSamy;
import org.owasp.validator.html.CleanResults;
import org.owasp.validator.html.Policy;
import org.owasp.validator.html.PolicyException;
import org.owasp.validator.html.ScanException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XssUtils {
    private static final Logger log = LoggerFactory.getLogger(XssUtils.class);
    private static final String ANTISAMY_SLASHDOT_XML = "antisamy-slashdot-1.4.4.xml";
    private static Policy policy = null;

    public static String xssClean(String paramValue, List<String> ignoreParamValueList) {
        AntiSamy antiSamy = new AntiSamy();
        try {
            log.debug("raw value before xssClean: " + paramValue);
            if (XssUtils.isIgnoreParamValue(paramValue, ignoreParamValueList)) {
                log.debug("ignore the xssClean,keep the raw paramValue: " + paramValue);
                return paramValue;
            }
            CleanResults cr = antiSamy.scan(paramValue, policy);
            cr.getErrorMessages().forEach(arg_0 -> ((Logger)log).debug(arg_0));
            String str = cr.getCleanHTML();
            str = str.replaceAll("&quot;", "\"");
            str = str.replaceAll("&amp;", "&");
            str = str.replaceAll("'", "'");
            str = str.replaceAll("'", "\uff07");
            str = str.replaceAll("&lt;", "<");
            str = str.replaceAll("&gt;", ">");
            log.debug("xssfilter value after xssClean" + str);
            return str;
        }
        catch (ScanException e) {
            log.error("scan failed armter is [" + paramValue + "]", (Throwable)e);
        }
        catch (PolicyException e) {
            log.error("antisamy convert failed  armter is [" + paramValue + "]", (Throwable)e);
        }
        return paramValue;
    }

    private static boolean isIgnoreParamValue(String paramValue, List<String> ignoreParamValueList) {
        if (StrUtil.isBlank((CharSequence)paramValue)) {
            return true;
        }
        if (CollectionUtil.isEmpty(ignoreParamValueList)) {
            return false;
        }
        for (String ignoreParamValue : ignoreParamValueList) {
            if (!paramValue.contains(ignoreParamValue)) continue;
            return true;
        }
        return false;
    }

    static {
        log.debug(" start read XSS configfile [antisamy-slashdot-1.4.4.xml]");
        InputStream inputStream = XssUtils.class.getClassLoader().getResourceAsStream(ANTISAMY_SLASHDOT_XML);
        try {
            policy = Policy.getInstance((InputStream)inputStream);
            log.debug("read XSS configfile [antisamy-slashdot-1.4.4.xml] success");
        }
        catch (PolicyException e) {
            log.error("read XSS configfile [antisamy-slashdot-1.4.4.xml] fail , reason:", (Throwable)e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error("close XSS configfile [antisamy-slashdot-1.4.4.xml] fail , reason:", (Throwable)e);
                }
            }
        }
    }
}

