/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.blobstore;

import com.google.appengine.api.blobstore.RangeFormatException;
import com.google.appengine.api.blobstore.UnsupportedRangeFormatException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ByteRange {
    private long start;
    private Long end;
    static final String BYTES_UNIT = "bytes";
    static final String UNIT_REGEX = "([^=\\s]+)";
    static final String VALID_RANGE_HEADER_REGEX = "([^=\\s]+)\\s*=\\s*(\\d*)\\s*-\\s*(\\d*)";
    static final String INVALID_RANGE_HEADER_REGEX = "((?:\\s*,\\s*(?:\\d*)-(?:\\d*))*)";
    static final Pattern RANGE_HEADER_PATTERN = Pattern.compile("^\\s*([^=\\s]+)\\s*=\\s*(\\d*)\\s*-\\s*(\\d*)((?:\\s*,\\s*(?:\\d*)-(?:\\d*))*)\\s*$");
    static final String CONTENT_RANGE_UNIT_REGEX = "([^\\s]+)";
    static final String VALID_CONTENT_RANGE_HEADER_REGEX = "bytes\\s+(\\d+)-(\\d+)/(\\d+)";
    static final Pattern CONTENT_RANGE_HEADER_PATTERN = Pattern.compile("^\\s*bytes\\s+(\\d+)-(\\d+)/(\\d+)\\s*$");

    public ByteRange(long start) {
        this(start, null);
    }

    public ByteRange(long start, long end) {
        this(start, (Long)end);
        if (start < 0L) {
            throw new IllegalArgumentException("If end is provided, start must be positive.");
        }
        if (end < start) {
            throw new IllegalArgumentException("end must be >= start.");
        }
    }

    protected ByteRange(long start, Long end) {
        this.start = start;
        this.end = end;
    }

    public boolean hasEnd() {
        return this.end != null;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        if (!this.hasEnd()) {
            throw new IllegalStateException("Byte-range does not have end.  Check hasEnd() before use");
        }
        return this.end;
    }

    public String toString() {
        if (this.end != null) {
            long l = this.start;
            String string = String.valueOf(this.end);
            return new StringBuilder(27 + String.valueOf(string).length()).append("bytes=").append(l).append("-").append(string).toString();
        }
        if (this.start < 0L) {
            long l = this.start;
            return new StringBuilder(26).append("bytes=").append(l).toString();
        }
        long l = this.start;
        return new StringBuilder(27).append("bytes=").append(l).append("-").toString();
    }

    public static ByteRange parse(String byteRange) {
        Matcher matcher = RANGE_HEADER_PATTERN.matcher(byteRange);
        if (!matcher.matches()) {
            String string = String.valueOf(byteRange);
            throw new RangeFormatException(string.length() != 0 ? "Invalid range format: ".concat(string) : new String("Invalid range format: "));
        }
        String unsupportedRange = matcher.group(4);
        if (!"".equals(unsupportedRange)) {
            String string = String.valueOf(byteRange);
            throw new UnsupportedRangeFormatException(string.length() != 0 ? "Unsupported range format: ".concat(string) : new String("Unsupported range format: "));
        }
        String units = matcher.group(1);
        if (!BYTES_UNIT.equals(units)) {
            String string = String.valueOf(units);
            throw new UnsupportedRangeFormatException(string.length() != 0 ? "Unsupported unit: ".concat(string) : new String("Unsupported unit: "));
        }
        String start = matcher.group(2);
        Long startValue = "".equals(start) ? null : Long.valueOf(Long.parseLong(start));
        String end = matcher.group(3);
        Long endValue = "".equals(end) ? null : Long.valueOf(Long.parseLong(end));
        if (startValue == null && endValue != null) {
            startValue = -endValue.longValue();
            endValue = null;
        }
        if (endValue == null) {
            return new ByteRange(startValue);
        }
        try {
            return new ByteRange((long)startValue, (long)endValue);
        }
        catch (IllegalArgumentException ex) {
            String string = String.valueOf(byteRange);
            throw new RangeFormatException(string.length() != 0 ? "Invalid range format: ".concat(string) : new String("Invalid range format: "), ex);
        }
    }

    public static ByteRange parseContentRange(String contentRange) {
        Matcher matcher = CONTENT_RANGE_HEADER_PATTERN.matcher(contentRange);
        if (!matcher.matches()) {
            String string = String.valueOf(contentRange);
            throw new RangeFormatException(string.length() != 0 ? "Invalid content-range format: ".concat(string) : new String("Invalid content-range format: "));
        }
        return new ByteRange(Long.parseLong(matcher.group(1)), Long.parseLong(matcher.group(2)));
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 37 + Long.valueOf(this.start).hashCode();
        if (this.end != null) {
            hash = hash * 37 + this.end.hashCode();
        }
        return hash;
    }

    public boolean equals(Object object) {
        if (object instanceof ByteRange) {
            ByteRange key = (ByteRange)object;
            if (this.start != key.getStart()) {
                return false;
            }
            if (this.hasEnd() != key.hasEnd()) {
                return false;
            }
            if (this.hasEnd()) {
                return this.end.equals(key.getEnd());
            }
            return true;
        }
        return false;
    }
}

