/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.flogger.backend;

import com.google.appengine.repackaged.com.google.common.flogger.LogFormat;
import java.io.IOException;

public final class MessageUtil {
    private static final String ALLOWED_NEWLINE_PATTERN = "\\n|\\r(?:\\n)?";
    private static final String SYSTEM_NEWLINE = MessageUtil.getSafeSystemNewline();

    static String getSafeSystemNewline() {
        String safeNewline = "\n";
        try {
            String unsafeNewline = System.getProperty("line.separator");
            if (unsafeNewline.matches(ALLOWED_NEWLINE_PATTERN)) {
                safeNewline = unsafeNewline;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return safeNewline;
    }

    public static void unescape(LogFormat logFormat, Appendable out, String message, int start, int end) throws IOException {
        switch (logFormat) {
            case PRINTF_STYLE: {
                MessageUtil.unescapePrintf(out, message, start, end);
                break;
            }
            case BRACE_STYLE: {
                MessageUtil.unescapeBraceFormat(out, message, start, end);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    public static void unescape(LogFormat logFormat, StringBuilder out, String message, int start, int end) {
        try {
            MessageUtil.unescape(logFormat, (Appendable)out, message, start, end);
        }
        catch (IOException e) {
            throw new AssertionError();
        }
    }

    public static Appendable unescapePrintf(Appendable out, String message, int start, int end) throws IOException {
        int pos = start;
        while (pos < end) {
            if (message.charAt(pos++) != '%') continue;
            if (pos == end) break;
            char chr = message.charAt(pos);
            if (chr == '%') {
                out.append(message, start, pos);
            } else {
                if (chr != 'n') continue;
                out.append(message, start, pos - 1);
                out.append(SYSTEM_NEWLINE);
            }
            start = ++pos;
        }
        if (start < end) {
            out.append(message, start, end);
        }
        return out;
    }

    public static StringBuilder unescapePrintf(StringBuilder out, String message, int start, int end) {
        try {
            MessageUtil.unescapePrintf((Appendable)out, message, start, end);
            return out;
        }
        catch (IOException e) {
            throw new AssertionError();
        }
    }

    public static String unescapePrintf(String message) {
        StringBuilder out = new StringBuilder();
        MessageUtil.unescapePrintf(out, message, 0, message.length());
        return out.toString();
    }

    public static Appendable unescapeBraceFormat(Appendable out, String message, int start, int end) throws IOException {
        int pos = start;
        boolean isQuoted = false;
        while (pos < end) {
            char c;
            if ((c = message.charAt(pos++)) != '\\' && c != '\'') continue;
            int quoteStart = pos - 1;
            if (c == '\\' && (c = message.charAt(pos++)) != '\'') continue;
            out.append(message, start, quoteStart);
            start = pos;
            if (pos == end) break;
            if (isQuoted) {
                isQuoted = false;
                continue;
            }
            if (message.charAt(pos) != '\'') {
                isQuoted = true;
                continue;
            }
            ++pos;
        }
        if (start < end) {
            out.append(message, start, end);
        }
        return out;
    }

    public static StringBuilder unescapeBraceFormat(StringBuilder out, String message, int start, int end) {
        try {
            MessageUtil.unescapeBraceFormat((Appendable)out, message, start, end);
            return out;
        }
        catch (IOException e) {
            throw new AssertionError();
        }
    }

    public static StringBuilder appendPrintfLiteral(StringBuilder out, String literal) {
        try {
            MessageUtil.printfEscaper(out).append(literal);
            return out;
        }
        catch (IOException e) {
            throw new AssertionError((Object)"impossible");
        }
    }

    public static Appendable printfEscaper(final Appendable out) {
        return new Appendable(){

            @Override
            public Appendable append(CharSequence csq, int start, int end) throws IOException {
                int pos = start;
                while (pos < end) {
                    char c;
                    if ((c = csq.charAt(pos++)) != '%') continue;
                    out.append(csq, start, pos).append('%');
                    start = pos;
                }
                if (start < end) {
                    out.append(csq, start, end);
                }
                return this;
            }

            @Override
            public Appendable append(char c) throws IOException {
                if (c == '%') {
                    out.append("%%");
                } else {
                    out.append(c);
                }
                return this;
            }

            @Override
            public Appendable append(CharSequence csq) throws IOException {
                if (csq == null) {
                    csq = "null";
                }
                return this.append(csq, 0, csq.length());
            }
        };
    }

    public static StringBuilder appendBraceFormatLiteral(StringBuilder out, String literal) {
        try {
            MessageUtil.braceFormatEscaper(out).append(literal);
            return out;
        }
        catch (IOException e) {
            throw new AssertionError((Object)"impossible");
        }
    }

    public static Appendable braceFormatEscaper(final Appendable out) {
        return new Appendable(){

            @Override
            public Appendable append(CharSequence csq, int start, int end) throws IOException {
                int pos = start;
                while (pos < end) {
                    char c;
                    if ((c = csq.charAt(pos++)) == '\'') {
                        out.append(csq, start, pos).append('\'');
                        start = pos;
                        continue;
                    }
                    if (c != '{') continue;
                    out.append(csq, start, pos - 1).append("'{'");
                    start = pos;
                }
                if (start < end) {
                    out.append(csq, start, end);
                }
                return this;
            }

            @Override
            public Appendable append(char c) throws IOException {
                if (c == '\'') {
                    out.append("''");
                } else if (c == '{') {
                    out.append("'{'");
                } else {
                    out.append(c);
                }
                return this;
            }

            @Override
            public Appendable append(CharSequence csq) throws IOException {
                if (csq == null) {
                    csq = "null";
                }
                return this.append(csq, 0, csq.length());
            }
        };
    }

    private MessageUtil() {
    }
}

