/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.protobuf;

import com.google.appengine.repackaged.com.google.protobuf.GeneratedMessageLite;
import com.google.appengine.repackaged.com.google.protobuf.MessageInfo;
import com.google.appengine.repackaged.com.google.protobuf.MessageInfoFactory;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

class GeneratedMessageInfoFactory
implements MessageInfoFactory {
    private static final GeneratedMessageInfoFactory instance = new GeneratedMessageInfoFactory();
    private final Map<Class<?>, Method> cache = new HashMap();

    private GeneratedMessageInfoFactory() {
    }

    public static GeneratedMessageInfoFactory getInstance() {
        return instance;
    }

    @Override
    public boolean isSupported(Class<?> messageType) {
        return GeneratedMessageLite.class.isAssignableFrom(messageType);
    }

    @Override
    public MessageInfo messageInfoFor(Class<?> messageType) {
        if (!GeneratedMessageLite.class.isAssignableFrom(messageType)) {
            String string = String.valueOf(messageType.getName());
            throw new IllegalArgumentException(string.length() != 0 ? "Unsupported message type: ".concat(string) : new String("Unsupported message type: "));
        }
        try {
            Method method = this.getMethod(messageType);
            return (MessageInfo)method.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            String string = String.valueOf(messageType.getName());
            throw new RuntimeException(string.length() != 0 ? "Unable to get message info for ".concat(string) : new String("Unable to get message info for "), e);
        }
    }

    private Method getMethod(Class<?> clazz) throws NoSuchMethodException {
        Method method = this.cache.get(clazz);
        if (method != null) {
            return method;
        }
        method = clazz.getDeclaredMethod("buildMessageInfo", new Class[0]);
        method.setAccessible(true);
        this.cache.put(clazz, method);
        return method;
    }
}

