/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.protobuf;

import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.CodedOutputStream;
import com.google.appengine.repackaged.com.google.protobuf.ExtensionRegistryLite;
import com.google.appengine.repackaged.com.google.protobuf.ExtensionSchema;
import com.google.appengine.repackaged.com.google.protobuf.FieldInfo;
import com.google.appengine.repackaged.com.google.protobuf.FieldSet;
import com.google.appengine.repackaged.com.google.protobuf.FieldType;
import com.google.appengine.repackaged.com.google.protobuf.GeneratedMessageLite;
import com.google.appengine.repackaged.com.google.protobuf.Int2ObjectHashMap;
import com.google.appengine.repackaged.com.google.protobuf.Internal;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.appengine.repackaged.com.google.protobuf.ListFieldSchema;
import com.google.appengine.repackaged.com.google.protobuf.MapEntryLite;
import com.google.appengine.repackaged.com.google.protobuf.MapFieldSchema;
import com.google.appengine.repackaged.com.google.protobuf.MessageInfo;
import com.google.appengine.repackaged.com.google.protobuf.MessageLite;
import com.google.appengine.repackaged.com.google.protobuf.OneofInfo;
import com.google.appengine.repackaged.com.google.protobuf.ProtoSyntax;
import com.google.appengine.repackaged.com.google.protobuf.Protobuf;
import com.google.appengine.repackaged.com.google.protobuf.RawMessageInfo;
import com.google.appengine.repackaged.com.google.protobuf.Reader;
import com.google.appengine.repackaged.com.google.protobuf.Schema;
import com.google.appengine.repackaged.com.google.protobuf.SchemaUtil;
import com.google.appengine.repackaged.com.google.protobuf.StructuralMessageInfo;
import com.google.appengine.repackaged.com.google.protobuf.UnknownFieldSchema;
import com.google.appengine.repackaged.com.google.protobuf.UnsafeUtil;
import com.google.appengine.repackaged.com.google.protobuf.WireFormat;
import com.google.appengine.repackaged.com.google.protobuf.Writer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

final class MessageSchema<T>
implements Schema<T> {
    private static final int INT_LENGTH = 4;
    private static final int LONG_LENGTH = 8;
    private static final int LONGS_PER_FIELD = 2;
    private static final int FIELD_SHIFT = 4;
    private static final int OFFSET_BITS = 20;
    private static final int OFFSET_MASK = 1048575;
    private static final int FIELD_TYPE_MASK = 0xFF00000;
    private static final int REQUIRED_MASK = 0x10000000;
    private static final int ENFORCE_UTF8_MASK = 0x20000000;
    private static final long EMPTY_LONG = -1L;
    static final int ONEOF_TYPE_OFFSET = 51;
    private static final int FIELD_LENGTH = 16;
    private final ByteBuffer buffer;
    private final long address;
    private final long limit;
    private final int numFields;
    private final int minFieldNumber;
    private final int maxFieldNumber;
    private final PositionStrategy positionStrategy;
    private final Int2ObjectHashMap<Class<?>> messageFieldClassMap;
    private final Int2ObjectHashMap<Internal.EnumLiteMap<?>> enumFieldMap;
    private final ListFieldSchema listFieldSchema;
    private final MessageLite defaultInstance;
    private final UnknownFieldSchema<?, ?> unknownFieldSchema;
    private final boolean hasExtensions;
    private final ExtensionSchema<?> extensionSchema;
    private final boolean lite;
    private final boolean proto3;
    private final MapFieldSchema mapFieldSchema;
    private final Int2ObjectHashMap<Object> mapFieldDefaultEntryMap;
    private final int[] checkInitialized;
    private final long[] mapFieldPositions;
    private final int[] repeatedFieldOffsets;

    private MessageSchema(ByteBuffer buffer, long address, long limit, int numFields, int minFieldNumber, int maxFieldNumber, boolean table, boolean proto3, Class<T> messageClass, Int2ObjectHashMap<Class<?>> messageFieldClassMap, Int2ObjectHashMap<Internal.EnumLiteMap<?>> enumFieldMap, ListFieldSchema listFieldSchema, UnknownFieldSchema<?, ?> unknownFieldSchema, ExtensionSchema<?> extensionSchema, MapFieldSchema mapFieldSchema, Int2ObjectHashMap<Object> mapFieldDefaultEntryMap, int[] checkInitialized, MessageLite defaultInstance, long[] mapFieldPositions, int[] repeatedFieldOffsets) {
        this.buffer = buffer;
        this.address = address;
        this.limit = limit;
        this.numFields = numFields;
        this.minFieldNumber = minFieldNumber;
        this.maxFieldNumber = maxFieldNumber;
        this.positionStrategy = table ? new TablePositionStrategy() : new LookupPositionStrategy();
        this.messageFieldClassMap = messageFieldClassMap;
        this.enumFieldMap = enumFieldMap;
        this.listFieldSchema = listFieldSchema;
        this.unknownFieldSchema = unknownFieldSchema;
        this.hasExtensions = extensionSchema != null && extensionSchema.hasExtensions(messageClass);
        this.extensionSchema = extensionSchema;
        this.lite = GeneratedMessageLite.class.isAssignableFrom(messageClass);
        this.proto3 = proto3;
        this.defaultInstance = defaultInstance;
        this.mapFieldSchema = mapFieldSchema;
        this.mapFieldDefaultEntryMap = mapFieldDefaultEntryMap;
        this.checkInitialized = checkInitialized;
        this.mapFieldPositions = mapFieldPositions;
        this.repeatedFieldOffsets = repeatedFieldOffsets;
    }

    static <T> MessageSchema<T> newTableSchema(Class<T> messageClass, MessageInfo messageInfo, ListFieldSchema listFieldSchema, UnknownFieldSchema<?, ?> unknownFieldSchema, ExtensionSchema<?> extensionSchema, MapFieldSchema mapFieldSchema) {
        if (messageInfo instanceof RawMessageInfo) {
            return MessageSchema.newTableSchemaForRawMessageInfo(messageClass, (RawMessageInfo)messageInfo, listFieldSchema, unknownFieldSchema, extensionSchema, mapFieldSchema);
        }
        return MessageSchema.newTableSchemaForMessageInfo(messageClass, (StructuralMessageInfo)messageInfo, listFieldSchema, unknownFieldSchema, extensionSchema, mapFieldSchema);
    }

    static <T> MessageSchema<T> newTableSchemaForRawMessageInfo(Class<T> messageClass, RawMessageInfo messageInfo, ListFieldSchema listFieldSchema, UnknownFieldSchema<?, ?> unknownFieldSchema, ExtensionSchema<?> extensionSchema, MapFieldSchema mapFieldSchema) {
        int numEntries;
        int maxFieldNumber;
        int minFieldNumber;
        boolean isProto3;
        boolean bl = isProto3 = messageInfo.getSyntax() == ProtoSyntax.PROTO3;
        if (messageInfo.getFieldCount() == 0) {
            minFieldNumber = 0;
            maxFieldNumber = 0;
            numEntries = 0;
        } else {
            minFieldNumber = messageInfo.getMinFieldNumber();
            maxFieldNumber = messageInfo.getMaxFieldNumber();
            numEntries = maxFieldNumber - minFieldNumber + 1;
        }
        int bufferLength = numEntries * 16;
        ByteBuffer buffer = ByteBuffer.allocateDirect(bufferLength + 8);
        long tempAddress = UnsafeUtil.addressOffset(buffer);
        if ((tempAddress & 7L) != 0L) {
            tempAddress = (tempAddress & 0xFFFFFFFFFFFFFFF8L) + 8L;
        }
        long address = tempAddress;
        long limit = address + (long)bufferLength;
        long[] mapFieldPositions = messageInfo.getMapFieldCount() > 0 ? new long[messageInfo.getMapFieldCount()] : null;
        int[] repeatedFieldOffsets = messageInfo.getRepeatedFieldCount() > 0 ? new int[messageInfo.getRepeatedFieldCount()] : null;
        int mapFieldIndex = 0;
        int repeatedFieldIndex = 0;
        RawMessageInfo.RawMessageInfoReader reader = messageInfo.getReader();
        if (reader.next()) {
            int fieldNumber = reader.getFieldNumber();
            int bufferOffset = 0;
            while (true) {
                if (bufferOffset < fieldNumber - minFieldNumber << 4) {
                    long skipLimit = address + (long)bufferOffset + 16L;
                    for (long skipPos = address + (long)bufferOffset; skipPos < skipLimit; skipPos += 8L) {
                        UnsafeUtil.putLong(skipPos, -1L);
                    }
                } else {
                    long pos = address + (long)bufferOffset;
                    MessageSchema.storeFieldData(reader, pos);
                    int fieldType = reader.getFieldType();
                    if (fieldType == FieldType.MAP.ordinal()) {
                        mapFieldPositions[mapFieldIndex++] = pos;
                    } else if (fieldType >= 18 && fieldType <= 49) {
                        repeatedFieldOffsets[repeatedFieldIndex++] = (int)MessageSchema.offset(MessageSchema.typeAndOffsetAt(pos));
                    }
                    if (!reader.next()) break;
                    fieldNumber = reader.getFieldNumber();
                }
                bufferOffset += 16;
            }
        }
        return new MessageSchema<T>(buffer, address, limit, messageInfo.getFieldCount(), minFieldNumber, maxFieldNumber, true, isProto3, messageClass, reader.getMessageFieldClassMap(), reader.getEnumFieldMap(), listFieldSchema, unknownFieldSchema, extensionSchema, mapFieldSchema, reader.getMapFieldDefaultEntryMap(), messageInfo.getCheckInitialized(), messageInfo.getDefaultInstance(), mapFieldPositions, repeatedFieldOffsets);
    }

    static <T> MessageSchema<T> newTableSchemaForMessageInfo(Class<T> messageClass, StructuralMessageInfo messageInfo, ListFieldSchema listFieldSchema, UnknownFieldSchema<?, ?> unknownFieldSchema, ExtensionSchema<?> extensionSchema, MapFieldSchema mapFieldSchema) {
        int numEntries;
        int maxFieldNumber;
        int minFieldNumber;
        boolean isProto3 = messageInfo.getSyntax() == ProtoSyntax.PROTO3;
        FieldInfo[] fis = messageInfo.getFields();
        if (fis.length == 0) {
            minFieldNumber = 0;
            maxFieldNumber = 0;
            numEntries = 0;
        } else {
            minFieldNumber = fis[0].getFieldNumber();
            maxFieldNumber = fis[fis.length - 1].getFieldNumber();
            numEntries = maxFieldNumber - minFieldNumber + 1;
        }
        int bufferLength = numEntries * 16;
        ByteBuffer buffer = ByteBuffer.allocateDirect(bufferLength + 8);
        long tempAddress = UnsafeUtil.addressOffset(buffer);
        if ((tempAddress & 7L) != 0L) {
            tempAddress = (tempAddress & 0xFFFFFFFFFFFFFFF8L) + 8L;
        }
        long address = tempAddress;
        long limit = address + (long)bufferLength;
        int mapFieldCount = 0;
        int repeatedFieldCount = 0;
        for (FieldInfo fi : fis) {
            if (fi.getType() == FieldType.MAP) {
                ++mapFieldCount;
                continue;
            }
            if (fi.getType().id() < 18 || fi.getType().id() > 49) continue;
            ++repeatedFieldCount;
        }
        long[] mapFieldPositions = mapFieldCount > 0 ? new long[mapFieldCount] : null;
        int[] repeatedFieldOffsets = repeatedFieldCount > 0 ? new int[repeatedFieldCount] : null;
        mapFieldCount = 0;
        repeatedFieldCount = 0;
        int fieldIndex = 0;
        int bufferIndex = 0;
        while (fieldIndex < fis.length) {
            FieldInfo fi = fis[fieldIndex];
            int fieldNumber = fi.getFieldNumber();
            if (bufferIndex < fieldNumber - minFieldNumber << 4) {
                long skipLimit = address + (long)bufferIndex + 16L;
                for (long skipPos = address + (long)bufferIndex; skipPos < skipLimit; skipPos += 8L) {
                    UnsafeUtil.putLong(skipPos, -1L);
                }
            } else {
                long pos = address + (long)bufferIndex;
                MessageSchema.storeFieldData(fi, pos, isProto3);
                if (fi.getType() == FieldType.MAP) {
                    mapFieldPositions[mapFieldCount++] = pos;
                } else if (fi.getType().id() >= 18 && fi.getType().id() <= 49) {
                    repeatedFieldOffsets[repeatedFieldCount++] = (int)UnsafeUtil.objectFieldOffset(fi.getField());
                }
                ++fieldIndex;
            }
            bufferIndex += 16;
        }
        return new MessageSchema<T>(buffer, address, limit, fis.length, minFieldNumber, maxFieldNumber, true, isProto3, messageClass, messageInfo.messageFieldClassMap(), messageInfo.enumFieldMap(), listFieldSchema, unknownFieldSchema, extensionSchema, mapFieldSchema, messageInfo.mapFieldDefaultEntryMap(), messageInfo.getCheckInitialized(), messageInfo.getDefaultInstance(), mapFieldPositions, repeatedFieldOffsets);
    }

    static <T> MessageSchema<T> newLookupSchema(Class<T> messageClass, MessageInfo messageInfo, ListFieldSchema listFieldSchema, UnknownFieldSchema<?, ?> unknownFieldSchema, ExtensionSchema<?> extensionSchema, MapFieldSchema mapFieldSchema) {
        if (messageInfo instanceof RawMessageInfo) {
            return MessageSchema.newLookupSchemaForRawMessageInfo(messageClass, (RawMessageInfo)messageInfo, listFieldSchema, unknownFieldSchema, extensionSchema, mapFieldSchema);
        }
        return MessageSchema.newLookupSchemaForMessageInfo(messageClass, (StructuralMessageInfo)messageInfo, listFieldSchema, unknownFieldSchema, extensionSchema, mapFieldSchema);
    }

    static <T> MessageSchema<T> newLookupSchemaForRawMessageInfo(Class<T> messageClass, RawMessageInfo messageInfo, ListFieldSchema listFieldSchema, UnknownFieldSchema<?, ?> unknownFieldSchema, ExtensionSchema<?> extensionSchema, MapFieldSchema mapFieldSchema) {
        boolean isProto3 = ProtoSyntax.PROTO3.equals((Object)messageInfo.getSyntax());
        int numFields = messageInfo.getFieldCount();
        int bufferLength = numFields * 16;
        ByteBuffer buffer = ByteBuffer.allocateDirect(bufferLength + 8);
        long tempAddress = UnsafeUtil.addressOffset(buffer);
        if ((tempAddress & 7L) != 0L) {
            tempAddress = (tempAddress & 0xFFFFFFFFFFFFFFF8L) + 8L;
        }
        long address = tempAddress;
        long limit = address + (long)bufferLength;
        long[] mapFieldPositions = messageInfo.getMapFieldCount() > 0 ? new long[messageInfo.getMapFieldCount()] : null;
        int[] repeatedFieldOffsets = messageInfo.getRepeatedFieldCount() > 0 ? new int[messageInfo.getRepeatedFieldCount()] : null;
        int mapFieldIndex = 0;
        int repeatedFieldIndex = 0;
        long pos = address;
        RawMessageInfo.RawMessageInfoReader reader = messageInfo.getReader();
        while (reader.next()) {
            MessageSchema.storeFieldData(reader, pos);
            int fieldType = reader.getFieldType();
            if (fieldType == FieldType.MAP.id()) {
                mapFieldPositions[mapFieldIndex++] = pos;
            } else if (fieldType >= 18 && fieldType <= 49) {
                repeatedFieldOffsets[repeatedFieldIndex++] = (int)MessageSchema.offset(MessageSchema.typeAndOffsetAt(pos));
            }
            pos += 16L;
        }
        int minFieldNumber = -1;
        int maxFieldNumber = -1;
        if (numFields > 0) {
            minFieldNumber = messageInfo.getMinFieldNumber();
            maxFieldNumber = messageInfo.getMaxFieldNumber();
        }
        return new MessageSchema<T>(buffer, address, limit, numFields, minFieldNumber, maxFieldNumber, false, isProto3, messageClass, reader.getMessageFieldClassMap(), reader.getEnumFieldMap(), listFieldSchema, unknownFieldSchema, extensionSchema, mapFieldSchema, reader.getMapFieldDefaultEntryMap(), messageInfo.getCheckInitialized(), messageInfo.getDefaultInstance(), mapFieldPositions, repeatedFieldOffsets);
    }

    static <T> MessageSchema<T> newLookupSchemaForMessageInfo(Class<T> messageClass, StructuralMessageInfo messageInfo, ListFieldSchema listFieldSchema, UnknownFieldSchema<?, ?> unknownFieldSchema, ExtensionSchema<?> extensionSchema, MapFieldSchema mapFieldSchema) {
        boolean isProto3 = ProtoSyntax.PROTO3.equals((Object)messageInfo.getSyntax());
        FieldInfo[] fis = messageInfo.getFields();
        int numFields = fis.length;
        int bufferLength = numFields * 16;
        ByteBuffer buffer = ByteBuffer.allocateDirect(bufferLength + 8);
        long tempAddress = UnsafeUtil.addressOffset(buffer);
        if ((tempAddress & 7L) != 0L) {
            tempAddress = (tempAddress & 0xFFFFFFFFFFFFFFF8L) + 8L;
        }
        long address = tempAddress;
        long limit = address + (long)bufferLength;
        int mapFieldCount = 0;
        int repeatedFieldCount = 0;
        for (FieldInfo fi : fis) {
            if (fi.getType() == FieldType.MAP) {
                ++mapFieldCount;
                continue;
            }
            if (fi.getType().id() < 18 || fi.getType().id() > 49) continue;
            ++repeatedFieldCount;
        }
        long[] mapFieldPositions = mapFieldCount > 0 ? new long[mapFieldCount] : null;
        int[] repeatedFieldOffsets = repeatedFieldCount > 0 ? new int[repeatedFieldCount] : null;
        mapFieldCount = 0;
        repeatedFieldCount = 0;
        long pos = address;
        int i = 0;
        while (i < fis.length) {
            FieldInfo fi = fis[i];
            MessageSchema.storeFieldData(fi, pos, isProto3);
            if (fi.getType() == FieldType.MAP) {
                mapFieldPositions[mapFieldCount++] = pos;
            } else if (fi.getType().id() >= 18 && fi.getType().id() <= 49) {
                repeatedFieldOffsets[repeatedFieldCount++] = (int)UnsafeUtil.objectFieldOffset(fi.getField());
            }
            ++i;
            pos += 16L;
        }
        int minFieldNumber = -1;
        int maxFieldNumber = -1;
        if (numFields > 0) {
            minFieldNumber = fis[0].getFieldNumber();
            maxFieldNumber = fis[numFields - 1].getFieldNumber();
        }
        return new MessageSchema<T>(buffer, address, limit, fis.length, minFieldNumber, maxFieldNumber, false, isProto3, messageClass, messageInfo.messageFieldClassMap(), messageInfo.enumFieldMap(), listFieldSchema, unknownFieldSchema, extensionSchema, mapFieldSchema, messageInfo.mapFieldDefaultEntryMap(), messageInfo.getCheckInitialized(), messageInfo.getDefaultInstance(), mapFieldPositions, repeatedFieldOffsets);
    }

    private static void storeFieldData(FieldInfo fi, long pos, boolean proto3) {
        int presenceMaskShift;
        int presenceFieldOffset;
        int fieldOffset;
        int typeId;
        OneofInfo oneof = fi.getOneof();
        if (oneof != null) {
            typeId = fi.getType().id() + 51;
            fieldOffset = (int)UnsafeUtil.objectFieldOffset(oneof.getValueField());
            presenceFieldOffset = (int)UnsafeUtil.objectFieldOffset(oneof.getCaseField());
            presenceMaskShift = 0;
        } else {
            FieldType type = fi.getType();
            fieldOffset = (int)UnsafeUtil.objectFieldOffset(fi.getField());
            typeId = type.id();
            if (!(proto3 || type.isList() || type.isMap())) {
                presenceFieldOffset = (int)UnsafeUtil.objectFieldOffset(fi.getPresenceField());
                presenceMaskShift = Integer.numberOfTrailingZeros(fi.getPresenceMask());
            } else {
                presenceFieldOffset = 0;
                presenceMaskShift = 0;
            }
        }
        UnsafeUtil.putInt(pos, fi.getFieldNumber());
        UnsafeUtil.putInt(pos + 4L, (fi.isEnforceUtf8() ? 0x20000000 : 0) | (fi.isRequired() ? 0x10000000 : 0) | typeId << 20 | fieldOffset);
        UnsafeUtil.putInt(pos + 8L, presenceMaskShift << 20 | presenceFieldOffset);
    }

    private static void storeFieldData(RawMessageInfo.RawMessageInfoReader reader, long pos) {
        int presenceMaskShift;
        int presenceFieldOffset;
        int fieldOffset;
        if (reader.isOneof()) {
            fieldOffset = (int)UnsafeUtil.objectFieldOffset(reader.getOneofField());
            presenceFieldOffset = (int)UnsafeUtil.objectFieldOffset(reader.getOneofCaseField());
            presenceMaskShift = 0;
        } else {
            fieldOffset = (int)UnsafeUtil.objectFieldOffset(reader.getField());
            if (reader.hasFieldPresence()) {
                presenceFieldOffset = (int)UnsafeUtil.objectFieldOffset(reader.getHasBitsField());
                presenceMaskShift = reader.getHasBitsMaskShift();
            } else {
                presenceFieldOffset = 0;
                presenceMaskShift = 0;
            }
        }
        UnsafeUtil.putInt(pos, reader.getFieldNumber());
        UnsafeUtil.putInt(pos + 4L, (reader.isEnforceUtf8() ? 0x20000000 : 0) | (reader.isRequired() ? 0x10000000 : 0) | reader.getFieldType() << 20 | fieldOffset);
        UnsafeUtil.putInt(pos + 8L, presenceMaskShift << 20 | presenceFieldOffset);
    }

    @Override
    public T newInstance() {
        return (T)this.defaultInstance.newBuilderForType().buildPartial();
    }

    @Override
    public boolean equals(T message, T other) {
        Object otherUnknown;
        for (long pos = this.address; pos < this.limit; pos += 16L) {
            if (this.equals(message, other, pos)) continue;
            return false;
        }
        Object messageUnknown = this.unknownFieldSchema.getFromMessage(message);
        if (!messageUnknown.equals(otherUnknown = this.unknownFieldSchema.getFromMessage(other))) {
            return false;
        }
        if (this.hasExtensions) {
            FieldSet<?> messageExtensions = this.extensionSchema.getExtensions(message);
            FieldSet<?> otherExtensions = this.extensionSchema.getExtensions(other);
            return messageExtensions.equals(otherExtensions);
        }
        return true;
    }

    private boolean equals(T message, T other, long pos) {
        int typeAndOffset = MessageSchema.typeAndOffsetAt(pos);
        long offset = MessageSchema.offset(typeAndOffset);
        switch (MessageSchema.type(typeAndOffset)) {
            case 0: {
                return this.arePresentForEquals(message, other, pos) && UnsafeUtil.getLong(message, offset) == UnsafeUtil.getLong(other, offset);
            }
            case 1: {
                return this.arePresentForEquals(message, other, pos) && UnsafeUtil.getInt(message, offset) == UnsafeUtil.getInt(other, offset);
            }
            case 2: {
                return this.arePresentForEquals(message, other, pos) && UnsafeUtil.getLong(message, offset) == UnsafeUtil.getLong(other, offset);
            }
            case 3: {
                return this.arePresentForEquals(message, other, pos) && UnsafeUtil.getLong(message, offset) == UnsafeUtil.getLong(other, offset);
            }
            case 4: {
                return this.arePresentForEquals(message, other, pos) && UnsafeUtil.getInt(message, offset) == UnsafeUtil.getInt(other, offset);
            }
            case 5: {
                return this.arePresentForEquals(message, other, pos) && UnsafeUtil.getLong(message, offset) == UnsafeUtil.getLong(other, offset);
            }
            case 6: {
                return this.arePresentForEquals(message, other, pos) && UnsafeUtil.getInt(message, offset) == UnsafeUtil.getInt(other, offset);
            }
            case 7: {
                return this.arePresentForEquals(message, other, pos) && UnsafeUtil.getBoolean(message, offset) == UnsafeUtil.getBoolean(other, offset);
            }
            case 8: {
                return this.arePresentForEquals(message, other, pos) && SchemaUtil.safeEquals(UnsafeUtil.getObject(message, offset), UnsafeUtil.getObject(other, offset));
            }
            case 9: {
                return this.arePresentForEquals(message, other, pos) && SchemaUtil.safeEquals(UnsafeUtil.getObject(message, offset), UnsafeUtil.getObject(other, offset));
            }
            case 10: {
                return this.arePresentForEquals(message, other, pos) && SchemaUtil.safeEquals(UnsafeUtil.getObject(message, offset), UnsafeUtil.getObject(other, offset));
            }
            case 11: {
                return this.arePresentForEquals(message, other, pos) && UnsafeUtil.getInt(message, offset) == UnsafeUtil.getInt(other, offset);
            }
            case 12: {
                return this.arePresentForEquals(message, other, pos) && UnsafeUtil.getInt(message, offset) == UnsafeUtil.getInt(other, offset);
            }
            case 13: {
                return this.arePresentForEquals(message, other, pos) && UnsafeUtil.getInt(message, offset) == UnsafeUtil.getInt(other, offset);
            }
            case 14: {
                return this.arePresentForEquals(message, other, pos) && UnsafeUtil.getLong(message, offset) == UnsafeUtil.getLong(other, offset);
            }
            case 15: {
                return this.arePresentForEquals(message, other, pos) && UnsafeUtil.getInt(message, offset) == UnsafeUtil.getInt(other, offset);
            }
            case 16: {
                return this.arePresentForEquals(message, other, pos) && UnsafeUtil.getLong(message, offset) == UnsafeUtil.getLong(other, offset);
            }
            case 17: {
                return this.arePresentForEquals(message, other, pos) && SchemaUtil.safeEquals(UnsafeUtil.getObject(message, offset), UnsafeUtil.getObject(other, offset));
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                return SchemaUtil.safeEquals(UnsafeUtil.getObject(message, offset), UnsafeUtil.getObject(other, offset));
            }
            case 50: {
                return SchemaUtil.safeEquals(UnsafeUtil.getObject(message, offset), UnsafeUtil.getObject(other, offset));
            }
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                return this.isOneofCaseEqual(message, other, pos) && SchemaUtil.safeEquals(UnsafeUtil.getObject(message, offset), UnsafeUtil.getObject(other, offset));
            }
        }
        return true;
    }

    @Override
    public int hashCode(T message) {
        int hashCode = 0;
        block40: for (long pos = this.address; pos < this.limit; pos += 16L) {
            int typeAndOffset = MessageSchema.typeAndOffsetAt(pos);
            int entryNumber = MessageSchema.numberAt(pos);
            long offset = MessageSchema.offset(typeAndOffset);
            switch (MessageSchema.type(typeAndOffset)) {
                case 0: {
                    hashCode = hashCode * 53 + Internal.hashLong(Double.doubleToLongBits(UnsafeUtil.getDouble(message, offset)));
                    continue block40;
                }
                case 1: {
                    hashCode = hashCode * 53 + Float.floatToIntBits(UnsafeUtil.getFloat(message, offset));
                    continue block40;
                }
                case 2: {
                    hashCode = hashCode * 53 + Internal.hashLong(UnsafeUtil.getLong(message, offset));
                    continue block40;
                }
                case 3: {
                    hashCode = hashCode * 53 + Internal.hashLong(UnsafeUtil.getLong(message, offset));
                    continue block40;
                }
                case 4: {
                    hashCode = hashCode * 53 + UnsafeUtil.getInt(message, offset);
                    continue block40;
                }
                case 5: {
                    hashCode = hashCode * 53 + Internal.hashLong(UnsafeUtil.getLong(message, offset));
                    continue block40;
                }
                case 6: {
                    hashCode = hashCode * 53 + UnsafeUtil.getInt(message, offset);
                    continue block40;
                }
                case 7: {
                    hashCode = hashCode * 53 + Internal.hashBoolean(UnsafeUtil.getBoolean(message, offset));
                    continue block40;
                }
                case 8: {
                    hashCode = hashCode * 53 + ((String)UnsafeUtil.getObject(message, offset)).hashCode();
                    continue block40;
                }
                case 9: {
                    int protoHash = 37;
                    Object submessage = UnsafeUtil.getObject(message, offset);
                    if (submessage != null) {
                        protoHash = submessage.hashCode();
                    }
                    hashCode = 53 * hashCode + protoHash;
                    continue block40;
                }
                case 10: {
                    hashCode = hashCode * 53 + UnsafeUtil.getObject(message, offset).hashCode();
                    continue block40;
                }
                case 11: {
                    hashCode = hashCode * 53 + UnsafeUtil.getInt(message, offset);
                    continue block40;
                }
                case 12: {
                    hashCode = hashCode * 53 + UnsafeUtil.getInt(message, offset);
                    continue block40;
                }
                case 13: {
                    hashCode = hashCode * 53 + UnsafeUtil.getInt(message, offset);
                    continue block40;
                }
                case 14: {
                    hashCode = hashCode * 53 + Internal.hashLong(UnsafeUtil.getLong(message, offset));
                    continue block40;
                }
                case 15: {
                    hashCode = hashCode * 53 + UnsafeUtil.getInt(message, offset);
                    continue block40;
                }
                case 16: {
                    hashCode = hashCode * 53 + Internal.hashLong(UnsafeUtil.getLong(message, offset));
                    continue block40;
                }
                case 17: {
                    int protoHash = 37;
                    Object submessage = UnsafeUtil.getObject(message, offset);
                    if (submessage != null) {
                        protoHash = submessage.hashCode();
                    }
                    hashCode = 53 * hashCode + protoHash;
                    continue block40;
                }
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: {
                    hashCode = hashCode * 53 + UnsafeUtil.getObject(message, offset).hashCode();
                    continue block40;
                }
                case 50: {
                    hashCode = hashCode * 53 + UnsafeUtil.getObject(message, offset).hashCode();
                    continue block40;
                }
                case 51: {
                    if (!this.isOneofPresent(message, entryNumber, pos)) continue block40;
                    hashCode = hashCode * 53 + Internal.hashLong(Double.doubleToLongBits(MessageSchema.oneofDoubleAt(message, offset)));
                    continue block40;
                }
                case 52: {
                    if (!this.isOneofPresent(message, entryNumber, pos)) continue block40;
                    hashCode = hashCode * 53 + Float.floatToIntBits(MessageSchema.oneofFloatAt(message, offset));
                    continue block40;
                }
                case 53: {
                    if (!this.isOneofPresent(message, entryNumber, pos)) continue block40;
                    hashCode = hashCode * 53 + Internal.hashLong(MessageSchema.oneofLongAt(message, offset));
                    continue block40;
                }
                case 54: {
                    if (!this.isOneofPresent(message, entryNumber, pos)) continue block40;
                    hashCode = hashCode * 53 + Internal.hashLong(MessageSchema.oneofLongAt(message, offset));
                    continue block40;
                }
                case 55: {
                    if (!this.isOneofPresent(message, entryNumber, pos)) continue block40;
                    hashCode = hashCode * 53 + MessageSchema.oneofIntAt(message, offset);
                    continue block40;
                }
                case 56: {
                    if (!this.isOneofPresent(message, entryNumber, pos)) continue block40;
                    hashCode = hashCode * 53 + Internal.hashLong(MessageSchema.oneofLongAt(message, offset));
                    continue block40;
                }
                case 57: {
                    if (!this.isOneofPresent(message, entryNumber, pos)) continue block40;
                    hashCode = hashCode * 53 + MessageSchema.oneofIntAt(message, offset);
                    continue block40;
                }
                case 58: {
                    if (!this.isOneofPresent(message, entryNumber, pos)) continue block40;
                    hashCode = hashCode * 53 + Internal.hashBoolean(MessageSchema.oneofBooleanAt(message, offset));
                    continue block40;
                }
                case 59: {
                    if (!this.isOneofPresent(message, entryNumber, pos)) continue block40;
                    hashCode = hashCode * 53 + ((String)UnsafeUtil.getObject(message, offset)).hashCode();
                    continue block40;
                }
                case 60: {
                    if (!this.isOneofPresent(message, entryNumber, pos)) continue block40;
                    Object submessage = UnsafeUtil.getObject(message, offset);
                    hashCode = 53 * hashCode + submessage.hashCode();
                    continue block40;
                }
                case 61: {
                    if (!this.isOneofPresent(message, entryNumber, pos)) continue block40;
                    hashCode = hashCode * 53 + UnsafeUtil.getObject(message, offset).hashCode();
                    continue block40;
                }
                case 62: {
                    if (!this.isOneofPresent(message, entryNumber, pos)) continue block40;
                    hashCode = hashCode * 53 + MessageSchema.oneofIntAt(message, offset);
                    continue block40;
                }
                case 63: {
                    if (!this.isOneofPresent(message, entryNumber, pos)) continue block40;
                    hashCode = hashCode * 53 + MessageSchema.oneofIntAt(message, offset);
                    continue block40;
                }
                case 64: {
                    if (!this.isOneofPresent(message, entryNumber, pos)) continue block40;
                    hashCode = hashCode * 53 + MessageSchema.oneofIntAt(message, offset);
                    continue block40;
                }
                case 65: {
                    if (!this.isOneofPresent(message, entryNumber, pos)) continue block40;
                    hashCode = hashCode * 53 + Internal.hashLong(MessageSchema.oneofLongAt(message, offset));
                    continue block40;
                }
                case 66: {
                    if (!this.isOneofPresent(message, entryNumber, pos)) continue block40;
                    hashCode = hashCode * 53 + MessageSchema.oneofIntAt(message, offset);
                    continue block40;
                }
                case 67: {
                    if (!this.isOneofPresent(message, entryNumber, pos)) continue block40;
                    hashCode = hashCode * 53 + Internal.hashLong(MessageSchema.oneofLongAt(message, offset));
                    continue block40;
                }
                case 68: {
                    if (!this.isOneofPresent(message, entryNumber, pos)) continue block40;
                    Object submessage = UnsafeUtil.getObject(message, offset);
                    hashCode = 53 * hashCode + submessage.hashCode();
                    continue block40;
                }
            }
        }
        hashCode = hashCode * 53 + this.unknownFieldSchema.getFromMessage(message).hashCode();
        if (this.hasExtensions) {
            hashCode = hashCode * 53 + this.extensionSchema.getExtensions(message).hashCode();
        }
        return hashCode;
    }

    @Override
    public void mergeFrom(T message, T other) {
        if (other == null) {
            throw new NullPointerException();
        }
        for (long pos = this.address; pos < this.limit; pos += 16L) {
            this.mergeSingleField(message, other, pos);
        }
        if (!this.proto3) {
            SchemaUtil.mergeUnknownFields(this.unknownFieldSchema, message, other);
            if (this.hasExtensions) {
                SchemaUtil.mergeExtensions(this.extensionSchema, message, other);
            }
        }
    }

    private void mergeSingleField(T message, T other, long pos) {
        int typeAndOffset = MessageSchema.typeAndOffsetAt(pos);
        long offset = MessageSchema.offset(typeAndOffset);
        int number = MessageSchema.numberAt(pos);
        switch (MessageSchema.type(typeAndOffset)) {
            case 0: {
                if (!this.isFieldPresent(other, pos)) break;
                UnsafeUtil.putDouble(message, offset, UnsafeUtil.getDouble(other, offset));
                this.setFieldPresent(message, pos);
                break;
            }
            case 1: {
                if (!this.isFieldPresent(other, pos)) break;
                UnsafeUtil.putFloat(message, offset, UnsafeUtil.getFloat(other, offset));
                this.setFieldPresent(message, pos);
                break;
            }
            case 2: {
                if (!this.isFieldPresent(other, pos)) break;
                UnsafeUtil.putLong(message, offset, UnsafeUtil.getLong(other, offset));
                this.setFieldPresent(message, pos);
                break;
            }
            case 3: {
                if (!this.isFieldPresent(other, pos)) break;
                UnsafeUtil.putLong(message, offset, UnsafeUtil.getLong(other, offset));
                this.setFieldPresent(message, pos);
                break;
            }
            case 4: {
                if (!this.isFieldPresent(other, pos)) break;
                UnsafeUtil.putInt(message, offset, UnsafeUtil.getInt(other, offset));
                this.setFieldPresent(message, pos);
                break;
            }
            case 5: {
                if (!this.isFieldPresent(other, pos)) break;
                UnsafeUtil.putLong(message, offset, UnsafeUtil.getLong(other, offset));
                this.setFieldPresent(message, pos);
                break;
            }
            case 6: {
                if (!this.isFieldPresent(other, pos)) break;
                UnsafeUtil.putInt(message, offset, UnsafeUtil.getInt(other, offset));
                this.setFieldPresent(message, pos);
                break;
            }
            case 7: {
                if (!this.isFieldPresent(other, pos)) break;
                UnsafeUtil.putBoolean(message, offset, UnsafeUtil.getBoolean(other, offset));
                this.setFieldPresent(message, pos);
                break;
            }
            case 8: {
                if (!this.isFieldPresent(other, pos)) break;
                UnsafeUtil.putObject(message, offset, UnsafeUtil.getObject(other, offset));
                this.setFieldPresent(message, pos);
                break;
            }
            case 9: {
                this.mergeMessage(message, other, pos);
                break;
            }
            case 10: {
                if (!this.isFieldPresent(other, pos)) break;
                UnsafeUtil.putObject(message, offset, UnsafeUtil.getObject(other, offset));
                this.setFieldPresent(message, pos);
                break;
            }
            case 11: {
                if (!this.isFieldPresent(other, pos)) break;
                UnsafeUtil.putInt(message, offset, UnsafeUtil.getInt(other, offset));
                this.setFieldPresent(message, pos);
                break;
            }
            case 12: {
                if (!this.isFieldPresent(other, pos)) break;
                UnsafeUtil.putInt(message, offset, UnsafeUtil.getInt(other, offset));
                this.setFieldPresent(message, pos);
                break;
            }
            case 13: {
                if (!this.isFieldPresent(other, pos)) break;
                UnsafeUtil.putInt(message, offset, UnsafeUtil.getInt(other, offset));
                this.setFieldPresent(message, pos);
                break;
            }
            case 14: {
                if (!this.isFieldPresent(other, pos)) break;
                UnsafeUtil.putLong(message, offset, UnsafeUtil.getLong(other, offset));
                this.setFieldPresent(message, pos);
                break;
            }
            case 15: {
                if (!this.isFieldPresent(other, pos)) break;
                UnsafeUtil.putInt(message, offset, UnsafeUtil.getInt(other, offset));
                this.setFieldPresent(message, pos);
                break;
            }
            case 16: {
                if (!this.isFieldPresent(other, pos)) break;
                UnsafeUtil.putLong(message, offset, UnsafeUtil.getLong(other, offset));
                this.setFieldPresent(message, pos);
                break;
            }
            case 17: {
                this.mergeMessage(message, other, pos);
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                this.listFieldSchema.mergeListsAt(message, other, offset);
                break;
            }
            case 50: {
                SchemaUtil.mergeMap(this.mapFieldSchema, message, other, offset);
                break;
            }
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                if (!this.isOneofPresent(other, number, pos)) break;
                UnsafeUtil.putObject(message, offset, UnsafeUtil.getObject(other, offset));
                this.setOneofPresent(message, number, pos);
                break;
            }
            case 60: {
                this.mergeOneofMessage(message, other, pos);
                break;
            }
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                if (!this.isOneofPresent(other, number, pos)) break;
                UnsafeUtil.putObject(message, offset, UnsafeUtil.getObject(other, offset));
                this.setOneofPresent(message, number, pos);
                break;
            }
            case 68: {
                this.mergeOneofMessage(message, other, pos);
                break;
            }
        }
    }

    private void mergeMessage(T message, T other, long pos) {
        int typeAndOffset = MessageSchema.typeAndOffsetAt(pos);
        long offset = MessageSchema.offset(typeAndOffset);
        if (!this.isFieldPresent(other, pos)) {
            return;
        }
        Object mine = UnsafeUtil.getObject(message, offset);
        Object theirs = UnsafeUtil.getObject(other, offset);
        if (mine != null && theirs != null) {
            Object merged = Internal.mergeMessage(mine, theirs);
            UnsafeUtil.putObject(message, offset, merged);
            this.setFieldPresent(message, pos);
        } else if (theirs != null) {
            UnsafeUtil.putObject(message, offset, theirs);
            this.setFieldPresent(message, pos);
        }
    }

    private void mergeOneofMessage(T message, T other, long pos) {
        int typeAndOffset = MessageSchema.typeAndOffsetAt(pos);
        int number = MessageSchema.numberAt(pos);
        long offset = MessageSchema.offset(typeAndOffset);
        if (!this.isOneofPresent(other, number, pos)) {
            return;
        }
        Object mine = UnsafeUtil.getObject(message, offset);
        Object theirs = UnsafeUtil.getObject(other, offset);
        if (mine != null && theirs != null) {
            Object merged = Internal.mergeMessage(mine, theirs);
            UnsafeUtil.putObject(message, offset, merged);
            this.setOneofPresent(message, number, pos);
        } else if (theirs != null) {
            UnsafeUtil.putObject(message, offset, theirs);
            this.setOneofPresent(message, number, pos);
        }
    }

    @Override
    public int getSerializedSize(T message) {
        int size = 0;
        for (long pos = this.address; pos < this.limit; pos += 16L) {
            size += this.getSerializedSize(message, pos);
        }
        size += this.getUnknownFieldsSerializedSize(this.unknownFieldSchema, message);
        if (this.hasExtensions) {
            size += this.extensionSchema.getExtensions(message).getSerializedSize();
        }
        return size;
    }

    private <UT, UB> int getUnknownFieldsSerializedSize(UnknownFieldSchema<UT, UB> schema, T message) {
        UT unknowns = schema.getFromMessage(message);
        return schema.getSerializedSize(unknowns);
    }

    private int getSerializedSize(T message, long pos) {
        int typeAndOffset = MessageSchema.typeAndOffsetAt(pos);
        int number = MessageSchema.numberAt(pos);
        long offset = MessageSchema.offset(typeAndOffset);
        switch (MessageSchema.type(typeAndOffset)) {
            case 0: {
                if (!this.isFieldPresent(message, pos)) break;
                return CodedOutputStream.computeDoubleSize(number, 0.0);
            }
            case 1: {
                if (!this.isFieldPresent(message, pos)) break;
                return CodedOutputStream.computeFloatSize(number, 0.0f);
            }
            case 2: {
                if (!this.isFieldPresent(message, pos)) break;
                return CodedOutputStream.computeInt64Size(number, UnsafeUtil.getLong(message, offset));
            }
            case 3: {
                if (!this.isFieldPresent(message, pos)) break;
                return CodedOutputStream.computeUInt64Size(number, UnsafeUtil.getLong(message, offset));
            }
            case 4: {
                if (!this.isFieldPresent(message, pos)) break;
                return CodedOutputStream.computeInt32Size(number, UnsafeUtil.getInt(message, offset));
            }
            case 5: {
                if (!this.isFieldPresent(message, pos)) break;
                return CodedOutputStream.computeFixed64Size(number, 0L);
            }
            case 6: {
                if (!this.isFieldPresent(message, pos)) break;
                return CodedOutputStream.computeFixed32Size(number, 0);
            }
            case 7: {
                if (!this.isFieldPresent(message, pos)) break;
                return CodedOutputStream.computeBoolSize(number, true);
            }
            case 8: {
                if (!this.isFieldPresent(message, pos)) break;
                Object value = UnsafeUtil.getObject(message, offset);
                if (value instanceof ByteString) {
                    return CodedOutputStream.computeBytesSize(number, (ByteString)value);
                }
                return CodedOutputStream.computeStringSize(number, (String)value);
            }
            case 9: {
                if (!this.isFieldPresent(message, pos)) break;
                Object value = UnsafeUtil.getObject(message, offset);
                return SchemaUtil.computeSizeMessage(number, value);
            }
            case 10: {
                if (!this.isFieldPresent(message, pos)) break;
                ByteString value = (ByteString)UnsafeUtil.getObject(message, offset);
                return CodedOutputStream.computeBytesSize(number, value);
            }
            case 11: {
                if (!this.isFieldPresent(message, pos)) break;
                return CodedOutputStream.computeUInt32Size(number, UnsafeUtil.getInt(message, offset));
            }
            case 12: {
                if (!this.isFieldPresent(message, pos)) break;
                return CodedOutputStream.computeEnumSize(number, UnsafeUtil.getInt(message, offset));
            }
            case 13: {
                if (!this.isFieldPresent(message, pos)) break;
                return CodedOutputStream.computeSFixed32Size(number, 0);
            }
            case 14: {
                if (!this.isFieldPresent(message, pos)) break;
                return CodedOutputStream.computeSFixed64Size(number, 0L);
            }
            case 15: {
                if (!this.isFieldPresent(message, pos)) break;
                return CodedOutputStream.computeSInt32Size(number, UnsafeUtil.getInt(message, offset));
            }
            case 16: {
                if (!this.isFieldPresent(message, pos)) break;
                return CodedOutputStream.computeSInt64Size(number, UnsafeUtil.getLong(message, offset));
            }
            case 17: {
                if (!this.isFieldPresent(message, pos)) break;
                return CodedOutputStream.computeGroupSize(number, (MessageLite)UnsafeUtil.getObject(message, offset));
            }
            case 18: {
                return SchemaUtil.computeSizeFixed64Size(number, MessageSchema.listAt(message, offset), false);
            }
            case 19: {
                return SchemaUtil.computeSizeFixed32Size(number, MessageSchema.listAt(message, offset), false);
            }
            case 20: {
                return SchemaUtil.computeSizeInt64List(number, MessageSchema.listAt(message, offset), false);
            }
            case 21: {
                return SchemaUtil.computeSizeUInt64List(number, MessageSchema.listAt(message, offset), false);
            }
            case 22: {
                return SchemaUtil.computeSizeInt32List(number, MessageSchema.listAt(message, offset), false);
            }
            case 23: {
                return SchemaUtil.computeSizeFixed64Size(number, MessageSchema.listAt(message, offset), false);
            }
            case 24: {
                return SchemaUtil.computeSizeFixed32Size(number, MessageSchema.listAt(message, offset), false);
            }
            case 25: {
                return SchemaUtil.computeSizeBoolList(number, MessageSchema.listAt(message, offset), false);
            }
            case 26: {
                return SchemaUtil.computeSizeStringList(number, MessageSchema.listAt(message, offset));
            }
            case 27: {
                return SchemaUtil.computeSizeMessageList(number, MessageSchema.listAt(message, offset));
            }
            case 28: {
                return SchemaUtil.computeSizeByteStringList(number, MessageSchema.listAt(message, offset));
            }
            case 29: {
                return SchemaUtil.computeSizeUInt32List(number, MessageSchema.listAt(message, offset), false);
            }
            case 30: {
                return SchemaUtil.computeSizeEnumList(number, MessageSchema.listAt(message, offset), false);
            }
            case 31: {
                return SchemaUtil.computeSizeFixed32Size(number, MessageSchema.listAt(message, offset), false);
            }
            case 32: {
                return SchemaUtil.computeSizeFixed64Size(number, MessageSchema.listAt(message, offset), false);
            }
            case 33: {
                return SchemaUtil.computeSizeSInt32List(number, MessageSchema.listAt(message, offset), false);
            }
            case 34: {
                return SchemaUtil.computeSizeSInt64List(number, MessageSchema.listAt(message, offset), false);
            }
            case 35: {
                return SchemaUtil.computeSizeFixed64Size(number, MessageSchema.listAt(message, offset), true);
            }
            case 36: {
                return SchemaUtil.computeSizeFixed32Size(number, MessageSchema.listAt(message, offset), true);
            }
            case 37: {
                return SchemaUtil.computeSizeInt64List(number, MessageSchema.listAt(message, offset), true);
            }
            case 38: {
                return SchemaUtil.computeSizeUInt64List(number, MessageSchema.listAt(message, offset), true);
            }
            case 39: {
                return SchemaUtil.computeSizeInt32List(number, MessageSchema.listAt(message, offset), true);
            }
            case 40: {
                return SchemaUtil.computeSizeFixed64Size(number, MessageSchema.listAt(message, offset), true);
            }
            case 41: {
                return SchemaUtil.computeSizeFixed32Size(number, MessageSchema.listAt(message, offset), true);
            }
            case 42: {
                return SchemaUtil.computeSizeBoolList(number, MessageSchema.listAt(message, offset), true);
            }
            case 43: {
                return SchemaUtil.computeSizeUInt32List(number, MessageSchema.listAt(message, offset), true);
            }
            case 44: {
                return SchemaUtil.computeSizeEnumList(number, MessageSchema.listAt(message, offset), true);
            }
            case 45: {
                return SchemaUtil.computeSizeFixed32Size(number, MessageSchema.listAt(message, offset), true);
            }
            case 46: {
                return SchemaUtil.computeSizeFixed64Size(number, MessageSchema.listAt(message, offset), true);
            }
            case 47: {
                return SchemaUtil.computeSizeSInt32List(number, MessageSchema.listAt(message, offset), true);
            }
            case 48: {
                return SchemaUtil.computeSizeSInt64List(number, MessageSchema.listAt(message, offset), true);
            }
            case 49: {
                return SchemaUtil.computeSizeGroupList(number, MessageSchema.listAt(message, offset));
            }
            case 50: {
                return this.mapFieldSchema.getSerializedSize(number, UnsafeUtil.getObject(message, offset), this.mapFieldDefaultEntryMap.get(number));
            }
            case 51: {
                if (!this.isOneofPresent(message, number, pos)) break;
                return CodedOutputStream.computeDoubleSize(number, 0.0);
            }
            case 52: {
                if (!this.isOneofPresent(message, number, pos)) break;
                return CodedOutputStream.computeFloatSize(number, 0.0f);
            }
            case 53: {
                if (!this.isOneofPresent(message, number, pos)) break;
                return CodedOutputStream.computeInt64Size(number, MessageSchema.oneofLongAt(message, offset));
            }
            case 54: {
                if (!this.isOneofPresent(message, number, pos)) break;
                return CodedOutputStream.computeUInt64Size(number, MessageSchema.oneofLongAt(message, offset));
            }
            case 55: {
                if (!this.isOneofPresent(message, number, pos)) break;
                return CodedOutputStream.computeInt32Size(number, MessageSchema.oneofIntAt(message, offset));
            }
            case 56: {
                if (!this.isOneofPresent(message, number, pos)) break;
                return CodedOutputStream.computeFixed64Size(number, 0L);
            }
            case 57: {
                if (!this.isOneofPresent(message, number, pos)) break;
                return CodedOutputStream.computeFixed32Size(number, 0);
            }
            case 58: {
                if (!this.isOneofPresent(message, number, pos)) break;
                return CodedOutputStream.computeBoolSize(number, true);
            }
            case 59: {
                if (!this.isOneofPresent(message, number, pos)) break;
                Object value = UnsafeUtil.getObject(message, offset);
                if (value instanceof ByteString) {
                    return CodedOutputStream.computeBytesSize(number, (ByteString)value);
                }
                return CodedOutputStream.computeStringSize(number, (String)value);
            }
            case 60: {
                if (!this.isOneofPresent(message, number, pos)) break;
                Object value = UnsafeUtil.getObject(message, offset);
                return SchemaUtil.computeSizeMessage(number, value);
            }
            case 61: {
                if (!this.isOneofPresent(message, number, pos)) break;
                return CodedOutputStream.computeBytesSize(number, (ByteString)UnsafeUtil.getObject(message, offset));
            }
            case 62: {
                if (!this.isOneofPresent(message, number, pos)) break;
                return CodedOutputStream.computeUInt32Size(number, MessageSchema.oneofIntAt(message, offset));
            }
            case 63: {
                if (!this.isOneofPresent(message, number, pos)) break;
                return CodedOutputStream.computeEnumSize(number, MessageSchema.oneofIntAt(message, offset));
            }
            case 64: {
                if (!this.isOneofPresent(message, number, pos)) break;
                return CodedOutputStream.computeSFixed32Size(number, 0);
            }
            case 65: {
                if (!this.isOneofPresent(message, number, pos)) break;
                return CodedOutputStream.computeSFixed64Size(number, 0L);
            }
            case 66: {
                if (!this.isOneofPresent(message, number, pos)) break;
                return CodedOutputStream.computeSInt32Size(number, MessageSchema.oneofIntAt(message, offset));
            }
            case 67: {
                if (!this.isOneofPresent(message, number, pos)) break;
                return CodedOutputStream.computeSInt64Size(number, MessageSchema.oneofLongAt(message, offset));
            }
            case 68: {
                if (!this.isOneofPresent(message, number, pos)) break;
                return CodedOutputStream.computeGroupSize(number, (MessageLite)UnsafeUtil.getObject(message, offset));
            }
            default: {
                return 0;
            }
        }
        return 0;
    }

    private static <E> List<E> listAt(Object message, long offset) {
        return (List)UnsafeUtil.getObject(message, offset);
    }

    @Override
    public void writeTo(T message, Writer writer) {
        if (writer.fieldOrder() == Writer.FieldOrder.DESCENDING) {
            this.writeFieldsInDescendingOrder(message, writer);
        } else {
            this.writeFieldsInAscendingOrder(message, writer);
        }
    }

    private void writeFieldsInAscendingOrder(T message, Writer writer) {
        FieldSet<?> extensions = this.hasExtensions ? this.extensionSchema.getExtensions(message) : null;
        Iterator<Map.Entry<?, Object>> extensionIterator = extensions == null ? null : extensions.iterator();
        Map.Entry<?, Object> nextExtension = extensionIterator != null && extensionIterator.hasNext() ? extensionIterator.next() : null;
        block71: for (long pos = this.address; pos < this.limit; pos += 16L) {
            int typeAndOffset = MessageSchema.typeAndOffsetAt(pos);
            int number = MessageSchema.numberAt(pos);
            while (nextExtension != null && this.extensionSchema.extensionNumber(nextExtension) <= number) {
                this.extensionSchema.serializeExtension(writer, nextExtension);
                nextExtension = extensionIterator.hasNext() ? extensionIterator.next() : null;
            }
            switch (MessageSchema.type(typeAndOffset)) {
                case 0: {
                    if (!this.isFieldPresent(message, pos)) continue block71;
                    writer.writeDouble(number, MessageSchema.doubleAt(message, MessageSchema.offset(typeAndOffset)));
                    continue block71;
                }
                case 1: {
                    if (!this.isFieldPresent(message, pos)) continue block71;
                    writer.writeFloat(number, MessageSchema.floatAt(message, MessageSchema.offset(typeAndOffset)));
                    continue block71;
                }
                case 2: {
                    if (!this.isFieldPresent(message, pos)) continue block71;
                    writer.writeInt64(number, MessageSchema.longAt(message, MessageSchema.offset(typeAndOffset)));
                    continue block71;
                }
                case 3: {
                    if (!this.isFieldPresent(message, pos)) continue block71;
                    writer.writeUInt64(number, MessageSchema.longAt(message, MessageSchema.offset(typeAndOffset)));
                    continue block71;
                }
                case 4: {
                    if (!this.isFieldPresent(message, pos)) continue block71;
                    writer.writeInt32(number, MessageSchema.intAt(message, MessageSchema.offset(typeAndOffset)));
                    continue block71;
                }
                case 5: {
                    if (!this.isFieldPresent(message, pos)) continue block71;
                    writer.writeFixed64(number, MessageSchema.longAt(message, MessageSchema.offset(typeAndOffset)));
                    continue block71;
                }
                case 6: {
                    if (!this.isFieldPresent(message, pos)) continue block71;
                    writer.writeFixed32(number, MessageSchema.intAt(message, MessageSchema.offset(typeAndOffset)));
                    continue block71;
                }
                case 7: {
                    if (!this.isFieldPresent(message, pos)) continue block71;
                    writer.writeBool(number, MessageSchema.booleanAt(message, MessageSchema.offset(typeAndOffset)));
                    continue block71;
                }
                case 8: {
                    if (!this.isFieldPresent(message, pos)) continue block71;
                    this.writeString(number, UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)), writer);
                    continue block71;
                }
                case 9: {
                    if (!this.isFieldPresent(message, pos)) continue block71;
                    Object value = UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset));
                    writer.writeMessage(number, value);
                    continue block71;
                }
                case 10: {
                    if (!this.isFieldPresent(message, pos)) continue block71;
                    writer.writeBytes(number, (ByteString)UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)));
                    continue block71;
                }
                case 11: {
                    if (!this.isFieldPresent(message, pos)) continue block71;
                    writer.writeUInt32(number, MessageSchema.intAt(message, MessageSchema.offset(typeAndOffset)));
                    continue block71;
                }
                case 12: {
                    if (!this.isFieldPresent(message, pos)) continue block71;
                    writer.writeEnum(number, MessageSchema.intAt(message, MessageSchema.offset(typeAndOffset)));
                    continue block71;
                }
                case 13: {
                    if (!this.isFieldPresent(message, pos)) continue block71;
                    writer.writeSFixed32(number, MessageSchema.intAt(message, MessageSchema.offset(typeAndOffset)));
                    continue block71;
                }
                case 14: {
                    if (!this.isFieldPresent(message, pos)) continue block71;
                    writer.writeSFixed64(number, MessageSchema.longAt(message, MessageSchema.offset(typeAndOffset)));
                    continue block71;
                }
                case 15: {
                    if (!this.isFieldPresent(message, pos)) continue block71;
                    writer.writeSInt32(number, MessageSchema.intAt(message, MessageSchema.offset(typeAndOffset)));
                    continue block71;
                }
                case 16: {
                    if (!this.isFieldPresent(message, pos)) continue block71;
                    writer.writeSInt64(number, MessageSchema.longAt(message, MessageSchema.offset(typeAndOffset)));
                    continue block71;
                }
                case 17: {
                    if (!this.isFieldPresent(message, pos)) continue block71;
                    writer.writeGroup(number, UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)));
                    continue block71;
                }
                case 18: {
                    SchemaUtil.writeDoubleList(MessageSchema.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)), writer, false);
                    continue block71;
                }
                case 19: {
                    SchemaUtil.writeFloatList(MessageSchema.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)), writer, false);
                    continue block71;
                }
                case 20: {
                    SchemaUtil.writeInt64List(MessageSchema.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)), writer, false);
                    continue block71;
                }
                case 21: {
                    SchemaUtil.writeUInt64List(MessageSchema.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)), writer, false);
                    continue block71;
                }
                case 22: {
                    SchemaUtil.writeInt32List(MessageSchema.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)), writer, false);
                    continue block71;
                }
                case 23: {
                    SchemaUtil.writeFixed64List(MessageSchema.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)), writer, false);
                    continue block71;
                }
                case 24: {
                    SchemaUtil.writeFixed32List(MessageSchema.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)), writer, false);
                    continue block71;
                }
                case 25: {
                    SchemaUtil.writeBoolList(MessageSchema.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)), writer, false);
                    continue block71;
                }
                case 26: {
                    SchemaUtil.writeStringList(MessageSchema.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)), writer);
                    continue block71;
                }
                case 27: {
                    SchemaUtil.writeMessageList(MessageSchema.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)), writer);
                    continue block71;
                }
                case 28: {
                    SchemaUtil.writeBytesList(MessageSchema.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)), writer);
                    continue block71;
                }
                case 29: {
                    SchemaUtil.writeUInt32List(MessageSchema.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)), writer, false);
                    continue block71;
                }
                case 30: {
                    SchemaUtil.writeEnumList(MessageSchema.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)), writer, false);
                    continue block71;
                }
                case 31: {
                    SchemaUtil.writeSFixed32List(MessageSchema.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)), writer, false);
                    continue block71;
                }
                case 32: {
                    SchemaUtil.writeSFixed64List(MessageSchema.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)), writer, false);
                    continue block71;
                }
                case 33: {
                    SchemaUtil.writeSInt32List(MessageSchema.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)), writer, false);
                    continue block71;
                }
                case 34: {
                    SchemaUtil.writeSInt64List(MessageSchema.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)), writer, false);
                    continue block71;
                }
                case 35: {
                    SchemaUtil.writeDoubleList(MessageSchema.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)), writer, true);
                    continue block71;
                }
                case 36: {
                    SchemaUtil.writeFloatList(MessageSchema.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)), writer, true);
                    continue block71;
                }
                case 37: {
                    SchemaUtil.writeInt64List(MessageSchema.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)), writer, true);
                    continue block71;
                }
                case 38: {
                    SchemaUtil.writeUInt64List(MessageSchema.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)), writer, true);
                    continue block71;
                }
                case 39: {
                    SchemaUtil.writeInt32List(MessageSchema.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)), writer, true);
                    continue block71;
                }
                case 40: {
                    SchemaUtil.writeFixed64List(MessageSchema.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)), writer, true);
                    continue block71;
                }
                case 41: {
                    SchemaUtil.writeFixed32List(MessageSchema.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)), writer, true);
                    continue block71;
                }
                case 42: {
                    SchemaUtil.writeBoolList(MessageSchema.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)), writer, true);
                    continue block71;
                }
                case 43: {
                    SchemaUtil.writeUInt32List(MessageSchema.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)), writer, true);
                    continue block71;
                }
                case 44: {
                    SchemaUtil.writeEnumList(MessageSchema.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)), writer, true);
                    continue block71;
                }
                case 45: {
                    SchemaUtil.writeSFixed32List(MessageSchema.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)), writer, true);
                    continue block71;
                }
                case 46: {
                    SchemaUtil.writeSFixed64List(MessageSchema.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)), writer, true);
                    continue block71;
                }
                case 47: {
                    SchemaUtil.writeSInt32List(MessageSchema.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)), writer, true);
                    continue block71;
                }
                case 48: {
                    SchemaUtil.writeSInt64List(MessageSchema.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)), writer, true);
                    continue block71;
                }
                case 49: {
                    SchemaUtil.writeGroupList(MessageSchema.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)), writer);
                    continue block71;
                }
                case 50: {
                    this.writeMapHelper(writer, number, UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)));
                    continue block71;
                }
                case 51: {
                    if (!this.isOneofPresent(message, number, pos)) continue block71;
                    writer.writeDouble(number, MessageSchema.oneofDoubleAt(message, MessageSchema.offset(typeAndOffset)));
                    continue block71;
                }
                case 52: {
                    if (!this.isOneofPresent(message, number, pos)) continue block71;
                    writer.writeFloat(number, MessageSchema.oneofFloatAt(message, MessageSchema.offset(typeAndOffset)));
                    continue block71;
                }
                case 53: {
                    if (!this.isOneofPresent(message, number, pos)) continue block71;
                    writer.writeInt64(number, MessageSchema.oneofLongAt(message, MessageSchema.offset(typeAndOffset)));
                    continue block71;
                }
                case 54: {
                    if (!this.isOneofPresent(message, number, pos)) continue block71;
                    writer.writeUInt64(number, MessageSchema.oneofLongAt(message, MessageSchema.offset(typeAndOffset)));
                    continue block71;
                }
                case 55: {
                    if (!this.isOneofPresent(message, number, pos)) continue block71;
                    writer.writeInt32(number, MessageSchema.oneofIntAt(message, MessageSchema.offset(typeAndOffset)));
                    continue block71;
                }
                case 56: {
                    if (!this.isOneofPresent(message, number, pos)) continue block71;
                    writer.writeFixed64(number, MessageSchema.oneofLongAt(message, MessageSchema.offset(typeAndOffset)));
                    continue block71;
                }
                case 57: {
                    if (!this.isOneofPresent(message, number, pos)) continue block71;
                    writer.writeFixed32(number, MessageSchema.oneofIntAt(message, MessageSchema.offset(typeAndOffset)));
                    continue block71;
                }
                case 58: {
                    if (!this.isOneofPresent(message, number, pos)) continue block71;
                    writer.writeBool(number, MessageSchema.oneofBooleanAt(message, MessageSchema.offset(typeAndOffset)));
                    continue block71;
                }
                case 59: {
                    if (!this.isOneofPresent(message, number, pos)) continue block71;
                    this.writeString(number, UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)), writer);
                    continue block71;
                }
                case 60: {
                    if (!this.isOneofPresent(message, number, pos)) continue block71;
                    Object value = UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset));
                    writer.writeMessage(number, value);
                    continue block71;
                }
                case 61: {
                    if (!this.isOneofPresent(message, number, pos)) continue block71;
                    writer.writeBytes(number, (ByteString)UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)));
                    continue block71;
                }
                case 62: {
                    if (!this.isOneofPresent(message, number, pos)) continue block71;
                    writer.writeUInt32(number, MessageSchema.oneofIntAt(message, MessageSchema.offset(typeAndOffset)));
                    continue block71;
                }
                case 63: {
                    if (!this.isOneofPresent(message, number, pos)) continue block71;
                    writer.writeEnum(number, MessageSchema.oneofIntAt(message, MessageSchema.offset(typeAndOffset)));
                    continue block71;
                }
                case 64: {
                    if (!this.isOneofPresent(message, number, pos)) continue block71;
                    writer.writeSFixed32(number, MessageSchema.oneofIntAt(message, MessageSchema.offset(typeAndOffset)));
                    continue block71;
                }
                case 65: {
                    if (!this.isOneofPresent(message, number, pos)) continue block71;
                    writer.writeSFixed64(number, MessageSchema.oneofLongAt(message, MessageSchema.offset(typeAndOffset)));
                    continue block71;
                }
                case 66: {
                    if (!this.isOneofPresent(message, number, pos)) continue block71;
                    writer.writeSInt32(number, MessageSchema.oneofIntAt(message, MessageSchema.offset(typeAndOffset)));
                    continue block71;
                }
                case 67: {
                    if (!this.isOneofPresent(message, number, pos)) continue block71;
                    writer.writeSInt64(number, MessageSchema.oneofLongAt(message, MessageSchema.offset(typeAndOffset)));
                    continue block71;
                }
                case 68: {
                    if (!this.isOneofPresent(message, number, pos)) continue block71;
                    writer.writeGroup(number, UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)));
                    continue block71;
                }
            }
        }
        while (nextExtension != null) {
            this.extensionSchema.serializeExtension(writer, nextExtension);
            nextExtension = extensionIterator.hasNext() ? extensionIterator.next() : null;
        }
        this.writeUnknownInMessageTo(this.unknownFieldSchema, message, writer);
    }

    private void writeFieldsInDescendingOrder(T message, Writer writer) {
        this.writeUnknownInMessageTo(this.unknownFieldSchema, message, writer);
        FieldSet<?> extensions = this.hasExtensions ? this.extensionSchema.getExtensions(message) : null;
        Iterator<Map.Entry<?, Object>> extensionIterator = extensions == null ? null : extensions.descendingIterator();
        Map.Entry<?, Object> nextExtension = extensionIterator != null && extensionIterator.hasNext() ? extensionIterator.next() : null;
        block71: for (long pos = this.limit - 16L; pos >= this.address; pos -= 16L) {
            int typeAndOffset = MessageSchema.typeAndOffsetAt(pos);
            int number = MessageSchema.numberAt(pos);
            while (nextExtension != null && this.extensionSchema.extensionNumber(nextExtension) > number) {
                this.extensionSchema.serializeExtension(writer, nextExtension);
                nextExtension = extensionIterator.hasNext() ? extensionIterator.next() : null;
            }
            switch (MessageSchema.type(typeAndOffset)) {
                case 0: {
                    if (!this.isFieldPresent(message, pos)) continue block71;
                    writer.writeDouble(number, MessageSchema.doubleAt(message, MessageSchema.offset(typeAndOffset)));
                    continue block71;
                }
                case 1: {
                    if (!this.isFieldPresent(message, pos)) continue block71;
                    writer.writeFloat(number, MessageSchema.floatAt(message, MessageSchema.offset(typeAndOffset)));
                    continue block71;
                }
                case 2: {
                    if (!this.isFieldPresent(message, pos)) continue block71;
                    writer.writeInt64(number, MessageSchema.longAt(message, MessageSchema.offset(typeAndOffset)));
                    continue block71;
                }
                case 3: {
                    if (!this.isFieldPresent(message, pos)) continue block71;
                    writer.writeUInt64(number, MessageSchema.longAt(message, MessageSchema.offset(typeAndOffset)));
                    continue block71;
                }
                case 4: {
                    if (!this.isFieldPresent(message, pos)) continue block71;
                    writer.writeInt32(number, MessageSchema.intAt(message, MessageSchema.offset(typeAndOffset)));
                    continue block71;
                }
                case 5: {
                    if (!this.isFieldPresent(message, pos)) continue block71;
                    writer.writeFixed64(number, MessageSchema.longAt(message, MessageSchema.offset(typeAndOffset)));
                    continue block71;
                }
                case 6: {
                    if (!this.isFieldPresent(message, pos)) continue block71;
                    writer.writeFixed32(number, MessageSchema.intAt(message, MessageSchema.offset(typeAndOffset)));
                    continue block71;
                }
                case 7: {
                    if (!this.isFieldPresent(message, pos)) continue block71;
                    writer.writeBool(number, MessageSchema.booleanAt(message, MessageSchema.offset(typeAndOffset)));
                    continue block71;
                }
                case 8: {
                    if (!this.isFieldPresent(message, pos)) continue block71;
                    this.writeString(number, UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)), writer);
                    continue block71;
                }
                case 9: {
                    if (!this.isFieldPresent(message, pos)) continue block71;
                    Object value = UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset));
                    writer.writeMessage(number, value);
                    continue block71;
                }
                case 10: {
                    if (!this.isFieldPresent(message, pos)) continue block71;
                    writer.writeBytes(number, (ByteString)UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)));
                    continue block71;
                }
                case 11: {
                    if (!this.isFieldPresent(message, pos)) continue block71;
                    writer.writeUInt32(number, MessageSchema.intAt(message, MessageSchema.offset(typeAndOffset)));
                    continue block71;
                }
                case 12: {
                    if (!this.isFieldPresent(message, pos)) continue block71;
                    writer.writeEnum(number, MessageSchema.intAt(message, MessageSchema.offset(typeAndOffset)));
                    continue block71;
                }
                case 13: {
                    if (!this.isFieldPresent(message, pos)) continue block71;
                    writer.writeSFixed32(number, MessageSchema.intAt(message, MessageSchema.offset(typeAndOffset)));
                    continue block71;
                }
                case 14: {
                    if (!this.isFieldPresent(message, pos)) continue block71;
                    writer.writeSFixed64(number, MessageSchema.longAt(message, MessageSchema.offset(typeAndOffset)));
                    continue block71;
                }
                case 15: {
                    if (!this.isFieldPresent(message, pos)) continue block71;
                    writer.writeSInt32(number, MessageSchema.intAt(message, MessageSchema.offset(typeAndOffset)));
                    continue block71;
                }
                case 16: {
                    if (!this.isFieldPresent(message, pos)) continue block71;
                    writer.writeSInt64(number, MessageSchema.longAt(message, MessageSchema.offset(typeAndOffset)));
                    continue block71;
                }
                case 17: {
                    if (!this.isFieldPresent(message, pos)) continue block71;
                    writer.writeGroup(number, UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)));
                    continue block71;
                }
                case 18: {
                    SchemaUtil.writeDoubleList(MessageSchema.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)), writer, false);
                    continue block71;
                }
                case 19: {
                    SchemaUtil.writeFloatList(MessageSchema.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)), writer, false);
                    continue block71;
                }
                case 20: {
                    SchemaUtil.writeInt64List(MessageSchema.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)), writer, false);
                    continue block71;
                }
                case 21: {
                    SchemaUtil.writeUInt64List(MessageSchema.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)), writer, false);
                    continue block71;
                }
                case 22: {
                    SchemaUtil.writeInt32List(MessageSchema.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)), writer, false);
                    continue block71;
                }
                case 23: {
                    SchemaUtil.writeFixed64List(MessageSchema.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)), writer, false);
                    continue block71;
                }
                case 24: {
                    SchemaUtil.writeFixed32List(MessageSchema.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)), writer, false);
                    continue block71;
                }
                case 25: {
                    SchemaUtil.writeBoolList(MessageSchema.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)), writer, false);
                    continue block71;
                }
                case 26: {
                    SchemaUtil.writeStringList(MessageSchema.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)), writer);
                    continue block71;
                }
                case 27: {
                    SchemaUtil.writeMessageList(MessageSchema.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)), writer);
                    continue block71;
                }
                case 28: {
                    SchemaUtil.writeBytesList(MessageSchema.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)), writer);
                    continue block71;
                }
                case 29: {
                    SchemaUtil.writeUInt32List(MessageSchema.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)), writer, false);
                    continue block71;
                }
                case 30: {
                    SchemaUtil.writeEnumList(MessageSchema.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)), writer, false);
                    continue block71;
                }
                case 31: {
                    SchemaUtil.writeSFixed32List(MessageSchema.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)), writer, false);
                    continue block71;
                }
                case 32: {
                    SchemaUtil.writeSFixed64List(MessageSchema.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)), writer, false);
                    continue block71;
                }
                case 33: {
                    SchemaUtil.writeSInt32List(MessageSchema.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)), writer, false);
                    continue block71;
                }
                case 34: {
                    SchemaUtil.writeSInt64List(MessageSchema.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)), writer, false);
                    continue block71;
                }
                case 35: {
                    SchemaUtil.writeDoubleList(MessageSchema.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)), writer, true);
                    continue block71;
                }
                case 36: {
                    SchemaUtil.writeFloatList(MessageSchema.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)), writer, true);
                    continue block71;
                }
                case 37: {
                    SchemaUtil.writeInt64List(MessageSchema.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)), writer, true);
                    continue block71;
                }
                case 38: {
                    SchemaUtil.writeUInt64List(MessageSchema.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)), writer, true);
                    continue block71;
                }
                case 39: {
                    SchemaUtil.writeInt32List(MessageSchema.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)), writer, true);
                    continue block71;
                }
                case 40: {
                    SchemaUtil.writeFixed64List(MessageSchema.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)), writer, true);
                    continue block71;
                }
                case 41: {
                    SchemaUtil.writeFixed32List(MessageSchema.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)), writer, true);
                    continue block71;
                }
                case 42: {
                    SchemaUtil.writeBoolList(MessageSchema.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)), writer, true);
                    continue block71;
                }
                case 43: {
                    SchemaUtil.writeUInt32List(MessageSchema.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)), writer, true);
                    continue block71;
                }
                case 44: {
                    SchemaUtil.writeEnumList(MessageSchema.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)), writer, true);
                    continue block71;
                }
                case 45: {
                    SchemaUtil.writeSFixed32List(MessageSchema.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)), writer, true);
                    continue block71;
                }
                case 46: {
                    SchemaUtil.writeSFixed64List(MessageSchema.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)), writer, true);
                    continue block71;
                }
                case 47: {
                    SchemaUtil.writeSInt32List(MessageSchema.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)), writer, true);
                    continue block71;
                }
                case 48: {
                    SchemaUtil.writeSInt64List(MessageSchema.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)), writer, true);
                    continue block71;
                }
                case 49: {
                    SchemaUtil.writeGroupList(MessageSchema.numberAt(pos), (List)UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)), writer);
                    continue block71;
                }
                case 50: {
                    this.writeMapHelper(writer, number, UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)));
                    continue block71;
                }
                case 51: {
                    if (!this.isOneofPresent(message, number, pos)) continue block71;
                    writer.writeDouble(number, MessageSchema.oneofDoubleAt(message, MessageSchema.offset(typeAndOffset)));
                    continue block71;
                }
                case 52: {
                    if (!this.isOneofPresent(message, number, pos)) continue block71;
                    writer.writeFloat(number, MessageSchema.oneofFloatAt(message, MessageSchema.offset(typeAndOffset)));
                    continue block71;
                }
                case 53: {
                    if (!this.isOneofPresent(message, number, pos)) continue block71;
                    writer.writeInt64(number, MessageSchema.oneofLongAt(message, MessageSchema.offset(typeAndOffset)));
                    continue block71;
                }
                case 54: {
                    if (!this.isOneofPresent(message, number, pos)) continue block71;
                    writer.writeUInt64(number, MessageSchema.oneofLongAt(message, MessageSchema.offset(typeAndOffset)));
                    continue block71;
                }
                case 55: {
                    if (!this.isOneofPresent(message, number, pos)) continue block71;
                    writer.writeInt32(number, MessageSchema.oneofIntAt(message, MessageSchema.offset(typeAndOffset)));
                    continue block71;
                }
                case 56: {
                    if (!this.isOneofPresent(message, number, pos)) continue block71;
                    writer.writeFixed64(number, MessageSchema.oneofLongAt(message, MessageSchema.offset(typeAndOffset)));
                    continue block71;
                }
                case 57: {
                    if (!this.isOneofPresent(message, number, pos)) continue block71;
                    writer.writeFixed32(number, MessageSchema.oneofIntAt(message, MessageSchema.offset(typeAndOffset)));
                    continue block71;
                }
                case 58: {
                    if (!this.isOneofPresent(message, number, pos)) continue block71;
                    writer.writeBool(number, MessageSchema.oneofBooleanAt(message, MessageSchema.offset(typeAndOffset)));
                    continue block71;
                }
                case 59: {
                    if (!this.isOneofPresent(message, number, pos)) continue block71;
                    this.writeString(number, UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)), writer);
                    continue block71;
                }
                case 60: {
                    if (!this.isOneofPresent(message, number, pos)) continue block71;
                    Object value = UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset));
                    writer.writeMessage(number, value);
                    continue block71;
                }
                case 61: {
                    if (!this.isOneofPresent(message, number, pos)) continue block71;
                    writer.writeBytes(number, (ByteString)UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)));
                    continue block71;
                }
                case 62: {
                    if (!this.isOneofPresent(message, number, pos)) continue block71;
                    writer.writeUInt32(number, MessageSchema.oneofIntAt(message, MessageSchema.offset(typeAndOffset)));
                    continue block71;
                }
                case 63: {
                    if (!this.isOneofPresent(message, number, pos)) continue block71;
                    writer.writeEnum(number, MessageSchema.oneofIntAt(message, MessageSchema.offset(typeAndOffset)));
                    continue block71;
                }
                case 64: {
                    if (!this.isOneofPresent(message, number, pos)) continue block71;
                    writer.writeSFixed32(number, MessageSchema.oneofIntAt(message, MessageSchema.offset(typeAndOffset)));
                    continue block71;
                }
                case 65: {
                    if (!this.isOneofPresent(message, number, pos)) continue block71;
                    writer.writeSFixed64(number, MessageSchema.oneofLongAt(message, MessageSchema.offset(typeAndOffset)));
                    continue block71;
                }
                case 66: {
                    if (!this.isOneofPresent(message, number, pos)) continue block71;
                    writer.writeSInt32(number, MessageSchema.oneofIntAt(message, MessageSchema.offset(typeAndOffset)));
                    continue block71;
                }
                case 67: {
                    if (!this.isOneofPresent(message, number, pos)) continue block71;
                    writer.writeSInt64(number, MessageSchema.oneofLongAt(message, MessageSchema.offset(typeAndOffset)));
                    continue block71;
                }
                case 68: {
                    if (!this.isOneofPresent(message, number, pos)) continue block71;
                    writer.writeGroup(number, UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)));
                    continue block71;
                }
            }
        }
        while (nextExtension != null) {
            this.extensionSchema.serializeExtension(writer, nextExtension);
            nextExtension = extensionIterator.hasNext() ? extensionIterator.next() : null;
        }
    }

    private <K, V> void writeMapHelper(Writer writer, int number, Object mapField) {
        if (mapField != null) {
            writer.writeMap(number, this.mapFieldSchema.forMapMetadata(this.mapFieldDefaultEntryMap.get(number)), this.mapFieldSchema.forMapData(mapField));
        }
    }

    private <UT, UB> void writeUnknownInMessageTo(UnknownFieldSchema<UT, UB> schema, T message, Writer writer) {
        schema.writeTo(schema.getFromMessage(message), writer);
    }

    @Override
    public void mergeFrom(T message, Reader reader, ExtensionRegistryLite extensionRegistry) throws IOException {
        if (extensionRegistry == null) {
            throw new NullPointerException();
        }
        this.mergeFromHelper(this.unknownFieldSchema, this.extensionSchema, message, reader, extensionRegistry);
    }

    private <UT, UB, ET extends FieldSet.FieldDescriptorLite<ET>> void mergeFromHelper(UnknownFieldSchema<UT, UB> unknownFieldSchema, ExtensionSchema<ET> extensionSchema, T message, Reader reader, ExtensionRegistryLite extensionRegistry) throws IOException {
        Object unknownFields = null;
        FieldSet<ET> extensions = null;
        try {
            while (true) {
                int number;
                long pos;
                if ((pos = this.positionStrategy.positionForFieldNumber(number = reader.getFieldNumber())) < 0L) {
                    Object extension;
                    if (number == Integer.MAX_VALUE) {
                        return;
                    }
                    Object object = extension = !this.hasExtensions ? null : extensionSchema.findExtensionByNumber(extensionRegistry, this.defaultInstance, number);
                    if (extension != null) {
                        if (extensions == null) {
                            extensions = extensionSchema.getMutableExtensions(message);
                        }
                        unknownFields = extensionSchema.parseExtension(reader, extension, extensionRegistry, extensions, unknownFields, unknownFieldSchema);
                        continue;
                    }
                    if (unknownFieldSchema.shouldDiscardUnknownFields(reader)) {
                        if (reader.skipField()) {
                            continue;
                        }
                    } else {
                        if (unknownFields == null) {
                            unknownFields = unknownFieldSchema.getBuilderFromMessage(message);
                        }
                        if (unknownFieldSchema.mergeOneFieldFrom(unknownFields, reader)) continue;
                    }
                    return;
                }
                int typeAndOffset = MessageSchema.typeAndOffsetAt(pos);
                try {
                    switch (MessageSchema.type(typeAndOffset)) {
                        case 0: {
                            UnsafeUtil.putDouble(message, MessageSchema.offset(typeAndOffset), reader.readDouble());
                            this.setFieldPresent(message, pos);
                            break;
                        }
                        case 1: {
                            UnsafeUtil.putFloat(message, MessageSchema.offset(typeAndOffset), reader.readFloat());
                            this.setFieldPresent(message, pos);
                            break;
                        }
                        case 2: {
                            UnsafeUtil.putLong(message, MessageSchema.offset(typeAndOffset), reader.readInt64());
                            this.setFieldPresent(message, pos);
                            break;
                        }
                        case 3: {
                            UnsafeUtil.putLong(message, MessageSchema.offset(typeAndOffset), reader.readUInt64());
                            this.setFieldPresent(message, pos);
                            break;
                        }
                        case 4: {
                            UnsafeUtil.putInt(message, MessageSchema.offset(typeAndOffset), reader.readInt32());
                            this.setFieldPresent(message, pos);
                            break;
                        }
                        case 5: {
                            UnsafeUtil.putLong(message, MessageSchema.offset(typeAndOffset), reader.readFixed64());
                            this.setFieldPresent(message, pos);
                            break;
                        }
                        case 6: {
                            UnsafeUtil.putInt(message, MessageSchema.offset(typeAndOffset), reader.readFixed32());
                            this.setFieldPresent(message, pos);
                            break;
                        }
                        case 7: {
                            UnsafeUtil.putBoolean(message, MessageSchema.offset(typeAndOffset), reader.readBool());
                            this.setFieldPresent(message, pos);
                            break;
                        }
                        case 8: {
                            this.readString(message, typeAndOffset, reader);
                            this.setFieldPresent(message, pos);
                            break;
                        }
                        case 9: {
                            if (this.isFieldPresent(message, pos)) {
                                Object mergedResult = Internal.mergeMessage(UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)), reader.readMessage(this.messageFieldClassMap.get(number), extensionRegistry));
                                UnsafeUtil.putObject(message, MessageSchema.offset(typeAndOffset), mergedResult);
                                break;
                            }
                            UnsafeUtil.putObject(message, MessageSchema.offset(typeAndOffset), reader.readMessage(this.messageFieldClassMap.get(number), extensionRegistry));
                            this.setFieldPresent(message, pos);
                            break;
                        }
                        case 10: {
                            UnsafeUtil.putObject(message, MessageSchema.offset(typeAndOffset), (Object)reader.readBytes());
                            this.setFieldPresent(message, pos);
                            break;
                        }
                        case 11: {
                            UnsafeUtil.putInt(message, MessageSchema.offset(typeAndOffset), reader.readUInt32());
                            this.setFieldPresent(message, pos);
                            break;
                        }
                        case 12: {
                            int enumValue = reader.readEnum();
                            Internal.EnumLiteMap<?> enumMap = this.enumFieldMap.get(number);
                            if (enumMap == null || enumMap.findValueByNumber(enumValue) != null) {
                                UnsafeUtil.putInt(message, MessageSchema.offset(typeAndOffset), enumValue);
                                this.setFieldPresent(message, pos);
                                break;
                            }
                            unknownFields = SchemaUtil.storeUnknownEnum(number, enumValue, unknownFields, unknownFieldSchema);
                            break;
                        }
                        case 13: {
                            UnsafeUtil.putInt(message, MessageSchema.offset(typeAndOffset), reader.readSFixed32());
                            this.setFieldPresent(message, pos);
                            break;
                        }
                        case 14: {
                            UnsafeUtil.putLong(message, MessageSchema.offset(typeAndOffset), reader.readSFixed64());
                            this.setFieldPresent(message, pos);
                            break;
                        }
                        case 15: {
                            UnsafeUtil.putInt(message, MessageSchema.offset(typeAndOffset), reader.readSInt32());
                            this.setFieldPresent(message, pos);
                            break;
                        }
                        case 16: {
                            UnsafeUtil.putLong(message, MessageSchema.offset(typeAndOffset), reader.readSInt64());
                            this.setFieldPresent(message, pos);
                            break;
                        }
                        case 17: {
                            if (this.isFieldPresent(message, pos)) {
                                Object mergedResult = Internal.mergeMessage(UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)), reader.readGroup(this.messageFieldClassMap.get(number), extensionRegistry));
                                UnsafeUtil.putObject(message, MessageSchema.offset(typeAndOffset), mergedResult);
                                break;
                            }
                            UnsafeUtil.putObject(message, MessageSchema.offset(typeAndOffset), reader.readGroup(this.messageFieldClassMap.get(number), extensionRegistry));
                            this.setFieldPresent(message, pos);
                            break;
                        }
                        case 18: {
                            reader.readDoubleList(this.listFieldSchema.mutableListAt(message, MessageSchema.offset(typeAndOffset)));
                            break;
                        }
                        case 19: {
                            reader.readFloatList(this.listFieldSchema.mutableListAt(message, MessageSchema.offset(typeAndOffset)));
                            break;
                        }
                        case 20: {
                            reader.readInt64List(this.listFieldSchema.mutableListAt(message, MessageSchema.offset(typeAndOffset)));
                            break;
                        }
                        case 21: {
                            reader.readUInt64List(this.listFieldSchema.mutableListAt(message, MessageSchema.offset(typeAndOffset)));
                            break;
                        }
                        case 22: {
                            reader.readInt32List(this.listFieldSchema.mutableListAt(message, MessageSchema.offset(typeAndOffset)));
                            break;
                        }
                        case 23: {
                            reader.readFixed64List(this.listFieldSchema.mutableListAt(message, MessageSchema.offset(typeAndOffset)));
                            break;
                        }
                        case 24: {
                            reader.readFixed32List(this.listFieldSchema.mutableListAt(message, MessageSchema.offset(typeAndOffset)));
                            break;
                        }
                        case 25: {
                            reader.readBoolList(this.listFieldSchema.mutableListAt(message, MessageSchema.offset(typeAndOffset)));
                            break;
                        }
                        case 26: {
                            this.readStringList(message, typeAndOffset, reader);
                            break;
                        }
                        case 27: {
                            this.readMessageList(message, typeAndOffset, reader, this.messageFieldClassMap.get(number), extensionRegistry);
                            break;
                        }
                        case 28: {
                            reader.readBytesList(this.listFieldSchema.mutableListAt(message, MessageSchema.offset(typeAndOffset)));
                            break;
                        }
                        case 29: {
                            reader.readUInt32List(this.listFieldSchema.mutableListAt(message, MessageSchema.offset(typeAndOffset)));
                            break;
                        }
                        case 30: {
                            List<Integer> enumList = this.listFieldSchema.mutableListAt(message, MessageSchema.offset(typeAndOffset));
                            reader.readEnumList(enumList);
                            unknownFields = SchemaUtil.filterUnknownEnumList(number, enumList, this.enumFieldMap.get(number), unknownFields, unknownFieldSchema);
                            break;
                        }
                        case 31: {
                            reader.readSFixed32List(this.listFieldSchema.mutableListAt(message, MessageSchema.offset(typeAndOffset)));
                            break;
                        }
                        case 32: {
                            reader.readSFixed64List(this.listFieldSchema.mutableListAt(message, MessageSchema.offset(typeAndOffset)));
                            break;
                        }
                        case 33: {
                            reader.readSInt32List(this.listFieldSchema.mutableListAt(message, MessageSchema.offset(typeAndOffset)));
                            break;
                        }
                        case 34: {
                            reader.readSInt64List(this.listFieldSchema.mutableListAt(message, MessageSchema.offset(typeAndOffset)));
                            break;
                        }
                        case 35: {
                            reader.readDoubleList(this.listFieldSchema.mutableListAt(message, MessageSchema.offset(typeAndOffset)));
                            break;
                        }
                        case 36: {
                            reader.readFloatList(this.listFieldSchema.mutableListAt(message, MessageSchema.offset(typeAndOffset)));
                            break;
                        }
                        case 37: {
                            reader.readInt64List(this.listFieldSchema.mutableListAt(message, MessageSchema.offset(typeAndOffset)));
                            break;
                        }
                        case 38: {
                            reader.readUInt64List(this.listFieldSchema.mutableListAt(message, MessageSchema.offset(typeAndOffset)));
                            break;
                        }
                        case 39: {
                            reader.readInt32List(this.listFieldSchema.mutableListAt(message, MessageSchema.offset(typeAndOffset)));
                            break;
                        }
                        case 40: {
                            reader.readFixed64List(this.listFieldSchema.mutableListAt(message, MessageSchema.offset(typeAndOffset)));
                            break;
                        }
                        case 41: {
                            reader.readFixed32List(this.listFieldSchema.mutableListAt(message, MessageSchema.offset(typeAndOffset)));
                            break;
                        }
                        case 42: {
                            reader.readBoolList(this.listFieldSchema.mutableListAt(message, MessageSchema.offset(typeAndOffset)));
                            break;
                        }
                        case 43: {
                            reader.readUInt32List(this.listFieldSchema.mutableListAt(message, MessageSchema.offset(typeAndOffset)));
                            break;
                        }
                        case 44: {
                            List<Integer> enumList = this.listFieldSchema.mutableListAt(message, MessageSchema.offset(typeAndOffset));
                            reader.readEnumList(enumList);
                            unknownFields = SchemaUtil.filterUnknownEnumList(number, enumList, this.enumFieldMap.get(number), unknownFields, unknownFieldSchema);
                            break;
                        }
                        case 45: {
                            reader.readSFixed32List(this.listFieldSchema.mutableListAt(message, MessageSchema.offset(typeAndOffset)));
                            break;
                        }
                        case 46: {
                            reader.readSFixed64List(this.listFieldSchema.mutableListAt(message, MessageSchema.offset(typeAndOffset)));
                            break;
                        }
                        case 47: {
                            reader.readSInt32List(this.listFieldSchema.mutableListAt(message, MessageSchema.offset(typeAndOffset)));
                            break;
                        }
                        case 48: {
                            reader.readSInt64List(this.listFieldSchema.mutableListAt(message, MessageSchema.offset(typeAndOffset)));
                            break;
                        }
                        case 49: {
                            this.readGroupList(message, MessageSchema.offset(typeAndOffset), reader, this.messageFieldClassMap.get(number), extensionRegistry);
                            break;
                        }
                        case 50: {
                            this.mergeMap(message, pos, this.mapFieldDefaultEntryMap.get(number), extensionRegistry, reader);
                            break;
                        }
                        case 51: {
                            UnsafeUtil.putObject(message, MessageSchema.offset(typeAndOffset), (Object)reader.readDouble());
                            this.setOneofPresent(message, number, pos);
                            break;
                        }
                        case 52: {
                            UnsafeUtil.putObject(message, MessageSchema.offset(typeAndOffset), (Object)Float.valueOf(reader.readFloat()));
                            this.setOneofPresent(message, number, pos);
                            break;
                        }
                        case 53: {
                            UnsafeUtil.putObject(message, MessageSchema.offset(typeAndOffset), (Object)reader.readInt64());
                            this.setOneofPresent(message, number, pos);
                            break;
                        }
                        case 54: {
                            UnsafeUtil.putObject(message, MessageSchema.offset(typeAndOffset), (Object)reader.readUInt64());
                            this.setOneofPresent(message, number, pos);
                            break;
                        }
                        case 55: {
                            UnsafeUtil.putObject(message, MessageSchema.offset(typeAndOffset), (Object)reader.readInt32());
                            this.setOneofPresent(message, number, pos);
                            break;
                        }
                        case 56: {
                            UnsafeUtil.putObject(message, MessageSchema.offset(typeAndOffset), (Object)reader.readFixed64());
                            this.setOneofPresent(message, number, pos);
                            break;
                        }
                        case 57: {
                            UnsafeUtil.putObject(message, MessageSchema.offset(typeAndOffset), (Object)reader.readFixed32());
                            this.setOneofPresent(message, number, pos);
                            break;
                        }
                        case 58: {
                            UnsafeUtil.putObject(message, MessageSchema.offset(typeAndOffset), (Object)reader.readBool());
                            this.setOneofPresent(message, number, pos);
                            break;
                        }
                        case 59: {
                            this.readString(message, typeAndOffset, reader);
                            this.setOneofPresent(message, number, pos);
                            break;
                        }
                        case 60: {
                            if (this.isOneofPresent(message, number, pos)) {
                                Object mergedResult = Internal.mergeMessage(UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)), reader.readMessage(this.messageFieldClassMap.get(number), extensionRegistry));
                                UnsafeUtil.putObject(message, MessageSchema.offset(typeAndOffset), mergedResult);
                            } else {
                                UnsafeUtil.putObject(message, MessageSchema.offset(typeAndOffset), reader.readMessage(this.messageFieldClassMap.get(number), extensionRegistry));
                                this.setFieldPresent(message, pos);
                            }
                            this.setOneofPresent(message, number, pos);
                            break;
                        }
                        case 61: {
                            UnsafeUtil.putObject(message, MessageSchema.offset(typeAndOffset), (Object)reader.readBytes());
                            this.setOneofPresent(message, number, pos);
                            break;
                        }
                        case 62: {
                            UnsafeUtil.putObject(message, MessageSchema.offset(typeAndOffset), (Object)reader.readUInt32());
                            this.setOneofPresent(message, number, pos);
                            break;
                        }
                        case 63: {
                            UnsafeUtil.putObject(message, MessageSchema.offset(typeAndOffset), (Object)reader.readEnum());
                            this.setOneofPresent(message, number, pos);
                            break;
                        }
                        case 64: {
                            UnsafeUtil.putObject(message, MessageSchema.offset(typeAndOffset), (Object)reader.readSFixed32());
                            this.setOneofPresent(message, number, pos);
                            break;
                        }
                        case 65: {
                            UnsafeUtil.putObject(message, MessageSchema.offset(typeAndOffset), (Object)reader.readSFixed64());
                            this.setOneofPresent(message, number, pos);
                            break;
                        }
                        case 66: {
                            UnsafeUtil.putObject(message, MessageSchema.offset(typeAndOffset), (Object)reader.readSInt32());
                            this.setOneofPresent(message, number, pos);
                            break;
                        }
                        case 67: {
                            UnsafeUtil.putObject(message, MessageSchema.offset(typeAndOffset), (Object)reader.readSInt64());
                            this.setOneofPresent(message, number, pos);
                            break;
                        }
                        case 68: {
                            UnsafeUtil.putObject(message, MessageSchema.offset(typeAndOffset), reader.readGroup(this.messageFieldClassMap.get(number), extensionRegistry));
                            this.setOneofPresent(message, number, pos);
                            break;
                        }
                        default: {
                            if (unknownFields == null) {
                                unknownFields = unknownFieldSchema.newBuilder();
                            }
                            if (unknownFieldSchema.mergeOneFieldFrom(unknownFields, reader)) break;
                            return;
                        }
                    }
                }
                catch (InvalidProtocolBufferException.InvalidWireTypeException e) {
                    if (unknownFieldSchema.shouldDiscardUnknownFields(reader)) {
                        if (reader.skipField()) continue;
                        return;
                    }
                    if (unknownFields == null) {
                        unknownFields = unknownFieldSchema.getBuilderFromMessage(message);
                    }
                    if (unknownFieldSchema.mergeOneFieldFrom(unknownFields, reader)) continue;
                    return;
                }
            }
        }
        finally {
            if (this.mapFieldPositions != null) {
                for (long pos : this.mapFieldPositions) {
                    unknownFields = this.filterMapUnknownEnumValues(message, pos, unknownFields, unknownFieldSchema);
                }
            }
            if (unknownFields != null) {
                unknownFieldSchema.setBuilderToMessage(message, unknownFields);
            }
        }
    }

    @Override
    public void makeImmutable(T message) {
        if (this.mapFieldPositions != null) {
            for (long pos : this.mapFieldPositions) {
                long offset = MessageSchema.offset(MessageSchema.typeAndOffsetAt(pos));
                Object mapField = UnsafeUtil.getObject(message, offset);
                if (mapField == null) continue;
                UnsafeUtil.putObject(message, offset, this.mapFieldSchema.toImmutable(mapField));
            }
        }
        if (this.repeatedFieldOffsets != null) {
            for (int offset : this.repeatedFieldOffsets) {
                this.listFieldSchema.makeImmutableListAt(message, offset);
            }
        }
        this.unknownFieldSchema.makeImmutable(message);
        if (this.hasExtensions) {
            this.extensionSchema.makeImmutable(message);
        }
    }

    private final <K, V> void mergeMap(Object message, long pos, Object mapDefaultEntry, ExtensionRegistryLite extensionRegistry, Reader reader) throws IOException {
        long offset = MessageSchema.offset(MessageSchema.typeAndOffsetAt(pos));
        Object mapField = UnsafeUtil.getObject(message, offset);
        if (mapField == null) {
            mapField = this.mapFieldSchema.newMapField(mapDefaultEntry);
            UnsafeUtil.putObject(message, offset, mapField);
        } else if (this.mapFieldSchema.isImmutable(mapField)) {
            Object oldMapField = mapField;
            mapField = this.mapFieldSchema.newMapField(mapDefaultEntry);
            this.mapFieldSchema.mergeFrom(mapField, oldMapField);
            UnsafeUtil.putObject(message, offset, mapField);
        }
        reader.readMap(this.mapFieldSchema.forMutableMapData(mapField), this.mapFieldSchema.forMapMetadata(mapDefaultEntry), extensionRegistry);
    }

    private final <UT, UB> UB filterMapUnknownEnumValues(Object message, long pos, UB unknownFields, UnknownFieldSchema<UT, UB> unknownFieldSchema) {
        int fieldNumber = MessageSchema.numberAt(pos);
        long offset = MessageSchema.offset(MessageSchema.typeAndOffsetAt(pos));
        Object mapField = UnsafeUtil.getObject(message, offset);
        if (mapField == null) {
            return unknownFields;
        }
        Internal.EnumLiteMap<?> enumMap = this.enumFieldMap.get(fieldNumber);
        if (enumMap == null) {
            return unknownFields;
        }
        Map<?, ?> mapData = this.mapFieldSchema.forMutableMapData(mapField);
        unknownFields = this.filterUnknownEnumMap(fieldNumber, mapData, enumMap, unknownFields, unknownFieldSchema);
        return unknownFields;
    }

    private final <K, V, UT, UB> UB filterUnknownEnumMap(int number, Map<K, V> mapData, Internal.EnumLiteMap<?> enumMap, UB unknownFields, UnknownFieldSchema<UT, UB> unknownFieldSchema) {
        MapEntryLite.Metadata<?, ?> metadata = this.mapFieldSchema.forMapMetadata(this.mapFieldDefaultEntryMap.get(number));
        Iterator<Map.Entry<K, V>> it = mapData.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<K, V> entry = it.next();
            if (enumMap.findValueByNumber((Integer)entry.getValue()) != null) continue;
            if (unknownFields == null) {
                unknownFields = unknownFieldSchema.newBuilder();
            }
            int entrySize = MapEntryLite.computeSerializedSize(metadata, entry.getKey(), entry.getValue());
            ByteString.CodedBuilder codedBuilder = ByteString.newCodedBuilder(entrySize);
            CodedOutputStream codedOutput = codedBuilder.getCodedOutput();
            try {
                MapEntryLite.writeTo(codedOutput, metadata, entry.getKey(), entry.getValue());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            unknownFieldSchema.addLengthDelimited(unknownFields, number, codedBuilder.build());
            it.remove();
        }
        return unknownFields;
    }

    @Override
    public final boolean isInitialized(T message) {
        if (this.checkInitialized == null || this.checkInitialized.length == 0) {
            return true;
        }
        block6: for (int number : this.checkInitialized) {
            long pos = this.positionStrategy.positionForFieldNumber(number);
            int typeAndOffset = MessageSchema.typeAndOffsetAt(pos);
            if (MessageSchema.isRequired(typeAndOffset) && !this.isFieldPresent(message, pos)) {
                return false;
            }
            switch (MessageSchema.type(typeAndOffset)) {
                case 9: 
                case 17: {
                    if (!this.isFieldPresent(message, pos) || MessageSchema.isInitialized(message, typeAndOffset)) continue block6;
                    return false;
                }
                case 27: 
                case 49: {
                    if (MessageSchema.isListInitialized(message, typeAndOffset)) continue block6;
                    return false;
                }
                case 60: 
                case 68: {
                    if (!this.isOneofPresent(message, number, pos) || MessageSchema.isInitialized(message, typeAndOffset)) continue block6;
                    return false;
                }
                case 50: {
                    if (this.isMapInitialized(message, typeAndOffset, number)) continue block6;
                    return false;
                }
            }
        }
        return !this.hasExtensions || this.extensionSchema.getExtensions(message).isInitialized();
    }

    private static boolean isInitialized(Object message, int typeAndOffset) {
        Object nested = UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset));
        return Protobuf.getInstance().isInitialized(nested);
    }

    private static <N> boolean isListInitialized(Object message, int typeAndOffset) {
        List list = (List)UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset));
        if (list.isEmpty()) {
            return true;
        }
        for (int i = 0; i < list.size(); ++i) {
            Object nested = list.get(i);
            if (Protobuf.getInstance().isInitialized(nested)) continue;
            return false;
        }
        return true;
    }

    private boolean isMapInitialized(T message, int typeAndOffset, int number) {
        Map<?, ?> map = this.mapFieldSchema.forMapData(UnsafeUtil.getObject(message, MessageSchema.offset(typeAndOffset)));
        if (map.isEmpty()) {
            return true;
        }
        Object mapDefaultEntry = this.mapFieldDefaultEntryMap.get(number);
        MapEntryLite.Metadata<?, ?> metadata = this.mapFieldSchema.forMapMetadata(mapDefaultEntry);
        if (metadata.valueType.getJavaType() != WireFormat.JavaType.MESSAGE) {
            return true;
        }
        for (Object nested : map.values()) {
            if (Protobuf.getInstance().isInitialized(nested)) continue;
            return false;
        }
        return true;
    }

    private void writeString(int fieldNumber, Object value, Writer writer) {
        if (value instanceof String) {
            writer.writeString(fieldNumber, (String)value);
        } else {
            writer.writeBytes(fieldNumber, (ByteString)value);
        }
    }

    private void readString(Object message, int typeAndOffset, Reader reader) throws IOException {
        if (MessageSchema.isEnforceUtf8(typeAndOffset)) {
            UnsafeUtil.putObject(message, MessageSchema.offset(typeAndOffset), (Object)reader.readStringRequireUtf8());
        } else if (this.lite) {
            UnsafeUtil.putObject(message, MessageSchema.offset(typeAndOffset), (Object)reader.readString());
        } else {
            UnsafeUtil.putObject(message, MessageSchema.offset(typeAndOffset), (Object)reader.readBytes());
        }
    }

    private void readStringList(Object message, int typeAndOffset, Reader reader) throws IOException {
        if (MessageSchema.isEnforceUtf8(typeAndOffset)) {
            reader.readStringListRequireUtf8(this.listFieldSchema.mutableListAt(message, MessageSchema.offset(typeAndOffset)));
        } else {
            reader.readStringList(this.listFieldSchema.mutableListAt(message, MessageSchema.offset(typeAndOffset)));
        }
    }

    private <E> void readMessageList(Object message, int typeAndOffset, Reader reader, Class<E> targetType, ExtensionRegistryLite extensionRegistry) throws IOException {
        long offset = MessageSchema.offset(typeAndOffset);
        reader.readMessageList(this.listFieldSchema.mutableListAt(message, offset), targetType, extensionRegistry);
    }

    private <E> void readGroupList(Object message, long offset, Reader reader, Class<E> targetType, ExtensionRegistryLite extensionRegistry) throws IOException {
        reader.readGroupList(this.listFieldSchema.mutableListAt(message, offset), targetType, extensionRegistry);
    }

    private static int numberAt(long pos) {
        return UnsafeUtil.getInt(pos);
    }

    private static int typeAndOffsetAt(long pos) {
        return UnsafeUtil.getInt(pos + 4L);
    }

    private static int presenceMaskAndOffsetAt(long pos) {
        return UnsafeUtil.getInt(pos + 8L);
    }

    private long indexToAddress(int index) {
        return this.address + (long)(index << 4);
    }

    private int addressToIndex(long address) {
        return (int)(address - this.address >> 4);
    }

    private static int type(int value) {
        return (value & 0xFF00000) >>> 20;
    }

    private static boolean isRequired(int value) {
        return (value & 0x10000000) != 0;
    }

    private static boolean isEnforceUtf8(int value) {
        return (value & 0x20000000) != 0;
    }

    private static long offset(int value) {
        return value & 0xFFFFF;
    }

    private static <T> double doubleAt(T message, long offset) {
        return UnsafeUtil.getDouble(message, offset);
    }

    private static <T> float floatAt(T message, long offset) {
        return UnsafeUtil.getFloat(message, offset);
    }

    private static <T> int intAt(T message, long offset) {
        return UnsafeUtil.getInt(message, offset);
    }

    private static <T> long longAt(T message, long offset) {
        return UnsafeUtil.getLong(message, offset);
    }

    private static <T> boolean booleanAt(T message, long offset) {
        return UnsafeUtil.getBoolean(message, offset);
    }

    private static <T> double oneofDoubleAt(T message, long offset) {
        return (Double)UnsafeUtil.getObject(message, offset);
    }

    private static <T> float oneofFloatAt(T message, long offset) {
        return ((Float)UnsafeUtil.getObject(message, offset)).floatValue();
    }

    private static <T> int oneofIntAt(T message, long offset) {
        return (Integer)UnsafeUtil.getObject(message, offset);
    }

    private static <T> long oneofLongAt(T message, long offset) {
        return (Long)UnsafeUtil.getObject(message, offset);
    }

    private static <T> boolean oneofBooleanAt(T message, long offset) {
        return (Boolean)UnsafeUtil.getObject(message, offset);
    }

    private boolean arePresentForEquals(T message, T other, long pos) {
        return this.isFieldPresent(message, pos) == this.isFieldPresent(other, pos);
    }

    private boolean isFieldPresent(T message, long pos) {
        if (this.proto3) {
            int typeAndOffset = MessageSchema.typeAndOffsetAt(pos);
            long offset = MessageSchema.offset(typeAndOffset);
            switch (MessageSchema.type(typeAndOffset)) {
                case 0: {
                    return UnsafeUtil.getDouble(message, offset) != 0.0;
                }
                case 1: {
                    return UnsafeUtil.getFloat(message, offset) != 0.0f;
                }
                case 2: {
                    return UnsafeUtil.getLong(message, offset) != 0L;
                }
                case 3: {
                    return UnsafeUtil.getLong(message, offset) != 0L;
                }
                case 4: {
                    return UnsafeUtil.getInt(message, offset) != 0;
                }
                case 5: {
                    return UnsafeUtil.getLong(message, offset) != 0L;
                }
                case 6: {
                    return UnsafeUtil.getInt(message, offset) != 0;
                }
                case 7: {
                    return UnsafeUtil.getBoolean(message, offset);
                }
                case 8: {
                    Object value = UnsafeUtil.getObject(message, offset);
                    if (value instanceof String) {
                        return !((String)value).isEmpty();
                    }
                    if (value instanceof ByteString) {
                        return !ByteString.EMPTY.equals(value);
                    }
                    throw new IllegalArgumentException();
                }
                case 9: {
                    return UnsafeUtil.getObject(message, offset) != null;
                }
                case 10: {
                    return !ByteString.EMPTY.equals(UnsafeUtil.getObject(message, offset));
                }
                case 11: {
                    return UnsafeUtil.getInt(message, offset) != 0;
                }
                case 12: {
                    return UnsafeUtil.getInt(message, offset) != 0;
                }
                case 13: {
                    return UnsafeUtil.getInt(message, offset) != 0;
                }
                case 14: {
                    return UnsafeUtil.getLong(message, offset) != 0L;
                }
                case 15: {
                    return UnsafeUtil.getInt(message, offset) != 0;
                }
                case 16: {
                    return UnsafeUtil.getLong(message, offset) != 0L;
                }
                case 17: {
                    return UnsafeUtil.getObject(message, offset) != null;
                }
            }
            throw new IllegalArgumentException();
        }
        int presenceMaskAndOffset = MessageSchema.presenceMaskAndOffsetAt(pos);
        int presenceMask = 1 << (presenceMaskAndOffset >>> 20);
        return (UnsafeUtil.getInt(message, (long)(presenceMaskAndOffset & 0xFFFFF)) & presenceMask) != 0;
    }

    private void setFieldPresent(T message, long pos) {
        if (this.proto3) {
            return;
        }
        int presenceMaskAndOffset = MessageSchema.presenceMaskAndOffsetAt(pos);
        int presenceMask = 1 << (presenceMaskAndOffset >>> 20);
        long presenceFieldOffset = presenceMaskAndOffset & 0xFFFFF;
        UnsafeUtil.putInt(message, presenceFieldOffset, UnsafeUtil.getInt(message, presenceFieldOffset) | presenceMask);
    }

    private boolean isOneofPresent(T message, int fieldNumber, long pos) {
        int presenceMaskAndOffset = MessageSchema.presenceMaskAndOffsetAt(pos);
        return UnsafeUtil.getInt(message, (long)(presenceMaskAndOffset & 0xFFFFF)) == fieldNumber;
    }

    private boolean isOneofCaseEqual(T message, T other, long pos) {
        int presenceMaskAndOffset = MessageSchema.presenceMaskAndOffsetAt(pos);
        return UnsafeUtil.getInt(message, (long)(presenceMaskAndOffset & 0xFFFFF)) == UnsafeUtil.getInt(other, (long)(presenceMaskAndOffset & 0xFFFFF));
    }

    private void setOneofPresent(T message, int fieldNumber, long pos) {
        int presenceMaskAndOffset = MessageSchema.presenceMaskAndOffsetAt(pos);
        UnsafeUtil.putInt(message, (long)(presenceMaskAndOffset & 0xFFFFF), fieldNumber);
    }

    int getSchemaSize() {
        return (int)(this.limit - this.address);
    }

    private final class LookupPositionStrategy
    extends PositionStrategy {
        private LookupPositionStrategy() {
        }

        @Override
        long positionForFieldNumber(int fieldNumber) {
            int min = 0;
            int max = MessageSchema.this.numFields - 1;
            while (min <= max) {
                int mid = max + min >>> 1;
                long midAddress = MessageSchema.this.indexToAddress(mid);
                int midFieldNumber = MessageSchema.numberAt(midAddress);
                if (fieldNumber == midFieldNumber) {
                    return midAddress;
                }
                if (fieldNumber < midFieldNumber) {
                    max = mid - 1;
                    continue;
                }
                min = mid + 1;
            }
            return -1L;
        }
    }

    private final class TablePositionStrategy
    extends PositionStrategy {
        private TablePositionStrategy() {
        }

        @Override
        long positionForFieldNumber(int fieldNumber) {
            if (fieldNumber < MessageSchema.this.minFieldNumber || fieldNumber > MessageSchema.this.maxFieldNumber) {
                return -1L;
            }
            return MessageSchema.this.indexToAddress(fieldNumber - MessageSchema.this.minFieldNumber);
        }
    }

    private static abstract class PositionStrategy {
        private PositionStrategy() {
        }

        abstract long positionForFieldNumber(int var1);
    }
}

