/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.joda.time.base;

import com.google.appengine.repackaged.org.joda.time.DateTime;
import com.google.appengine.repackaged.org.joda.time.DateTimeUtils;
import com.google.appengine.repackaged.org.joda.time.Duration;
import com.google.appengine.repackaged.org.joda.time.Interval;
import com.google.appengine.repackaged.org.joda.time.MutableInterval;
import com.google.appengine.repackaged.org.joda.time.Period;
import com.google.appengine.repackaged.org.joda.time.PeriodType;
import com.google.appengine.repackaged.org.joda.time.ReadableInstant;
import com.google.appengine.repackaged.org.joda.time.ReadableInterval;
import com.google.appengine.repackaged.org.joda.time.field.FieldUtils;
import com.google.appengine.repackaged.org.joda.time.format.DateTimeFormatter;
import com.google.appengine.repackaged.org.joda.time.format.ISODateTimeFormat;

public abstract class AbstractInterval
implements ReadableInterval {
    protected AbstractInterval() {
    }

    protected void checkInterval(long start, long end) {
        if (end < start) {
            throw new IllegalArgumentException("The end instant must be greater or equal to the start");
        }
    }

    @Override
    public DateTime getStart() {
        return new DateTime(this.getStartMillis(), this.getChronology());
    }

    @Override
    public DateTime getEnd() {
        return new DateTime(this.getEndMillis(), this.getChronology());
    }

    public boolean contains(long millisInstant) {
        long thisStart = this.getStartMillis();
        long thisEnd = this.getEndMillis();
        return millisInstant >= thisStart && millisInstant < thisEnd;
    }

    public boolean containsNow() {
        return this.contains(DateTimeUtils.currentTimeMillis());
    }

    @Override
    public boolean contains(ReadableInstant instant) {
        if (instant == null) {
            return this.containsNow();
        }
        return this.contains(instant.getMillis());
    }

    @Override
    public boolean contains(ReadableInterval interval) {
        if (interval == null) {
            return this.containsNow();
        }
        long otherStart = interval.getStartMillis();
        long otherEnd = interval.getEndMillis();
        long thisStart = this.getStartMillis();
        long thisEnd = this.getEndMillis();
        return thisStart <= otherStart && otherStart < thisEnd && otherEnd <= thisEnd;
    }

    @Override
    public boolean overlaps(ReadableInterval interval) {
        long thisStart = this.getStartMillis();
        long thisEnd = this.getEndMillis();
        if (interval == null) {
            long now = DateTimeUtils.currentTimeMillis();
            return thisStart < now && now < thisEnd;
        }
        long otherStart = interval.getStartMillis();
        long otherEnd = interval.getEndMillis();
        return thisStart < otherEnd && otherStart < thisEnd;
    }

    public boolean isEqual(ReadableInterval other) {
        return this.getStartMillis() == other.getStartMillis() && this.getEndMillis() == other.getEndMillis();
    }

    public boolean isBefore(long millisInstant) {
        return this.getEndMillis() <= millisInstant;
    }

    public boolean isBeforeNow() {
        return this.isBefore(DateTimeUtils.currentTimeMillis());
    }

    @Override
    public boolean isBefore(ReadableInstant instant) {
        if (instant == null) {
            return this.isBeforeNow();
        }
        return this.isBefore(instant.getMillis());
    }

    @Override
    public boolean isBefore(ReadableInterval interval) {
        if (interval == null) {
            return this.isBeforeNow();
        }
        return this.isBefore(interval.getStartMillis());
    }

    public boolean isAfter(long millisInstant) {
        return this.getStartMillis() > millisInstant;
    }

    public boolean isAfterNow() {
        return this.isAfter(DateTimeUtils.currentTimeMillis());
    }

    @Override
    public boolean isAfter(ReadableInstant instant) {
        if (instant == null) {
            return this.isAfterNow();
        }
        return this.isAfter(instant.getMillis());
    }

    @Override
    public boolean isAfter(ReadableInterval interval) {
        long endMillis = interval == null ? DateTimeUtils.currentTimeMillis() : interval.getEndMillis();
        return this.getStartMillis() >= endMillis;
    }

    @Override
    public Interval toInterval() {
        return new Interval(this.getStartMillis(), this.getEndMillis(), this.getChronology());
    }

    @Override
    public MutableInterval toMutableInterval() {
        return new MutableInterval(this.getStartMillis(), this.getEndMillis(), this.getChronology());
    }

    @Override
    public long toDurationMillis() {
        return FieldUtils.safeAdd(this.getEndMillis(), -this.getStartMillis());
    }

    @Override
    public Duration toDuration() {
        long durMillis = this.toDurationMillis();
        if (durMillis == 0L) {
            return Duration.ZERO;
        }
        return new Duration(durMillis);
    }

    @Override
    public Period toPeriod() {
        return new Period(this.getStartMillis(), this.getEndMillis(), this.getChronology());
    }

    @Override
    public Period toPeriod(PeriodType type) {
        return new Period(this.getStartMillis(), this.getEndMillis(), type, this.getChronology());
    }

    @Override
    public boolean equals(Object readableInterval) {
        if (this == readableInterval) {
            return true;
        }
        if (!(readableInterval instanceof ReadableInterval)) {
            return false;
        }
        ReadableInterval other = (ReadableInterval)readableInterval;
        return this.getStartMillis() == other.getStartMillis() && this.getEndMillis() == other.getEndMillis() && FieldUtils.equals(this.getChronology(), other.getChronology());
    }

    @Override
    public int hashCode() {
        long start = this.getStartMillis();
        long end = this.getEndMillis();
        int result = 97;
        result = 31 * result + (int)(start ^ start >>> 32);
        result = 31 * result + (int)(end ^ end >>> 32);
        result = 31 * result + this.getChronology().hashCode();
        return result;
    }

    @Override
    public String toString() {
        DateTimeFormatter printer = ISODateTimeFormat.dateTime();
        printer = printer.withChronology(this.getChronology());
        StringBuffer buf = new StringBuffer(48);
        printer.printTo(buf, this.getStartMillis());
        buf.append('/');
        printer.printTo(buf, this.getEndMillis());
        return buf.toString();
    }
}

