/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.primitives.UnsignedBytes;
import java.util.BitSet;

class FileInstrumentationData {
    private final BitSet instrumentedBits;
    private final String arrayName;
    private final String fileName;

    FileInstrumentationData(String fileName, String arrayName) {
        this.fileName = fileName;
        this.arrayName = arrayName;
        this.instrumentedBits = new BitSet();
    }

    String getArrayName() {
        return this.arrayName;
    }

    String getFileName() {
        return this.fileName;
    }

    String getInstrumentedLinesAsHexString() {
        StringBuilder builder = new StringBuilder();
        for (byte byteEntry : this.instrumentedBits.toByteArray()) {
            int value = UnsignedBytes.toInt((byte)byteEntry);
            String hexString = Integer.toHexString(value);
            hexString = Strings.padStart((String)hexString, (int)2, (char)'0');
            builder.append(hexString);
        }
        return builder.toString();
    }

    void setLineAsInstrumented(int lineNumber) {
        Preconditions.checkArgument((lineNumber > 0 ? 1 : 0) != 0, (Object)"Expected non-zero positive integer as line number.");
        this.instrumentedBits.set(lineNumber - 1);
    }
}

