/*
 * Decompiled with CFR 0.152.
 */
package proguard.mark;

import proguard.Configuration;
import proguard.KeepClassSpecificationVisitorFactory;
import proguard.classfile.ClassPool;
import proguard.classfile.attribute.visitor.AttributeProcessingFlagFilter;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.visitor.ClassAccessFilter;
import proguard.classfile.visitor.ClassPoolVisitor;
import proguard.classfile.visitor.ClassProcessingFlagFilter;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberDescriptorReferencedClassVisitor;
import proguard.classfile.visitor.MemberProcessingFlagFilter;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.MultiClassPoolVisitor;
import proguard.classfile.visitor.MultiClassVisitor;
import proguard.classfile.visitor.NamedMethodVisitor;
import proguard.util.ProcessingFlagSetter;

public class Marker {
    private final Configuration configuration;

    public Marker(Configuration configuration) {
        this.configuration = configuration;
    }

    public void mark(ClassPool programClassPool, ClassPool libraryClassPool) {
        MultiClassPoolVisitor classPoolVisitor = new MultiClassPoolVisitor(new ClassPoolVisitor[]{this.createShrinkingMarker(), this.createOptimizationMarker(), this.createObfuscationMarker()});
        programClassPool.accept((ClassPoolVisitor)classPoolVisitor);
        libraryClassPool.accept((ClassPoolVisitor)classPoolVisitor);
    }

    private ClassPoolVisitor createShrinkingMarker() {
        ProcessingFlagSetter marker = new ProcessingFlagSetter(0x100000);
        MultiClassVisitor classUsageMarker = new MultiClassVisitor(new ClassVisitor[]{marker, new NamedMethodVisitor("<init>", "()V", (MemberVisitor)marker)});
        return new KeepClassSpecificationVisitorFactory(true, false, false).createClassPoolVisitor(this.configuration.keep, (ClassVisitor)classUsageMarker, (MemberVisitor)marker);
    }

    private ClassPoolVisitor createOptimizationMarker() {
        ProcessingFlagSetter marker = new ProcessingFlagSetter(0x200000);
        MemberDescriptorReferencedClassVisitor descriptorClassMarker = new MemberDescriptorReferencedClassVisitor((ClassVisitor)new ClassAccessFilter(0, 16384, (ClassVisitor)marker));
        return new MultiClassPoolVisitor(new ClassPoolVisitor[]{new KeepClassSpecificationVisitorFactory(false, true, false).createClassPoolVisitor(this.configuration.keep, (ClassVisitor)marker, (MemberVisitor)marker, (MemberVisitor)marker, (AttributeVisitor)marker), new KeepClassSpecificationVisitorFactory(false, false, true).createClassPoolVisitor(this.configuration.keep, null, (MemberVisitor)descriptorClassMarker, (MemberVisitor)descriptorClassMarker, null)});
    }

    private ClassPoolVisitor createObfuscationMarker() {
        ProcessingFlagSetter marker = new ProcessingFlagSetter(0x400000);
        ClassProcessingFlagFilter classMarker = new ClassProcessingFlagFilter(0, 512, (ClassVisitor)marker);
        MemberProcessingFlagFilter memberMarker = new MemberProcessingFlagFilter(0, 512, (MemberVisitor)marker);
        AttributeProcessingFlagFilter attributeMarker = new AttributeProcessingFlagFilter(0, 512, (AttributeVisitor)marker);
        return new KeepClassSpecificationVisitorFactory(false, false, true).createClassPoolVisitor(this.configuration.keep, (ClassVisitor)classMarker, (MemberVisitor)memberMarker, (MemberVisitor)memberMarker, (AttributeVisitor)attributeMarker);
    }
}

