/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize;

import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.optimize.info.ClassOptimizationInfo;
import proguard.optimize.info.CodeAttributeOptimizationInfo;
import proguard.optimize.info.FieldOptimizationInfo;
import proguard.optimize.info.MethodOptimizationInfo;

public class KeepMarker
implements ClassVisitor,
MemberVisitor,
AttributeVisitor {
    public void visitAnyClass(Clazz clazz) {
        ClassOptimizationInfo.setClassOptimizationInfo(clazz);
    }

    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        FieldOptimizationInfo.setFieldOptimizationInfo((Clazz)programClass, (Field)programField);
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        MethodOptimizationInfo.setMethodOptimizationInfo((Clazz)programClass, (Method)programMethod);
    }

    public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
        FieldOptimizationInfo.setFieldOptimizationInfo((Clazz)libraryClass, (Field)libraryField);
    }

    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        MethodOptimizationInfo.setMethodOptimizationInfo((Clazz)libraryClass, (Method)libraryMethod);
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        CodeAttributeOptimizationInfo.setCodeAttributeOptimizationInfo(codeAttribute);
    }

    public static boolean isKept(Clazz clazz) {
        ClassOptimizationInfo info = ClassOptimizationInfo.getClassOptimizationInfo(clazz);
        return info != null && info.isKept();
    }

    public static boolean isKept(Field field) {
        FieldOptimizationInfo info = FieldOptimizationInfo.getFieldOptimizationInfo(field);
        return info != null && info.isKept();
    }

    public static boolean isKept(Method method) {
        MethodOptimizationInfo info = MethodOptimizationInfo.getMethodOptimizationInfo(method);
        return info != null && info.isKept();
    }

    public static boolean isKept(CodeAttribute codeAttribute) {
        CodeAttributeOptimizationInfo info = CodeAttributeOptimizationInfo.getCodeAttributeOptimizationInfo(codeAttribute);
        return info != null && info.isKept();
    }
}

