/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize;

import proguard.classfile.Clazz;
import proguard.classfile.visitor.ClassVisitor;
import proguard.optimize.KeepMarker;

public class KeptClassFilter
implements ClassVisitor {
    private final ClassVisitor acceptedVisitor;
    private final ClassVisitor rejectedVisitor;

    public KeptClassFilter(ClassVisitor acceptedVisitor) {
        this(acceptedVisitor, null);
    }

    public KeptClassFilter(ClassVisitor acceptedVisitor, ClassVisitor rejectedVisitor) {
        this.acceptedVisitor = acceptedVisitor;
        this.rejectedVisitor = rejectedVisitor;
    }

    public void visitAnyClass(Clazz clazz) {
        ClassVisitor delegateVisitor;
        ClassVisitor classVisitor = delegateVisitor = KeepMarker.isKept(clazz) ? this.acceptedVisitor : this.rejectedVisitor;
        if (delegateVisitor != null) {
            clazz.accept(delegateVisitor);
        }
    }
}

