/*
 * Decompiled with CFR 0.152.
 */
package com.haotian.remote.invoke.dubbo;

import com.alibaba.dubbo.config.ProtocolConfig;
import com.haotian.remote.ProxyXmlWebApplicationContext;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.logging.Logger;
import org.springframework.beans.factory.FactoryBean;

public class DubboConfigFactoryBean
implements FactoryBean {
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    public Object getObject() throws Exception {
        ProtocolConfig protocolConfig = new ProtocolConfig();
        protocolConfig.setName(this.getValue("${protocol.name}", "dubbo"));
        protocolConfig.setThreads(Integer.valueOf(Integer.parseInt(this.getValue("${protocol.threads}", "200"))));
        int port = Integer.parseInt(this.getValue("${protocol.port}", "12200"));
        int offset = 20;
        for (int i = 0; i < offset; ++i) {
            try {
                ServerSocket serverSocket = new ServerSocket(port);
                serverSocket.close();
                break;
            }
            catch (IOException e) {
                this.logger.info("PORT[" + port + "] is used increment port");
                ++port;
                continue;
            }
        }
        if (Integer.parseInt(this.getValue("${protocol.port}", "12200")) + offset == port) {
            throw new IllegalStateException("no port for dubbo server");
        }
        protocolConfig.setPort(Integer.valueOf(port));
        return protocolConfig;
    }

    private String getValue(String key, String defaultValue) {
        String value = null;
        try {
            value = ProxyXmlWebApplicationContext.getRealValue((String)key);
        }
        catch (Throwable e) {
            this.logger.warning(key + "not config, user default value[" + defaultValue + "]");
            value = defaultValue;
        }
        if (value == null || "".equals(value)) {
            value = defaultValue;
        }
        return value;
    }

    public Class getObjectType() {
        return ProtocolConfig.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

