/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.tcp;

import com.hazelcast.internal.networking.nio.ChannelInboundHandlerWithCounters;
import com.hazelcast.nio.Packet;
import com.hazelcast.nio.PacketIOHelper;
import com.hazelcast.nio.tcp.TcpIpConnection;
import com.hazelcast.spi.impl.PacketHandler;
import java.nio.ByteBuffer;

public class PacketDecoder
extends ChannelInboundHandlerWithCounters {
    protected final TcpIpConnection connection;
    private final PacketHandler handler;
    private final PacketIOHelper packetReader = new PacketIOHelper();

    public PacketDecoder(TcpIpConnection connection, PacketHandler handler) {
        this.connection = connection;
        this.handler = handler;
    }

    @Override
    public void onRead(ByteBuffer src) throws Exception {
        Packet packet;
        while (src.hasRemaining() && (packet = this.packetReader.readFrom(src)) != null) {
            this.onPacketComplete(packet);
        }
    }

    protected void onPacketComplete(Packet packet) throws Exception {
        if (packet.isFlagRaised(16)) {
            this.priorityPacketsRead.inc();
        } else {
            this.normalPacketsRead.inc();
        }
        packet.setConn(this.connection);
        this.handler.handle(packet);
    }
}

