/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring;

import com.hazelcast.spring.AbstractHazelcastBeanDefinitionParser;
import com.hazelcast.spring.cache.SpringHazelcastCachingProvider;
import java.util.Properties;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class CacheManagerBeanDefinitionParser
extends AbstractHazelcastBeanDefinitionParser {
    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        SpringXmlBuilder springXmlBuilder = new SpringXmlBuilder(SpringHazelcastCachingProvider.class, parserContext);
        springXmlBuilder.handle(element);
        BeanDefinitionBuilder builder = springXmlBuilder.getBuilder();
        return builder.getBeanDefinition();
    }

    private class SpringXmlBuilder
    extends AbstractHazelcastBeanDefinitionParser.SpringXmlBuilderHelper {
        private final ParserContext parserContext;
        private final BeanDefinitionBuilder builder;

        SpringXmlBuilder(Class providerClass, ParserContext parserContext) {
            super(CacheManagerBeanDefinitionParser.this);
            this.parserContext = parserContext;
            this.builder = BeanDefinitionBuilder.rootBeanDefinition((Class)providerClass);
        }

        BeanDefinitionBuilder getBuilder() {
            return this.builder;
        }

        public void handle(Element element) {
            this.handleCommonBeanAttributes(element, this.builder, this.parserContext);
            NamedNodeMap attributes = element.getAttributes();
            String uri = null;
            String instanceRef = null;
            if (attributes != null) {
                Node uriNode;
                Node instanceRefNode = attributes.getNamedItem("instance-ref");
                if (instanceRefNode != null) {
                    instanceRef = this.getTextContent(instanceRefNode);
                }
                if ((uriNode = attributes.getNamedItem("uri")) != null) {
                    uri = this.getTextContent(uriNode);
                }
            }
            Properties properties = new Properties();
            for (Node n : SpringXmlBuilder.childElements(element)) {
                String nodeName = SpringXmlBuilder.cleanNodeName(n);
                if (!"properties".equals(nodeName)) continue;
                for (Node propNode : SpringXmlBuilder.childElements(n)) {
                    String name = SpringXmlBuilder.cleanNodeName(propNode);
                    if (!"property".equals(name)) continue;
                    String propertyName = this.getTextContent(propNode.getAttributes().getNamedItem("name")).trim();
                    String value = this.getTextContent(propNode);
                    properties.setProperty(propertyName, value);
                }
            }
            if (instanceRef != null) {
                this.builder.addConstructorArgReference(instanceRef);
            }
            this.builder.addConstructorArgValue((Object)uri);
            this.builder.addConstructorArgValue((Object)properties);
            this.builder.setFactoryMethod("getCacheManager");
        }
    }
}

