/*
 * Decompiled with CFR 0.152.
 */
package org.javacc.jjtree;

import org.javacc.jjtree.JJTreeParser;
import org.javacc.jjtree.JJTreeParserTreeConstants;
import org.javacc.jjtree.JJTreeParserVisitor;
import org.javacc.jjtree.Node;

public class SimpleNode
implements Node {
    protected Node parent;
    protected Node[] children;
    protected int id;
    protected Object value;
    protected JJTreeParser parser;

    public SimpleNode(int n) {
        this.id = n;
    }

    public SimpleNode(JJTreeParser jJTreeParser, int n) {
        this(n);
        this.parser = jJTreeParser;
    }

    public void jjtOpen() {
    }

    public void jjtClose() {
    }

    public void jjtSetParent(Node node) {
        this.parent = node;
    }

    public Node jjtGetParent() {
        return this.parent;
    }

    public void jjtAddChild(Node node, int n) {
        if (this.children == null) {
            this.children = new Node[n + 1];
        } else if (n >= this.children.length) {
            Node[] nodeArray = new Node[n + 1];
            System.arraycopy(this.children, 0, nodeArray, 0, this.children.length);
            this.children = nodeArray;
        }
        this.children[n] = node;
    }

    public Node jjtGetChild(int n) {
        return this.children[n];
    }

    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public void jjtSetValue(Object object) {
        this.value = object;
    }

    public Object jjtGetValue() {
        return this.value;
    }

    public Object jjtAccept(JJTreeParserVisitor jJTreeParserVisitor, Object object) {
        return jJTreeParserVisitor.visit(this, object);
    }

    public Object childrenAccept(JJTreeParserVisitor jJTreeParserVisitor, Object object) {
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                this.children[i].jjtAccept(jJTreeParserVisitor, object);
            }
        }
        return object;
    }

    public String toString() {
        return JJTreeParserTreeConstants.jjtNodeName[this.id];
    }

    public String toString(String string) {
        return string + this.toString();
    }

    public void dump(String string) {
        System.out.println(this.toString(string));
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                SimpleNode simpleNode = (SimpleNode)this.children[i];
                if (simpleNode == null) continue;
                simpleNode.dump(string + " ");
            }
        }
    }

    public int getId() {
        return this.id;
    }
}

