/*
 * Decompiled with CFR 0.152.
 */
package org.javacc.parser;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Set;
import org.javacc.parser.Expansion;
import org.javacc.parser.JavaCCErrors;
import org.javacc.parser.JavaCCGlobals;
import org.javacc.parser.JavaCCParser;
import org.javacc.parser.JavaCCParserInternals;
import org.javacc.parser.JavaFiles;
import org.javacc.parser.LexGen;
import org.javacc.parser.LexGenCPP;
import org.javacc.parser.LookaheadWalk;
import org.javacc.parser.MatchInfo;
import org.javacc.parser.MetaParseException;
import org.javacc.parser.NfaState;
import org.javacc.parser.Options;
import org.javacc.parser.OtherFilesGen;
import org.javacc.parser.OtherFilesGenCPP;
import org.javacc.parser.ParseException;
import org.javacc.parser.ParseGen;
import org.javacc.parser.ParseGenCPP;
import org.javacc.parser.RStringLiteral;
import org.javacc.parser.Semanticize;
import org.javacc.utils.OptionInfo;
import org.javacc.utils.OptionType;

public final class Main {
    public static LexGen lg;

    private Main() {
    }

    static void help_message() {
        System.out.println("Usage:");
        System.out.println("    javacc option-settings inputfile");
        System.out.println("");
        System.out.println("\"option-settings\" is a sequence of settings separated by spaces.");
        System.out.println("Each option setting must be of one of the following forms:");
        System.out.println("");
        System.out.println("    -optionname=value (e.g., -STATIC=false)");
        System.out.println("    -optionname:value (e.g., -STATIC:false)");
        System.out.println("    -optionname       (equivalent to -optionname=true.  e.g., -STATIC)");
        System.out.println("    -NOoptionname     (equivalent to -optionname=false. e.g., -NOSTATIC)");
        System.out.println("");
        System.out.println("Option settings are not case-sensitive, so one can say \"-nOsTaTiC\" instead");
        System.out.println("of \"-NOSTATIC\".  Option values must be appropriate for the corresponding");
        System.out.println("option, and must be either an integer, a boolean, or a string value.");
        System.out.println("");
        Main.printOptions();
        System.out.println("EXAMPLE:");
        System.out.println("    javacc -STATIC=false -LOOKAHEAD:2 -debug_parser mygrammar.jj");
        System.out.println("");
    }

    private static void printOptions() {
        Set<OptionInfo> set = Options.getUserOptions();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (OptionInfo optionInfo : set) {
            int n4 = optionInfo.getName().length();
            if (optionInfo.getType() == OptionType.INTEGER) {
                n = n4 > n ? n4 : n;
                continue;
            }
            if (optionInfo.getType() == OptionType.BOOLEAN) {
                n2 = n4 > n2 ? n4 : n2;
                continue;
            }
            if (optionInfo.getType() != OptionType.STRING) continue;
            n3 = n4 > n3 ? n4 : n3;
        }
        if (n > 0) {
            System.out.println("The integer valued options are:");
            System.out.println("");
            for (OptionInfo optionInfo : set) {
                Main.printOptionInfo(OptionType.INTEGER, optionInfo, n);
            }
            System.out.println("");
        }
        if (n2 > 0) {
            System.out.println("The boolean valued options are:");
            System.out.println("");
            for (OptionInfo optionInfo : set) {
                Main.printOptionInfo(OptionType.BOOLEAN, optionInfo, n2);
            }
            System.out.println("");
        }
        if (n3 > 0) {
            System.out.println("The string valued options are:");
            System.out.println("");
            for (OptionInfo optionInfo : set) {
                Main.printOptionInfo(OptionType.STRING, optionInfo, n3);
            }
            System.out.println("");
        }
    }

    private static void printOptionInfo(OptionType optionType, OptionInfo optionInfo, int n) {
        if (optionInfo.getType() == optionType) {
            Object object = optionInfo.getDefault();
            System.out.println("    " + Main.padRight(optionInfo.getName(), n + 1) + (object == null ? "" : "(default : " + (object.toString().length() == 0 ? "<<empty>>" : object) + ")"));
        }
    }

    private static String padRight(String string, int n) {
        int n2 = string.length();
        if (n2 == n) {
            return string;
        }
        int n3 = n - n2;
        StringBuilder stringBuilder = new StringBuilder(n3);
        stringBuilder.append(string);
        for (int i = 0; i < n3; ++i) {
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) throws Exception {
        int n = Main.mainProgram(stringArray);
        System.exit(n);
    }

    public static int mainProgram(String[] stringArray) throws Exception {
        Object object;
        Main.reInitAll();
        JavaCCGlobals.bannerLine("Parser Generator", "");
        JavaCCParser javaCCParser = null;
        if (stringArray.length == 0) {
            System.out.println("");
            Main.help_message();
            return 1;
        }
        System.out.println("(type \"javacc\" with no arguments for help)");
        if (Options.isOption(stringArray[stringArray.length - 1])) {
            System.out.println("Last argument \"" + stringArray[stringArray.length - 1] + "\" is not a filename.");
            return 1;
        }
        for (int i = 0; i < stringArray.length - 1; ++i) {
            if (!Options.isOption(stringArray[i])) {
                System.out.println("Argument \"" + stringArray[i] + "\" must be an option setting.");
                return 1;
            }
            Options.setCmdLineOption(stringArray[i]);
        }
        try {
            object = new File(stringArray[stringArray.length - 1]);
            if (!((File)object).exists()) {
                System.out.println("File " + stringArray[stringArray.length - 1] + " not found.");
                return 1;
            }
            if (((File)object).isDirectory()) {
                System.out.println(stringArray[stringArray.length - 1] + " is a directory. Please use a valid file name.");
                return 1;
            }
            javaCCParser = new JavaCCParser(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(stringArray[stringArray.length - 1]), Options.getGrammarEncoding())));
        }
        catch (SecurityException securityException) {
            System.out.println("Security violation while trying to open " + stringArray[stringArray.length - 1]);
            return 1;
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("File " + stringArray[stringArray.length - 1] + " not found.");
            return 1;
        }
        try {
            boolean bl;
            System.out.println("Reading from file " + stringArray[stringArray.length - 1] + " . . .");
            JavaCCGlobals.fileName = JavaCCGlobals.origFileName = stringArray[stringArray.length - 1];
            JavaCCGlobals.jjtreeGenerated = JavaCCGlobals.isGeneratedBy("JJTree", stringArray[stringArray.length - 1]);
            JavaCCGlobals.toolNames = JavaCCGlobals.getToolNames(stringArray[stringArray.length - 1]);
            javaCCParser.javacc_input();
            object = Options.getOutputLanguage();
            boolean bl2 = Options.isOutputLanguageJava();
            boolean bl3 = ((String)object).equals("c++");
            boolean bl4 = bl = bl2 && Options.getJavaTemplateType().equals("modern");
            if (bl2) {
                lg = new LexGen();
            } else if (bl3) {
                lg = new LexGenCPP();
            } else {
                return Main.unhandledLanguageExit((String)object);
            }
            JavaCCGlobals.createOutputDir(Options.getOutputDirectory());
            if (Options.getUnicodeInput()) {
                NfaState.unicodeWarningGiven = true;
                System.out.println("Note: UNICODE_INPUT option is specified. Please make sure you create the parser/lexer using a Reader with the correct character encoding.");
            }
            Semanticize.start();
            boolean bl5 = Options.getBuildParser();
            if (bl2) {
                if (bl5) {
                    new ParseGen().start(bl);
                }
                if (bl5) {
                    new LexGen().start();
                }
                Options.setStringOption("PARSER_NAME", JavaCCGlobals.cu_name);
                OtherFilesGen.start(bl);
            } else if (bl3) {
                if (bl5) {
                    new ParseGenCPP().start();
                }
                if (bl5) {
                    new LexGenCPP().start();
                }
                Options.setStringOption("PARSER_NAME", JavaCCGlobals.cu_name);
                OtherFilesGenCPP.start();
            } else {
                Main.unhandledLanguageExit((String)object);
            }
            if (JavaCCErrors.get_error_count() == 0 && (bl5 || Options.getBuildTokenManager())) {
                if (JavaCCErrors.get_warning_count() == 0) {
                    System.out.println("Parser generated successfully.");
                } else {
                    System.out.println("Parser generated with 0 errors and " + JavaCCErrors.get_warning_count() + " warnings.");
                }
                return 0;
            }
            System.out.println("Detected " + JavaCCErrors.get_error_count() + " errors and " + JavaCCErrors.get_warning_count() + " warnings.");
            return JavaCCErrors.get_error_count() == 0 ? 0 : 1;
        }
        catch (MetaParseException metaParseException) {
            System.out.println("Detected " + JavaCCErrors.get_error_count() + " errors and " + JavaCCErrors.get_warning_count() + " warnings.");
            return 1;
        }
        catch (ParseException parseException) {
            System.out.println(parseException.toString());
            System.out.println("Detected " + (JavaCCErrors.get_error_count() + 1) + " errors and " + JavaCCErrors.get_warning_count() + " warnings.");
            return 1;
        }
    }

    private static int unhandledLanguageExit(String string) {
        System.out.println("Invalid 'OUTPUT_LANGUAGE' specified : " + string);
        return 1;
    }

    public static void reInitAll() {
        Expansion.reInit();
        JavaCCErrors.reInit();
        JavaCCGlobals.reInit();
        Options.init();
        JavaCCParserInternals.reInit();
        RStringLiteral.reInit();
        JavaFiles.reInit();
        NfaState.reInit();
        MatchInfo.reInit();
        LookaheadWalk.reInit();
        Semanticize.reInit();
        OtherFilesGen.reInit();
        LexGen.reInit();
        ParseGen.reInit();
    }
}

