/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.model;

import com.obs.services.model.BaseObjectRequest;
import com.obs.services.model.HttpMethodEnum;
import com.obs.services.model.ObjectRepleaceMetadata;
import com.obs.services.model.StorageClassEnum;
import java.util.HashMap;
import java.util.Map;

public class SetObjectMetadataRequest
extends BaseObjectRequest {
    private String versionId;
    private StorageClassEnum storageClass;
    private String webSiteRedirectLocation;
    private boolean removeUnset;
    private Map<String, String> userMetadata;
    private boolean encodeHeaders;
    private final ObjectRepleaceMetadata replaceMetadata;

    public SetObjectMetadataRequest() {
        this.httpMethod = HttpMethodEnum.PUT;
        this.encodeHeaders = true;
        this.replaceMetadata = new ObjectRepleaceMetadata();
    }

    public SetObjectMetadataRequest(String bucketName, String objectKey) {
        this.httpMethod = HttpMethodEnum.PUT;
        this.encodeHeaders = true;
        this.replaceMetadata = new ObjectRepleaceMetadata();
        this.bucketName = bucketName;
        this.objectKey = objectKey;
    }

    public SetObjectMetadataRequest(String bucketName, String objectKey, String versionId) {
        this.httpMethod = HttpMethodEnum.PUT;
        this.encodeHeaders = true;
        this.replaceMetadata = new ObjectRepleaceMetadata();
        this.bucketName = bucketName;
        this.objectKey = objectKey;
        this.versionId = versionId;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public void setVersionId(String versionId) {
        this.versionId = versionId;
    }

    public String getWebSiteRedirectLocation() {
        return this.webSiteRedirectLocation;
    }

    public void setWebSiteRedirectLocation(String webSiteRedirectLocation) {
        this.webSiteRedirectLocation = webSiteRedirectLocation;
    }

    public StorageClassEnum getObjectStorageClass() {
        return this.storageClass;
    }

    public void setObjectStorageClass(StorageClassEnum storageClass) {
        this.storageClass = storageClass;
    }

    public boolean isRemoveUnset() {
        return this.removeUnset;
    }

    public void setRemoveUnset(boolean removeUnset) {
        this.removeUnset = removeUnset;
    }

    public void addUserMetadata(String key, String value) {
        this.getAllUserMetadata().put(key, value);
    }

    public void addAllUserMetadata(Map<String, String> userMetadata) {
        if (userMetadata != null) {
            this.getAllUserMetadata().putAll(userMetadata);
        }
    }

    public Object getUserMetadata(String key) {
        return this.getAllUserMetadata().get(key);
    }

    public String getContentType() {
        return this.replaceMetadata.getContentType();
    }

    public void setContentType(String contentType) {
        this.replaceMetadata.setContentType(contentType);
    }

    public String getContentLanguage() {
        return this.replaceMetadata.getContentLanguage();
    }

    public void setContentLanguage(String contentLanguage) {
        this.replaceMetadata.setContentLanguage(contentLanguage);
    }

    public String getExpires() {
        return this.replaceMetadata.getExpires();
    }

    public void setExpires(String expires) {
        this.replaceMetadata.setExpires(expires);
    }

    public String getCacheControl() {
        return this.replaceMetadata.getCacheControl();
    }

    public void setCacheControl(String cacheControl) {
        this.replaceMetadata.setCacheControl(cacheControl);
    }

    public String getContentDisposition() {
        return this.replaceMetadata.getContentDisposition();
    }

    public void setContentDisposition(String contentDisposition) {
        this.replaceMetadata.setContentDisposition(contentDisposition);
    }

    public String getContentEncoding() {
        return this.replaceMetadata.getContentEncoding();
    }

    public void setContentEncoding(String contentEncoding) {
        this.replaceMetadata.setContentEncoding(contentEncoding);
    }

    public Map<String, String> getAllUserMetadata() {
        if (this.userMetadata == null) {
            this.userMetadata = new HashMap<String, String>();
        }
        return this.userMetadata;
    }

    @Deprecated
    public Map<String, String> getMetadata() {
        return this.getAllUserMetadata();
    }

    @Override
    public void setIsEncodeHeaders(boolean encodeHeaders) {
        this.encodeHeaders = encodeHeaders;
    }

    @Override
    public boolean isEncodeHeaders() {
        return this.encodeHeaders;
    }

    @Override
    public String toString() {
        return "SetObjectMetadataRequest [bucketName=" + this.bucketName + ", objectKey=" + this.objectKey + ", versionId=" + this.versionId + ", storageClass=" + (Object)((Object)this.storageClass) + ", webSiteRedirectLocation=" + this.webSiteRedirectLocation + ", removeUnset=" + this.removeUnset + ", userMetadata=" + this.userMetadata + ", replaceMetadata=" + this.replaceMetadata + ", isEncodeHeaders=" + this.encodeHeaders + "]";
    }
}

