/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.obs.log.ILogger;
import com.obs.log.LoggerBuilder;
import com.obs.services.internal.ServiceException;
import com.obs.services.internal.handler.XmlResponsesSaxParser;
import com.obs.services.internal.io.HttpMethodReleaseInputStream;
import com.obs.services.internal.service.AbstractRequestConvertor;
import com.obs.services.internal.service.ObsObjectService;
import com.obs.services.internal.trans.NewTransResult;
import com.obs.services.internal.utils.JSONChange;
import com.obs.services.internal.utils.RestUtils;
import com.obs.services.internal.utils.ServiceUtils;
import com.obs.services.model.AccessControlList;
import com.obs.services.model.HttpMethodEnum;
import com.obs.services.model.SpecialParamEnum;
import com.obs.services.model.StorageClassEnum;
import com.obs.services.model.fs.ContentSummaryFsRequest;
import com.obs.services.model.fs.ContentSummaryFsResult;
import com.obs.services.model.fs.ListContentSummaryFsRequest;
import com.obs.services.model.fs.ListContentSummaryFsResult;
import com.obs.services.model.fs.ListContentSummaryRequest;
import com.obs.services.model.fs.ListContentSummaryResult;
import com.obs.services.model.fs.ObsFSFile;
import com.obs.services.model.fs.RenameRequest;
import com.obs.services.model.fs.RenameResult;
import com.obs.services.model.fs.TruncateFileRequest;
import com.obs.services.model.fs.TruncateFileResult;
import com.obs.services.model.fs.WriteFileRequest;
import com.obs.services.model.fs.accesslabel.DeleteAccessLabelRequest;
import com.obs.services.model.fs.accesslabel.DeleteAccessLabelResult;
import com.obs.services.model.fs.accesslabel.GetAccessLabelRequest;
import com.obs.services.model.fs.accesslabel.GetAccessLabelResult;
import com.obs.services.model.fs.accesslabel.SetAccessLabelRequest;
import com.obs.services.model.fs.accesslabel.SetAccessLabelResult;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import okhttp3.Response;

public abstract class ObsFileService
extends ObsObjectService {
    private static final ILogger log = LoggerBuilder.getLogger(ObsFileService.class);

    protected TruncateFileResult truncateFileImpl(TruncateFileRequest request) throws ServiceException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put(SpecialParamEnum.TRUNCATE.getOriginalStringCode(), "");
        requestParams.put("length", String.valueOf(request.getNewLength()));
        Map<String, String> headers = this.transRequestPaymentHeaders(request, null, this.getIHeaders(request.getBucketName()));
        NewTransResult transResult = this.transObjectRequest(request);
        transResult.setParams(requestParams);
        transResult.setHeaders(headers);
        Response response = this.performRequest(transResult);
        TruncateFileResult result = new TruncateFileResult();
        this.setHeadersAndStatus(result, response);
        return result;
    }

    protected RenameResult renameFileImpl(RenameRequest request) throws ServiceException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put(SpecialParamEnum.RENAME.getOriginalStringCode(), "");
        requestParams.put("name", request.getNewObjectKey());
        Map<String, String> headers = this.transRequestPaymentHeaders(request, null, this.getIHeaders(request.getBucketName()));
        NewTransResult transResult = this.transObjectRequest(request);
        transResult.setParams(requestParams);
        transResult.setHeaders(headers);
        Response response = this.performRequest(transResult);
        RenameResult result = new RenameResult();
        this.setHeadersAndStatus(result, response);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ObsFSFile writeFileImpl(WriteFileRequest request) throws ServiceException {
        ObsFSFile ret;
        block8: {
            Response response;
            boolean isExtraAclPutRequired;
            AbstractRequestConvertor.TransResult result = null;
            AccessControlList acl = request.getAcl();
            try {
                result = this.transWriteFileRequest(request);
                isExtraAclPutRequired = !this.prepareRESTHeaderAcl(request.getBucketName(), result.getHeaders(), acl);
                NewTransResult newTransResult = this.transObjectRequestWithResult(result, request);
                response = this.performRequest(newTransResult);
            }
            finally {
                if (result != null && result.getBody() != null && request.isAutoClose() && result.getBody() instanceof Closeable) {
                    ServiceUtils.closeStream((Closeable)result.getBody());
                }
            }
            ret = new ObsFSFile(request.getBucketName(), request.getObjectKey(), response.header("ETag"), response.header(this.getIHeaders(request.getBucketName()).versionIdHeader()), StorageClassEnum.getValueFromCode(response.header(this.getIHeaders(request.getBucketName()).storageClassHeader())), this.getObjectUrl(request.getBucketName(), request.getObjectKey(), request.getIsIgnorePort()));
            this.setHeadersAndStatus(ret, response);
            if (isExtraAclPutRequired && acl != null) {
                try {
                    this.putAclImpl(request.getBucketName(), request.getObjectKey(), acl, null, request.isRequesterPays());
                }
                catch (Exception e) {
                    if (!log.isWarnEnabled()) break block8;
                    log.warn("Try to set object acl error", e);
                }
            }
        }
        return ret;
    }

    protected ListContentSummaryResult listContentSummaryImpl(ListContentSummaryRequest listContentSummaryRequest) throws ServiceException {
        AbstractRequestConvertor.TransResult result = this.transListContentSummaryRequest(listContentSummaryRequest);
        Response httpResponse = this.performRestGet(listContentSummaryRequest.getBucketName(), null, result.getParams(), null, listContentSummaryRequest.getUserHeaders());
        this.verifyResponseContentType(httpResponse);
        XmlResponsesSaxParser.ListContentSummaryHandler listContentSummaryHandler = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.ListContentSummaryHandler.class, true);
        ListContentSummaryResult contentSummaryResult = new ListContentSummaryResult.Builder().folderContentSummaries(listContentSummaryHandler.getFolderContentSummaries()).bucketName(listContentSummaryHandler.getBucketName() == null ? listContentSummaryRequest.getBucketName() : listContentSummaryHandler.getBucketName()).truncated(listContentSummaryHandler.isListingTruncated()).prefix(listContentSummaryHandler.getRequestPrefix() == null ? listContentSummaryRequest.getPrefix() : listContentSummaryHandler.getRequestPrefix()).marker(listContentSummaryHandler.getRequestMarker() == null ? listContentSummaryRequest.getMarker() : listContentSummaryHandler.getRequestMarker()).maxKeys(listContentSummaryHandler.getRequestMaxKeys()).delimiter(listContentSummaryHandler.getRequestDelimiter() == null ? listContentSummaryRequest.getDelimiter() : listContentSummaryHandler.getRequestDelimiter()).nextMarker(listContentSummaryHandler.getMarkerForNextListing()).location(httpResponse.header(this.getIHeaders(listContentSummaryRequest.getBucketName()).bucketRegionHeader())).builder();
        this.setHeadersAndStatus(contentSummaryResult, httpResponse);
        return contentSummaryResult;
    }

    protected ListContentSummaryFsResult listContentSummaryFsImpl(ListContentSummaryFsRequest listContentSummaryFsRequest) throws ServiceException {
        AbstractRequestConvertor.TransResult result = this.transListContentSummaryFsRequest(listContentSummaryFsRequest);
        Response httpResponse = this.performRestGet(listContentSummaryFsRequest.getBucketName(), null, result.getParams(), result.getHeaders(), listContentSummaryFsRequest.getUserHeaders());
        this.verifyResponseContentType(httpResponse);
        XmlResponsesSaxParser.ListContentSummaryFsHandler listContentSummaryFsHandler = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.ListContentSummaryFsHandler.class, true);
        ListContentSummaryFsResult listContentSummaryFsResult = new ListContentSummaryFsResult();
        listContentSummaryFsResult.setDirContentSummaries(listContentSummaryFsHandler.getDirContentSummaries());
        listContentSummaryFsResult.setErrorResults(listContentSummaryFsHandler.getErrorResults());
        this.setHeadersAndStatus(listContentSummaryFsResult, httpResponse);
        return listContentSummaryFsResult;
    }

    protected ContentSummaryFsResult getContentSummaryFsImpl(ContentSummaryFsRequest contentSummaryFsRequest) throws ServiceException {
        AbstractRequestConvertor.TransResult result = this.transGetContentSummaryFs(contentSummaryFsRequest);
        Response httpResponse = this.performRestGet(contentSummaryFsRequest.getBucketName(), contentSummaryFsRequest.getDirName().equals("/") ? null : contentSummaryFsRequest.getDirName(), result.getParams(), null, contentSummaryFsRequest.getUserHeaders());
        this.verifyResponseContentType(httpResponse);
        XmlResponsesSaxParser.ContentSummaryFsHandler contentSummaryFsHandler = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.ContentSummaryFsHandler.class, true);
        ContentSummaryFsResult contentSummaryFsResult = new ContentSummaryFsResult();
        contentSummaryFsResult.setContentSummary(contentSummaryFsHandler.getContentSummary());
        this.setHeadersAndStatus(contentSummaryFsResult, httpResponse);
        return contentSummaryFsResult;
    }

    protected SetAccessLabelResult setAccessLabelFsImpl(SetAccessLabelRequest request) throws ServiceException {
        NewTransResult newResult = new NewTransResult();
        newResult.setHttpMethod(HttpMethodEnum.PUT);
        newResult.setBucketName(request.getBucketName());
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put("x-obs-" + SpecialParamEnum.ACCESSLABEL.getOriginalStringCode(), "");
        newResult.setParams(requestParams);
        newResult.setEncodeUrl(false);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        newResult.setHeaders(headers);
        newResult.setObjectKey(request.getDir());
        SetAccessLabelJson setAccessLabelJson = new SetAccessLabelJson();
        setAccessLabelJson.setAccesslabel(request.getRoleLabel());
        newResult.setBody(this.createRequestBody("application/json", JSONChange.objToJson(setAccessLabelJson)));
        Response httpResponse = this.performRequest(newResult);
        SetAccessLabelResult setAccessLabelResult = new SetAccessLabelResult();
        this.setHeadersAndStatus(setAccessLabelResult, httpResponse);
        return setAccessLabelResult;
    }

    protected GetAccessLabelResult getAccessLabelFsImpl(GetAccessLabelRequest request) throws ServiceException {
        NewTransResult newResult = new NewTransResult();
        newResult.setHttpMethod(HttpMethodEnum.GET);
        newResult.setBucketName(request.getBucketName());
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put("x-obs-" + SpecialParamEnum.ACCESSLABEL.getOriginalStringCode(), "");
        newResult.setParams(requestParams);
        newResult.setEncodeUrl(false);
        newResult.setObjectKey(request.getDir());
        Response httpResponse = this.performRequest(newResult, true, false, false, false);
        this.verifyResponseContentTypeForJson(httpResponse);
        String body = RestUtils.readBodyFromResponse(httpResponse);
        Iterator iterator = JSONChange.readNodeFromJson(body).get("accesslabel").iterator();
        ArrayList<String> roleLabel = new ArrayList<String>();
        while (iterator.hasNext()) {
            roleLabel.add(((JsonNode)iterator.next()).textValue());
        }
        GetAccessLabelResult getAccessLabelResult = new GetAccessLabelResult();
        getAccessLabelResult.setRoleLabel(roleLabel);
        this.setHeadersAndStatus(getAccessLabelResult, httpResponse);
        return getAccessLabelResult;
    }

    protected DeleteAccessLabelResult deleteAccessLabelFsImpl(DeleteAccessLabelRequest request) throws ServiceException {
        NewTransResult newResult = new NewTransResult();
        newResult.setBucketName(request.getBucketName());
        newResult.setHttpMethod(HttpMethodEnum.DELETE);
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put("x-obs-" + SpecialParamEnum.ACCESSLABEL.getOriginalStringCode(), "");
        newResult.setEncodeUrl(false);
        newResult.setParams(requestParams);
        HashMap<String, String> headers = new HashMap<String, String>();
        newResult.setHeaders(headers);
        newResult.setObjectKey(request.getDir());
        Response httpResponse = this.performRequest(newResult);
        DeleteAccessLabelResult deleteAccessLabelResult = new DeleteAccessLabelResult();
        this.setHeadersAndStatus(deleteAccessLabelResult, httpResponse);
        return deleteAccessLabelResult;
    }

    private class SetAccessLabelJson {
        private List<String> accesslabel;

        private SetAccessLabelJson() {
        }

        public List<String> getAccesslabel() {
            return this.accesslabel;
        }

        public void setAccesslabel(List<String> accesslabel) {
            this.accesslabel = accesslabel;
        }
    }
}

