/*
 * Decompiled with CFR 0.152.
 */
package com.oef.services;

import com.obs.log.ILogger;
import com.obs.log.LoggerBuilder;
import com.obs.services.AbstractClient;
import com.obs.services.ObsClient;
import com.obs.services.ObsConfiguration;
import com.obs.services.exception.ObsException;
import com.obs.services.internal.ServiceException;
import com.obs.services.internal.utils.JSONChange;
import com.obs.services.internal.utils.ServiceUtils;
import com.obs.services.model.HeaderResponse;
import com.oef.services.IOefClient;
import com.oef.services.model.CreateAsyncFetchJobsRequest;
import com.oef.services.model.CreateAsynchFetchJobsResult;
import com.oef.services.model.PutExtensionPolicyRequest;
import com.oef.services.model.QueryAsynchFetchJobsResult;
import com.oef.services.model.QueryExtensionPolicyResult;

public class OefClient
extends ObsClient
implements IOefClient {
    private static final ILogger ILOG = LoggerBuilder.getLogger(OefClient.class);

    public OefClient(String endPoint) {
        super(endPoint);
    }

    public OefClient(ObsConfiguration config) {
        super(config);
    }

    public OefClient(String accessKey, String secretKey, String endPoint) {
        super(accessKey, secretKey, endPoint);
    }

    public OefClient(String accessKey, String secretKey, ObsConfiguration config) {
        super(accessKey, secretKey, config);
    }

    public OefClient(String accessKey, String secretKey, String securityToken, String endPoint) {
        super(accessKey, secretKey, securityToken, endPoint);
    }

    public OefClient(String accessKey, String secretKey, String securityToken, ObsConfiguration config) {
        super(accessKey, secretKey, securityToken, config);
    }

    @Override
    public HeaderResponse putExtensionPolicy(final String bucketName, final PutExtensionPolicyRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(bucketName, "bucket is null");
        ServiceUtils.assertParameterNotNull(request, "policy is null");
        if (null == request.getCompress() && null == request.getFetch() && null == request.getTranscode()) {
            throw new IllegalArgumentException("putExtensionPolicy failed: compress, fetch and transcode cannot be empty at the same time");
        }
        return this.doActionWithResult("putExtensionPolicy", bucketName, new AbstractClient.ActionCallbackWithResult<HeaderResponse>(this){
            final /* synthetic */ OefClient this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public HeaderResponse action() throws ServiceException {
                String policy = JSONChange.objToJson(request);
                return this.this$0.setExtensionPolicyImpl(bucketName, policy);
            }
        });
    }

    @Override
    public QueryExtensionPolicyResult queryExtensionPolicy(final String bucketName) throws ObsException {
        ServiceUtils.assertParameterNotNull(bucketName, "bucket is null");
        return this.doActionWithResult("queryExtensionPolicy", bucketName, new AbstractClient.ActionCallbackWithResult<QueryExtensionPolicyResult>(this){
            final /* synthetic */ OefClient this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public QueryExtensionPolicyResult action() throws ServiceException {
                return this.this$0.queryExtensionPolicyImpl(bucketName);
            }
        });
    }

    @Override
    public HeaderResponse deleteExtensionPolicy(final String bucketName) throws ObsException {
        ServiceUtils.assertParameterNotNull(bucketName, "bucket is null");
        return this.doActionWithResult("deleteExtensionPolicy", bucketName, new AbstractClient.ActionCallbackWithResult<HeaderResponse>(this){
            final /* synthetic */ OefClient this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public HeaderResponse action() throws ServiceException {
                return this.this$0.deleteExtensionPolicyImpl(bucketName);
            }
        });
    }

    @Override
    public CreateAsynchFetchJobsResult createFetchJob(final CreateAsyncFetchJobsRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request.getBucketName(), "bucket is null");
        ServiceUtils.assertParameterNotNull(request, "policy is null");
        ServiceUtils.assertParameterNotNull(request.getUrl(), "url is null");
        if (request.getCallBackUrl() != null) {
            ServiceUtils.assertParameterNotNull(request.getCallBackBody(), "callbackbody is null when callbackurl is not null");
        }
        return this.doActionWithResult("CreateFetchJob", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<CreateAsynchFetchJobsResult>(this){
            final /* synthetic */ OefClient this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public CreateAsynchFetchJobsResult action() throws ServiceException {
                String policy = JSONChange.objToJson(request);
                return this.this$0.createFetchJobImpl(request.getBucketName(), policy);
            }
        });
    }

    @Override
    public QueryAsynchFetchJobsResult queryFetchJob(final String bucketName, final String jobId) throws ObsException {
        ServiceUtils.assertParameterNotNull(bucketName, "bucket is null");
        ServiceUtils.assertParameterNotNull(jobId, "jobId is null");
        return this.doActionWithResult("queryFetchJob", bucketName, new AbstractClient.ActionCallbackWithResult<QueryAsynchFetchJobsResult>(this){
            final /* synthetic */ OefClient this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public QueryAsynchFetchJobsResult action() throws ServiceException {
                return this.this$0.queryFetchJobImpl(bucketName, jobId);
            }
        });
    }
}

