/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.servicecomb.discovery.client.model;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.servicecomb.foundation.common.net.URIEndpointObject;
import org.apache.servicecomb.service.center.client.model.MicroserviceInstance;
import org.springframework.cloud.client.ServiceInstance;

public class ServiceCombServiceInstance
implements ServiceInstance {
    private final URIEndpointObject uriEndpointObject;
    private final MicroserviceInstance microserviceInstance;

    public ServiceCombServiceInstance(MicroserviceInstance microserviceInstance) {
        this.microserviceInstance = microserviceInstance;
        String endpoint = this.microserviceInstance.getEndpoints().stream().filter(e -> e.startsWith("rest://")).findFirst().orElse(null);
        this.uriEndpointObject = endpoint != null ? new URIEndpointObject(endpoint) : null;
    }

    public MicroserviceInstance getMicroserviceInstance() {
        return this.microserviceInstance;
    }

    public String getInstanceId() {
        return this.microserviceInstance.getInstanceId();
    }

    public String getServiceId() {
        return this.microserviceInstance.getServiceName();
    }

    public String getHost() {
        if (this.uriEndpointObject == null) {
            return this.microserviceInstance.getInstanceId();
        }
        return this.uriEndpointObject.getHostOrIp();
    }

    public int getPort() {
        if (this.uriEndpointObject == null) {
            return 0;
        }
        return this.uriEndpointObject.getPort();
    }

    public boolean isSecure() {
        if (this.uriEndpointObject == null) {
            return false;
        }
        return this.uriEndpointObject.isSslEnabled();
    }

    public URI getUri() {
        String scheme = this.getScheme();
        String uri = String.format("%s://%s:%s", scheme, this.uriEndpointObject.getHostOrIp(), this.uriEndpointObject.getPort());
        return URI.create(uri);
    }

    public Map<String, String> getMetadata() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.putAll(this.microserviceInstance.getProperties());
        if (this.microserviceInstance.getStatus() != null) {
            map.put("status", this.microserviceInstance.getStatus().name());
        }
        if (this.microserviceInstance.getDataCenterInfo() != null) {
            map.put("zone", this.microserviceInstance.getDataCenterInfo().getAvailableZone());
        }
        return map;
    }

    public String getScheme() {
        if (this.uriEndpointObject == null) {
            return "http";
        }
        return this.uriEndpointObject.isSslEnabled() ? "https" : "http";
    }
}

