/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.servicecomb.discovery.discovery;

import com.google.common.eventbus.Subscribe;
import com.huaweicloud.common.event.EventManager;
import com.huaweicloud.common.transport.DiscoveryBootstrapProperties;
import com.huaweicloud.common.util.Type;
import com.huaweicloud.servicecomb.discovery.registry.ServiceCombRegistration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.servicecomb.http.client.event.RefreshEndpointEvent;
import org.apache.servicecomb.service.center.client.RegistrationEvents;
import org.apache.servicecomb.service.center.client.ServiceCenterClient;
import org.apache.servicecomb.service.center.client.exception.OperationException;
import org.apache.servicecomb.service.center.client.model.DataCenterInfo;
import org.apache.servicecomb.service.center.client.model.FindMicroserviceInstancesResponse;
import org.apache.servicecomb.service.center.client.model.MicroserviceInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceAddressManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceAddressManager.class);
    private boolean initialized = false;
    private final ServiceCenterClient serviceCenterClient;
    private final MicroserviceInstance myselfInstance;
    private final DiscoveryBootstrapProperties discoveryProperties;
    private DataCenterInfo dataCenterInfo;
    private final String myselfServiceId;

    public ServiceAddressManager(DiscoveryBootstrapProperties discoveryProperties, ServiceCenterClient serviceCenterClient, ServiceCombRegistration serviceCombRegistration) {
        this.discoveryProperties = discoveryProperties;
        this.serviceCenterClient = serviceCenterClient;
        this.myselfInstance = serviceCombRegistration.getMicroserviceInstance();
        this.myselfServiceId = serviceCombRegistration.getMicroservice().getServiceId();
        EventManager.getEventBus().register((Object)this);
    }

    @Subscribe
    public void onHeartBeatEvent(RegistrationEvents.HeartBeatEvent event) {
        if (this.initialized) {
            return;
        }
        if (event.isSuccess() && this.discoveryProperties.isAutoDiscovery()) {
            for (Type type : Type.values()) {
                this.initEndPort(type.name());
            }
        }
    }

    private void initEndPort(String key) {
        Map<String, List<String>> zoneAndRegion;
        List<MicroserviceInstance> instances = this.findServiceInstance("default", key, "latest");
        if ("SERVICECENTER".equals(key) && !instances.isEmpty()) {
            this.initialized = true;
        }
        if ((zoneAndRegion = this.generateZoneAndRegionAddress(instances)) == null) {
            return;
        }
        EventManager.post((Object)new RefreshEndpointEvent(zoneAndRegion, key));
    }

    private Map<String, List<String>> generateZoneAndRegionAddress(List<MicroserviceInstance> instances) {
        if (instances.isEmpty()) {
            return null;
        }
        HashMap<String, List<String>> zoneAndRegion = new HashMap<String, List<String>>();
        this.dataCenterInfo = this.findRegion(instances);
        HashSet sameZone = new HashSet();
        HashSet sameRegion = new HashSet();
        for (MicroserviceInstance microserviceInstance : instances) {
            if (this.regionAndAZMatch(this.dataCenterInfo, microserviceInstance)) {
                sameZone.addAll(microserviceInstance.getEndpoints());
                continue;
            }
            sameRegion.addAll(microserviceInstance.getEndpoints());
        }
        zoneAndRegion.put("sameZone", new ArrayList(sameZone));
        zoneAndRegion.put("sameRegion", new ArrayList(sameRegion));
        return zoneAndRegion;
    }

    private DataCenterInfo findRegion(List<MicroserviceInstance> microserviceInstances) {
        for (MicroserviceInstance microserviceInstance : microserviceInstances) {
            boolean isMatch = ((String)microserviceInstance.getEndpoints().get(0)).contains((CharSequence)this.myselfInstance.getEndpoints().get(0));
            if (!isMatch || microserviceInstance.getDataCenterInfo() == null) continue;
            return microserviceInstance.getDataCenterInfo();
        }
        if (this.myselfInstance.getDataCenterInfo() == null) {
            return null;
        }
        return this.myselfInstance.getDataCenterInfo();
    }

    public List<MicroserviceInstance> findServiceInstance(String appId, String serviceName, String versionRule) {
        try {
            FindMicroserviceInstancesResponse instancesResponse = this.serviceCenterClient.findMicroserviceInstance(this.myselfServiceId, appId, serviceName, versionRule, null);
            return instancesResponse.getMicroserviceInstancesResponse().getInstances();
        }
        catch (OperationException operationException) {
            LOGGER.warn("not find the Microservice instance of {}", (Object)serviceName);
            return new ArrayList<MicroserviceInstance>();
        }
    }

    private boolean regionAndAZMatch(DataCenterInfo myself, MicroserviceInstance target) {
        if (myself == null) {
            return true;
        }
        if (target.getDataCenterInfo() != null) {
            return myself.getRegion().equals(target.getDataCenterInfo().getRegion()) && myself.getAvailableZone().equals(target.getDataCenterInfo().getAvailableZone());
        }
        return false;
    }
}

