/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.servicecomb.discovery.discovery;

import com.google.common.eventbus.Subscribe;
import com.huaweicloud.common.event.EventManager;
import com.huaweicloud.common.transport.DiscoveryBootstrapProperties;
import com.huaweicloud.servicecomb.discovery.client.model.ServiceCombServiceInstance;
import com.huaweicloud.servicecomb.discovery.registry.ServiceCombRegistration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.servicecomb.service.center.client.DiscoveryEvents;
import org.apache.servicecomb.service.center.client.RegistrationEvents;
import org.apache.servicecomb.service.center.client.ServiceCenterClient;
import org.apache.servicecomb.service.center.client.ServiceCenterDiscovery;
import org.apache.servicecomb.service.center.client.exception.OperationException;
import org.apache.servicecomb.service.center.client.model.Microservice;
import org.apache.servicecomb.service.center.client.model.MicroserviceInstanceStatus;
import org.apache.servicecomb.service.center.client.model.MicroservicesResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.event.HeartbeatEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;

public class ServiceCombDiscoveryClient
implements DiscoveryClient,
ApplicationEventPublisherAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceCombDiscoveryClient.class);
    private final ServiceCenterClient serviceCenterClient;
    private final DiscoveryBootstrapProperties discoveryProperties;
    private final ServiceCenterDiscovery serviceCenterDiscovery;
    private final ServiceCombRegistration serviceCombRegistration;
    private ApplicationEventPublisher applicationEventPublisher;
    private final AtomicLong changeId = new AtomicLong(0L);
    private final List<String> serviceIds = new ArrayList<String>();

    public ServiceCombDiscoveryClient(DiscoveryBootstrapProperties discoveryProperties, ServiceCenterClient serviceCenterClient, ServiceCombRegistration serviceCombRegistration) {
        this.discoveryProperties = discoveryProperties;
        this.serviceCenterClient = serviceCenterClient;
        this.serviceCombRegistration = serviceCombRegistration;
        this.serviceCenterDiscovery = new ServiceCenterDiscovery(serviceCenterClient, EventManager.getEventBus());
        this.serviceCenterDiscovery.setPollInterval((long)discoveryProperties.getPollInterval());
        EventManager.getEventBus().register((Object)this);
    }

    @Subscribe
    public void onHeartBeatEvent(RegistrationEvents.HeartBeatEvent event) {
        if (event.isSuccess()) {
            List<String> services;
            this.serviceCenterDiscovery.updateMyselfServiceId(this.serviceCombRegistration.getMicroservice().getServiceId());
            this.serviceCenterDiscovery.startDiscovery();
            if (this.discoveryProperties.isEnableServicePolling() && !this.serviceIds.equals(services = this.getServices())) {
                this.serviceIds.clear();
                this.serviceIds.addAll(services);
                this.applicationEventPublisher.publishEvent((ApplicationEvent)new HeartbeatEvent((Object)this, (Object)this.changeId.getAndIncrement()));
            }
        }
    }

    @Subscribe
    public void onInstanceChangedEvent(DiscoveryEvents.InstanceChangedEvent event) {
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new HeartbeatEvent((Object)this, (Object)this.changeId.getAndIncrement()));
    }

    public String description() {
        return "SerivceComb Discovery";
    }

    private ServiceCenterDiscovery.SubscriptionKey parseMicroserviceName(String serviceId) {
        int idxAt = serviceId.indexOf(".");
        if (idxAt == -1) {
            return new ServiceCenterDiscovery.SubscriptionKey(this.discoveryProperties.getAppName(), serviceId);
        }
        return new ServiceCenterDiscovery.SubscriptionKey(serviceId.substring(0, idxAt), serviceId.substring(idxAt + 1));
    }

    public List<ServiceInstance> getInstances(String serviceId) {
        ServiceCenterDiscovery.SubscriptionKey subscriptionKey = this.parseMicroserviceName(serviceId);
        this.serviceCenterDiscovery.registerIfNotPresent(subscriptionKey);
        List instances = this.serviceCenterDiscovery.getInstanceCache(subscriptionKey);
        if (instances == null) {
            return Collections.emptyList();
        }
        return instances.stream().filter(instance -> !MicroserviceInstanceStatus.DOWN.equals((Object)instance.getStatus())).map(ServiceCombServiceInstance::new).collect(Collectors.toList());
    }

    public List<String> getServices() {
        ArrayList<String> serviceList = new ArrayList<String>();
        try {
            MicroservicesResponse microServiceResponse = this.serviceCenterClient.getMicroserviceList();
            if (microServiceResponse == null || microServiceResponse.getServices() == null) {
                return serviceList;
            }
            for (Microservice microservice : microServiceResponse.getServices()) {
                String validServiceName = this.validMicroserviceName(microservice);
                if (validServiceName == null) continue;
                serviceList.add(validServiceName);
            }
        }
        catch (OperationException e) {
            LOGGER.error("Get services failed", (Throwable)e);
        }
        return serviceList;
    }

    private String validMicroserviceName(Microservice microservice) {
        if (!this.environmentEqual(microservice)) {
            return null;
        }
        if ("default".equals(microservice.getAppId()) && "SERVICECENTER".equals(microservice.getServiceName())) {
            return null;
        }
        if (microservice.getAppId().equals(this.discoveryProperties.getAppName())) {
            return microservice.getServiceName();
        }
        if (Boolean.parseBoolean((String)microservice.getProperties().get("allowCrossApp"))) {
            return microservice.getAppId() + "." + microservice.getServiceName();
        }
        return null;
    }

    private boolean environmentEqual(Microservice microservice) {
        if (StringUtils.isEmpty((String)microservice.getEnvironment()) && StringUtils.isEmpty((String)this.discoveryProperties.getEnvironment())) {
            return true;
        }
        return StringUtils.equals((String)microservice.getEnvironment(), (String)this.discoveryProperties.getEnvironment());
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }
}

