/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.servicecomb.discovery;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.springframework.boot.autoconfigure.condition.AllNestedConditions;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.ConfigurationCondition;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE, ElementType.METHOD})
@Conditional(value={OnServiceCombEnabledCondition.class})
public @interface ConditionalOnServiceCombEnabled {

    public static class OnServiceCombEnabledCondition
    extends AllNestedConditions {
        OnServiceCombEnabledCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnClass(value={OnServiceCombEnabledCondition.class})
        static class FoundClass {
            FoundClass() {
            }
        }

        @ConditionalOnProperty(value={"spring.cloud.servicecomb.discovery.enabled"}, matchIfMissing=true)
        static class FoundProperty {
            FoundProperty() {
            }
        }
    }
}

