/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.servicecomb.discovery.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import com.google.common.hash.Hashing;
import com.huaweicloud.common.cache.RegisterCache;
import com.huaweicloud.common.exception.RemoteOperationException;
import com.huaweicloud.common.exception.RemoteServerUnavailableException;
import com.huaweicloud.common.exception.ServiceCombException;
import com.huaweicloud.common.transport.HttpTransport;
import com.huaweicloud.common.transport.Response;
import com.huaweicloud.common.transport.URLConfig;
import com.huaweicloud.common.util.URLUtil;
import com.huaweicloud.servicecomb.discovery.client.model.HeardBeatStatus;
import com.huaweicloud.servicecomb.discovery.client.model.Microservice;
import com.huaweicloud.servicecomb.discovery.client.model.MicroserviceInstance;
import com.huaweicloud.servicecomb.discovery.client.model.MicroserviceInstanceSingleResponse;
import com.huaweicloud.servicecomb.discovery.client.model.MicroserviceInstancesResponse;
import com.huaweicloud.servicecomb.discovery.client.model.MicroserviceResponse;
import com.huaweicloud.servicecomb.discovery.client.model.SchemaRequest;
import com.huaweicloud.servicecomb.discovery.client.model.SchemaResponse;
import com.huaweicloud.servicecomb.discovery.discovery.MicroserviceCache;
import com.huaweicloud.servicecomb.discovery.discovery.MicroserviceHandler;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.StringEntity;
import org.apache.servicecomb.foundation.common.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.util.StringUtils;

public class ServiceCombClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceCombClient.class);
    private URLConfig registryConfig = new URLConfig();
    public static String INSTANCE_STATUS = "status";
    public static String ZONE = "zone";
    private HttpTransport httpTransport;

    public ServiceCombClient(String urls, HttpTransport httpTransport) {
        this.httpTransport = httpTransport;
        this.registryConfig.addUrl(URLUtil.getEnvServerURL());
        if (this.registryConfig.isEmpty()) {
            this.registryConfig.addUrl(URLUtil.dealMultiUrl((String)urls));
        }
    }

    public void autoDiscovery(boolean autoDiscovery) {
        if (!autoDiscovery) {
            return;
        }
        try {
            MicroserviceInstancesResponse microserviceInstancesResponse = this.getServiceCenterInstances();
            for (MicroserviceInstance microserviceInstance : microserviceInstancesResponse.getInstances()) {
                if (microserviceInstance.getEndpoints() == null) continue;
                this.registryConfig.addUrlAfterDnsResolve(microserviceInstance.getEndpoints().stream().filter(url -> !url.contains("[::]") && url.startsWith("rest")).map(URLUtil::transform).collect(Collectors.toList()));
            }
        }
        catch (RemoteOperationException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public MicroserviceInstancesResponse getServiceCenterInstances() throws RemoteOperationException {
        Response response = new Response();
        try {
            String formatUrl = this.buildURI("/registry/health");
            response = this.httpTransport.sendGetRequest(formatUrl);
            if (response.getStatusCode() == 200) {
                MicroserviceInstancesResponse result = (MicroserviceInstancesResponse)JsonUtils.OBJ_MAPPER.readValue(response.getContent(), MicroserviceInstancesResponse.class);
                LOGGER.info("getServiceCenterInstances result=" + result);
                return result;
            }
            throw new RemoteOperationException("read response failed. status:" + response.getStatusCode() + "; message:" + response.getStatusMessage() + "; content:" + response.getContent());
        }
        catch (URISyntaxException e) {
            throw new RemoteOperationException("build url failed.", (Throwable)e);
        }
        catch (RemoteServerUnavailableException | IOException e) {
            throw new RemoteOperationException("read response failed. " + response, e);
        }
    }

    public String registerMicroservice(Microservice microservice) throws ServiceCombException {
        block5: {
            Response response = null;
            String content = null;
            try {
                ObjectMapper objectMapper = new ObjectMapper();
                objectMapper.configure(SerializationFeature.WRAP_ROOT_VALUE, true);
                content = objectMapper.writeValueAsString((Object)microservice);
                StringEntity stringEntity = new StringEntity(content, "utf-8");
                response = this.httpTransport.sendPostRequest(this.buildURI("/registry/microservices"), (HttpEntity)stringEntity);
                if (response.getStatusCode() == 200) {
                    LOGGER.info(response.getContent());
                    HashMap result = (HashMap)objectMapper.readValue(response.getContent(), HashMap.class);
                    if (null != result) {
                        return (String)result.get("serviceId");
                    }
                    break block5;
                }
                throw new RemoteOperationException("read response failed. status:" + response.getStatusCode() + "; message:" + response.getStatusMessage() + "; content:" + response.getContent());
            }
            catch (URISyntaxException e) {
                throw new RemoteOperationException("build url failed.", (Throwable)e);
            }
            catch (IOException e) {
                throw new RemoteOperationException(response == null ? "read response failed. " : "read response failed. " + response, (Throwable)e);
            }
        }
        return null;
    }

    public String getServiceId(Microservice microservice) throws ServiceCombException {
        Response response = null;
        try {
            String path = this.buildURI("/registry/existence");
            response = this.httpTransport.sendGetRequest(this.addParam2URI(path, "microservice", null, microservice));
            if (response.getStatusCode() == 200) {
                LOGGER.info(response.getContent());
                HashMap result = (HashMap)JsonUtils.OBJ_MAPPER.readValue(response.getContent(), HashMap.class);
                return (String)result.get("serviceId");
            }
            if (response.getStatusCode() == 400) {
                LOGGER.info(response.getContent());
                return null;
            }
            throw new RemoteOperationException("read response failed. status:" + response.getStatusCode() + "; message:" + response.getStatusMessage() + "; content:" + response.getContent());
        }
        catch (URISyntaxException e) {
            throw new RemoteOperationException("build url failed.", (Throwable)e);
        }
        catch (IOException e) {
            throw new RemoteOperationException("read response failed. " + response, (Throwable)e);
        }
    }

    public SchemaResponse getSchemas(String serviceId) throws ServiceCombException {
        Response response = null;
        try {
            response = this.httpTransport.sendGetRequest(this.buildURI("/registry/microservices/" + serviceId + "/schemas"));
            if (response.getStatusCode() == 200) {
                return (SchemaResponse)JsonUtils.OBJ_MAPPER.readValue(response.getContent(), SchemaResponse.class);
            }
            if (response.getStatusCode() == 400) {
                LOGGER.info(response.getContent());
                return null;
            }
            throw new RemoteOperationException("read response failed. status:" + response.getStatusCode() + "; message:" + response.getStatusMessage() + "; content:" + response.getContent());
        }
        catch (URISyntaxException e) {
            throw new RemoteOperationException("build url failed.", (Throwable)e);
        }
        catch (IOException e) {
            throw new RemoteOperationException("read response failed. " + response, (Throwable)e);
        }
    }

    public String registerInstance(MicroserviceInstance microserviceInstance) throws ServiceCombException {
        Response response = null;
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.configure(SerializationFeature.WRAP_ROOT_VALUE, true);
            String content = objectMapper.writeValueAsString((Object)microserviceInstance);
            StringEntity stringEntity = new StringEntity(content, "utf-8");
            String formatUrl = this.buildURI("/registry/microservices/" + microserviceInstance.getServiceId() + "/instances");
            response = this.httpTransport.sendPostRequest(formatUrl, (HttpEntity)stringEntity);
            if (response.getStatusCode() == 200) {
                LOGGER.info(response.getContent());
                HashMap result = (HashMap)objectMapper.readValue(response.getContent(), HashMap.class);
                return (String)result.get("instanceId");
            }
            throw new RemoteOperationException("read response failed. url:" + formatUrl + "status:" + response.getStatusCode() + "; message:" + response.getStatusMessage() + "; content:" + response.getContent());
        }
        catch (URISyntaxException e) {
            throw new RemoteOperationException("build url failed.", (Throwable)e);
        }
        catch (IOException e) {
            throw new RemoteOperationException(response == null ? "read response failed. " : "read response failed. " + response, (Throwable)e);
        }
    }

    public boolean deRegisterInstance(String serviceId, String instanceId) throws ServiceCombException {
        Response response = null;
        try {
            String formatUrl = this.buildURI("/registry/microservices/" + serviceId + "/instances/" + instanceId);
            response = this.httpTransport.sendDeleteRequest(formatUrl);
            if (response.getStatusCode() == 200) {
                LOGGER.info("deRegister success.");
                return true;
            }
            throw new RemoteOperationException("deRegister failed. url:" + formatUrl + "status:" + response.getStatusCode() + "; message:" + response.getStatusMessage() + "; content:" + response.getContent());
        }
        catch (URISyntaxException e) {
            throw new RemoteOperationException("build url failed.", (Throwable)e);
        }
    }

    public List<ServiceInstance> getInstances(Microservice microservice, String revision) {
        ArrayList<ServiceInstance> instanceList = new ArrayList<ServiceInstance>();
        Response response = null;
        try {
            HashMap heades = Maps.newHashMap();
            String CONSUMER_HEADER = "X-ConsumerId";
            heades.put(CONSUMER_HEADER, RegisterCache.getServiceID());
            response = this.httpTransport.sendGetRequest(this.addParam2URI(this.buildURI("/registry/instances"), null, revision, microservice), (Map)heades);
            if (response.getStatusCode() == 200) {
                Microservice result = (Microservice)JsonUtils.OBJ_MAPPER.readValue(response.getContent(), Microservice.class);
                if (result == null || result.getInstances() == null) {
                    return instanceList;
                }
                String REVISION_HEADER = "X-Resource-Revision";
                if (!StringUtils.isEmpty((Object)response.getHeader(REVISION_HEADER))) {
                    MicroserviceHandler.serviceRevision.put(microservice.getServiceName(), response.getHeader(REVISION_HEADER));
                }
                MicroserviceCache.initInsList(result.getInstances(), microservice.getServiceName());
                for (MicroserviceInstance instance : result.getInstances()) {
                    for (String endpoint : instance.getEndpoints()) {
                        if (!endpoint.startsWith("rest://")) continue;
                        URI endpointURIBuilder = new URIBuilder(endpoint).build();
                        int port = endpointURIBuilder.getPort();
                        String host = endpointURIBuilder.getHost();
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put(INSTANCE_STATUS, instance.getStatus().name());
                        if (instance.getDataCenterInfo() != null) {
                            map.put(ZONE, instance.getDataCenterInfo().getZone());
                        }
                        instanceList.add((ServiceInstance)new DefaultServiceInstance(instance.getServiceName(), host, port, false, map));
                    }
                }
                return instanceList;
            }
            if (response.getStatusCode() != 304) {
                LOGGER.debug("read response failed. status:" + response.getStatusCode() + "; message:" + response.getStatusMessage() + "; content:" + response.getContent());
            }
        }
        catch (URISyntaxException e) {
            LOGGER.warn("build url failed.", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.warn("read response failed. " + response);
        }
        catch (RemoteServerUnavailableException e) {
            LOGGER.warn("get instances failed.", (Throwable)e);
        }
        return null;
    }

    public MicroserviceInstanceSingleResponse getInstance(String serviceId, String instanceId) throws ServiceCombException {
        MicroserviceInstanceSingleResponse result = null;
        Response response = null;
        try {
            response = this.httpTransport.sendGetRequest(this.buildURI("/registry/microservices/" + serviceId + "/instances/" + instanceId));
            if (response.getStatusCode() != 200) {
                throw new RemoteOperationException("read response failed. status:" + response.getStatusCode() + "; message:" + response.getStatusMessage() + "; content:" + response.getContent());
            }
            LOGGER.info(response.getContent());
            result = (MicroserviceInstanceSingleResponse)JsonUtils.OBJ_MAPPER.readValue(response.getContent(), MicroserviceInstanceSingleResponse.class);
        }
        catch (URISyntaxException e) {
            throw new RemoteOperationException("build url failed.", (Throwable)e);
        }
        catch (IOException e) {
            throw new RemoteOperationException("read response failed. " + response, (Throwable)e);
        }
        return result;
    }

    public HeardBeatStatus heartbeat(String serviceId, String instanceId) throws ServiceCombException {
        Response response = null;
        try {
            response = this.httpTransport.sendPutRequest(this.buildURI("/registry/microservices/" + serviceId + "/instances/" + instanceId + "/heartbeat"), null);
            if (response.getStatusCode() == 200) {
                LOGGER.debug("heartbeat success.");
                return HeardBeatStatus.SUCCESS;
            }
            if (response.getStatusCode() == 400) {
                LOGGER.error("heartbeat to service center failed. status:" + response.getStatusCode() + "; message:" + response.getStatusMessage() + "; content:" + response.getContent());
                return HeardBeatStatus.FAILED;
            }
            throw new IOException();
        }
        catch (URISyntaxException e) {
            throw new RemoteOperationException("build url failed.", (Throwable)e);
        }
        catch (IOException e) {
            this.toggle();
            throw new RemoteOperationException("read response failed , msg: {} " + response, (Throwable)e);
        }
    }

    public boolean updateInstanceStatus(String serviceId, String instanceId, String status) throws ServiceCombException {
        Response response = null;
        try {
            StringEntity stringEntity = new StringEntity("", "utf-8");
            response = this.httpTransport.sendPutRequest(this.buildURI("/registry/microservices/" + serviceId + "/instances/" + instanceId + "/status?value=" + status), (HttpEntity)stringEntity);
            if (response.getStatusCode() == 200) {
                LOGGER.info(" update instance status success.");
                return true;
            }
            throw new RemoteOperationException("update instance status failed. status:" + response.getStatusCode() + "; message:" + response.getStatusMessage() + "; content:" + response.getContent());
        }
        catch (URISyntaxException e) {
            throw new RemoteOperationException("build url failed.", (Throwable)e);
        }
    }

    public MicroserviceResponse getServices() throws ServiceCombException {
        MicroserviceResponse result = null;
        Response response = null;
        try {
            response = this.httpTransport.sendGetRequest(this.buildURI("/registry/microservices"));
            if (response.getStatusCode() != 200) {
                throw new RemoteOperationException("read response failed. status:" + response.getStatusCode() + "; message:" + response.getStatusMessage() + "; content:" + response.getContent());
            }
            result = (MicroserviceResponse)JsonUtils.OBJ_MAPPER.readValue(response.getContent(), MicroserviceResponse.class);
        }
        catch (URISyntaxException e) {
            throw new RemoteOperationException("build url failed.", (Throwable)e);
        }
        catch (IOException e) {
            throw new RemoteOperationException("read response failed. " + response, (Throwable)e);
        }
        return result;
    }

    public boolean registerSchema(String microserviceId, String schemaId, String schemaContent) throws RemoteOperationException {
        Response response = null;
        SchemaRequest request = new SchemaRequest();
        request.setSchema(schemaContent);
        request.setSummary(ServiceCombClient.calcSchemaSummary(schemaContent));
        try {
            String formatUrl = this.buildURI("/registry/microservices/" + microserviceId + "/schemas/" + schemaId);
            byte[] body = JsonUtils.OBJ_MAPPER.writeValueAsBytes((Object)request);
            ByteArrayEntity byteArrayEntity = new ByteArrayEntity(body);
            response = this.httpTransport.sendPutRequest(formatUrl, (HttpEntity)byteArrayEntity);
            if (response.getStatusCode() == 200) {
                LOGGER.info("register schema {}/{} success.", (Object)microserviceId, (Object)schemaId);
                return true;
            }
            LOGGER.error("Register schema {}/{} failed, code:{} , msg:{} ", new Object[]{microserviceId, schemaId, response.getStatusCode(), response.getContent()});
            return false;
        }
        catch (JsonProcessingException e) {
            LOGGER.error("registerSchema serialization failed : {}", (Object)e.getMessage());
        }
        catch (URISyntaxException e) {
            throw new RemoteOperationException("build url failed.", (Throwable)e);
        }
        catch (RemoteServerUnavailableException e) {
            throw new RemoteOperationException("read response failed. ", (Throwable)e);
        }
        return false;
    }

    public static String calcSchemaSummary(String schemaContent) {
        return Hashing.sha256().newHasher().putString((CharSequence)schemaContent, Charsets.UTF_8).hash().toString();
    }

    private String buildURI(String path) throws URISyntaxException {
        path = this.registryConfig.getUrl() + "/" + "v4" + "/" + "default" + path;
        URIBuilder uriBuilder = new URIBuilder(path);
        return uriBuilder.build().toString();
    }

    private String addParam2URI(String path, String type, String revision, Microservice microservice) throws URISyntaxException {
        URIBuilder uriBuilder = new URIBuilder(path);
        if (null != type) {
            uriBuilder.setParameter("type", type);
        }
        if (null != revision) {
            uriBuilder.setParameter("rev", revision);
        }
        uriBuilder.setParameter("appId", microservice.getAppId());
        uriBuilder.setParameter("serviceName", microservice.getServiceName());
        uriBuilder.setParameter("version", microservice.getVersion());
        uriBuilder.setParameter("env", microservice.getEnvironment());
        return uriBuilder.build().toString();
    }

    public void toggle() {
        this.registryConfig.toggle();
    }

    public String getUrl() {
        return this.registryConfig.getUrl();
    }
}

