/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.servicecomb.discovery.discovery;

import com.huaweicloud.servicecomb.discovery.client.ServiceCombClient;
import com.huaweicloud.servicecomb.discovery.client.model.Framework;
import com.huaweicloud.servicecomb.discovery.client.model.Microservice;
import com.huaweicloud.servicecomb.discovery.client.model.MicroserviceStatus;
import com.huaweicloud.servicecomb.discovery.discovery.ServiceCombDiscoveryProperties;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.cloud.client.ServiceInstance;

public class MicroserviceHandler {
    public static final Map<String, String> serviceRevision = new ConcurrentHashMap<String, String>();
    public static final Map<String, List<ServiceInstance>> discoveryServerList = new ConcurrentHashMap<String, List<ServiceInstance>>();

    public static List<ServiceInstance> getInstances(Microservice microservice, ServiceCombClient serviceCombClient) {
        String revision = "0";
        if (serviceRevision.containsKey(microservice.getServiceName())) {
            revision = serviceRevision.get(microservice.getServiceName());
        }
        List<ServiceInstance> instanceList = serviceCombClient.getInstances(microservice, revision);
        return MicroserviceHandler.getList(instanceList, microservice.getServiceName());
    }

    private static List<ServiceInstance> getList(List<ServiceInstance> instanceList, String serviceName) {
        ArrayList<ServiceInstance> resultList = new ArrayList<ServiceInstance>();
        List cacheList = discoveryServerList.getOrDefault(serviceName, new ArrayList());
        if (instanceList == null) {
            return cacheList;
        }
        if (instanceList.isEmpty()) {
            for (ServiceInstance server : cacheList) {
                try (Socket s = new Socket();){
                    s.connect(new InetSocketAddress(server.getHost(), server.getPort()), 3000);
                }
                catch (IOException e) {
                    continue;
                }
                resultList.add(server);
            }
            return resultList;
        }
        discoveryServerList.put(serviceName, instanceList);
        return instanceList;
    }

    public static Microservice createMicroservice(ServiceCombDiscoveryProperties serviceCombDiscoveryProperties, String serviceName) {
        Microservice microservice = new Microservice();
        microservice.setServiceName(serviceName);
        microservice.setVersion("0.0.0+");
        microservice.setFramework(new Framework());
        if (!serviceCombDiscoveryProperties.isAllowCrossApp()) {
            microservice.setAppId(serviceCombDiscoveryProperties.getAppName());
        }
        microservice.setStatus(MicroserviceStatus.UP);
        return microservice;
    }
}

