/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.servicecomb.discovery.discovery;

import com.huaweicloud.common.exception.ServiceCombException;
import com.huaweicloud.servicecomb.discovery.client.ServiceCombClient;
import com.huaweicloud.servicecomb.discovery.client.model.Microservice;
import com.huaweicloud.servicecomb.discovery.client.model.MicroserviceResponse;
import com.huaweicloud.servicecomb.discovery.discovery.MicroserviceHandler;
import com.huaweicloud.servicecomb.discovery.discovery.ServiceCombDiscoveryProperties;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;

public class ServiceCombDiscoveryClient
implements DiscoveryClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceCombDiscoveryClient.class);
    private ServiceCombClient serviceCombClient;
    private ServiceCombDiscoveryProperties discoveryProperties;

    public ServiceCombDiscoveryClient(ServiceCombDiscoveryProperties discoveryProperties, ServiceCombClient serviceCombClient) {
        this.discoveryProperties = discoveryProperties;
        this.serviceCombClient = serviceCombClient;
    }

    public String description() {
        return "this is servicecomb implement";
    }

    public List<ServiceInstance> getInstances(String serviceId) {
        Microservice microService = MicroserviceHandler.createMicroservice(this.discoveryProperties, serviceId);
        return MicroserviceHandler.getInstances(microService, this.serviceCombClient);
    }

    public List<String> getServices() {
        ArrayList<String> serviceList = new ArrayList<String>();
        try {
            MicroserviceResponse microServiceResponse = this.serviceCombClient.getServices();
            if (microServiceResponse == null || microServiceResponse.getServices() == null) {
                return serviceList;
            }
            for (Microservice microservice : microServiceResponse.getServices()) {
                serviceList.add(microservice.getServiceName());
            }
            return serviceList;
        }
        catch (ServiceCombException e) {
            LOGGER.error("getServices failed", (Throwable)e);
            return serviceList;
        }
    }
}

