/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.servicecomb.discovery.registry;

import com.huaweicloud.common.util.NetUtil;
import com.huaweicloud.servicecomb.discovery.client.model.Framework;
import com.huaweicloud.servicecomb.discovery.client.model.HealthCheck;
import com.huaweicloud.servicecomb.discovery.client.model.HealthCheckMode;
import com.huaweicloud.servicecomb.discovery.client.model.Microservice;
import com.huaweicloud.servicecomb.discovery.client.model.MicroserviceInstance;
import com.huaweicloud.servicecomb.discovery.client.model.MicroserviceStatus;
import com.huaweicloud.servicecomb.discovery.discovery.ServiceCombDiscoveryProperties;
import com.huaweicloud.servicecomb.discovery.registry.ServiceCombRegistration;
import com.huaweicloud.servicecomb.discovery.registry.TagsProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.configuration.EnvironmentConfiguration;
import org.apache.servicecomb.foundation.common.net.NetUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class RegistryHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegistryHandler.class);
    private static final String SERVICE_MAPPING = "SERVICE_MAPPING";
    private static final String VERSION_MAPPING = "VERSION_MAPPING";
    private static final String APP_MAPPING = "APP_MAPPING";
    private static final String CAS_APPLICATION_ID = "CAS_APPLICATION_ID";
    private static final String CAS_COMPONENT_NAME = "CAS_COMPONENT_NAME";
    private static final String CAS_INSTANCE_VERSION = "CAS_INSTANCE_VERSION";
    private static final String CAS_INSTANCE_ID = "CAS_INSTANCE_ID";
    private static final String CAS_ENVIRONMENT_ID = "CAS_ENVIRONMENT_ID";

    public static MicroserviceInstance buildMicroServiceInstances(String serviceID, Microservice microservice, ServiceCombDiscoveryProperties serviceCombDiscoveryProperties, TagsProperties tagsProperties) {
        MicroserviceInstance microserviceInstance = RegistryHandler.buildInstance(serviceID, serviceCombDiscoveryProperties, tagsProperties);
        ArrayList<MicroserviceInstance> instances = new ArrayList<MicroserviceInstance>();
        instances.add(microserviceInstance);
        microservice.setInstances(instances);
        microservice.setStatus(MicroserviceStatus.UP);
        return microserviceInstance;
    }

    private static MicroserviceInstance buildInstance(String serviceID, ServiceCombDiscoveryProperties serviceCombDiscoveryProperties, TagsProperties tagsProperties) {
        MicroserviceInstance microserviceInstance = new MicroserviceInstance();
        microserviceInstance.setServiceId(serviceID);
        microserviceInstance.setHostName(NetUtil.getLocalHost());
        if (null != serviceCombDiscoveryProperties.getDatacenter()) {
            microserviceInstance.setDataCenterInfo(serviceCombDiscoveryProperties.getDatacenter());
        }
        ArrayList<String> endPoints = new ArrayList<String>();
        String address = StringUtils.isEmpty((Object)serviceCombDiscoveryProperties.getServerAddress()) ? NetUtils.getHostAddress() : serviceCombDiscoveryProperties.getServerAddress();
        endPoints.add("rest://" + address + ":" + serviceCombDiscoveryProperties.getPort());
        microserviceInstance.setEndpoints(endPoints);
        HealthCheck healthCheck = new HealthCheck();
        healthCheck.setMode(HealthCheckMode.HEARTBEAT);
        healthCheck.setInterval(serviceCombDiscoveryProperties.getHealthCheckInterval());
        healthCheck.setTimes(3);
        microserviceInstance.setHealthCheck(healthCheck);
        String currTime = String.valueOf(System.currentTimeMillis());
        microserviceInstance.setTimestamp(currTime);
        microserviceInstance.setModTimestamp(currTime);
        EnvironmentConfiguration envConfig = new EnvironmentConfiguration();
        if (!StringUtils.isEmpty((Object)envConfig.getString(VERSION_MAPPING)) && !StringUtils.isEmpty((Object)envConfig.getString(envConfig.getString(VERSION_MAPPING)))) {
            microserviceInstance.setVersion(envConfig.getString(VERSION_MAPPING));
        } else {
            microserviceInstance.setVersion(serviceCombDiscoveryProperties.getVersion());
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        if (tagsProperties.getTag() != null) {
            properties.putAll(tagsProperties.getTag());
        }
        properties.putAll(RegistryHandler.genCasProperties());
        microserviceInstance.setProperties(properties);
        return microserviceInstance;
    }

    public static Microservice buildMicroservice(ServiceCombRegistration registration) {
        Microservice microservice = new Microservice();
        EnvironmentConfiguration envConfig = new EnvironmentConfiguration();
        if (!StringUtils.isEmpty((Object)envConfig.getString(APP_MAPPING)) && !StringUtils.isEmpty((Object)envConfig.getString(envConfig.getString(APP_MAPPING)))) {
            microservice.setAppId(envConfig.getString(envConfig.getString(APP_MAPPING)));
        } else {
            microservice.setAppId(registration.getAppName());
        }
        if (!StringUtils.isEmpty((Object)envConfig.getString(SERVICE_MAPPING)) && !StringUtils.isEmpty((Object)envConfig.getString(envConfig.getString(SERVICE_MAPPING)))) {
            microservice.setServiceName(envConfig.getString(envConfig.getString(SERVICE_MAPPING)));
        } else {
            microservice.setServiceName(registration.getServiceId());
        }
        if (!StringUtils.isEmpty((Object)envConfig.getString(VERSION_MAPPING)) && !StringUtils.isEmpty((Object)envConfig.getString(envConfig.getString(VERSION_MAPPING)))) {
            microservice.setVersion(envConfig.getString(envConfig.getString(VERSION_MAPPING)));
        } else {
            microservice.setVersion(registration.getVersion());
        }
        microservice.setFramework(new Framework());
        microservice.setEnvironment(registration.getEnvironment());
        return microservice;
    }

    public static Map<String, String> genCasProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        EnvironmentConfiguration envConfig = new EnvironmentConfiguration();
        if (!StringUtils.isEmpty((Object)envConfig.getString(CAS_APPLICATION_ID))) {
            properties.put(CAS_APPLICATION_ID, envConfig.getString(CAS_APPLICATION_ID));
        }
        if (!StringUtils.isEmpty((Object)envConfig.getString(CAS_COMPONENT_NAME))) {
            properties.put(CAS_COMPONENT_NAME, envConfig.getString(CAS_COMPONENT_NAME));
        }
        if (!StringUtils.isEmpty((Object)envConfig.getString(CAS_INSTANCE_VERSION))) {
            properties.put(CAS_INSTANCE_VERSION, envConfig.getString(CAS_INSTANCE_VERSION));
        }
        if (!StringUtils.isEmpty((Object)envConfig.getString(CAS_INSTANCE_ID))) {
            properties.put(CAS_INSTANCE_ID, envConfig.getString(CAS_INSTANCE_ID));
        }
        if (!StringUtils.isEmpty((Object)envConfig.getString(CAS_ENVIRONMENT_ID))) {
            properties.put(CAS_ENVIRONMENT_ID, envConfig.getString(CAS_ENVIRONMENT_ID));
        }
        return properties;
    }
}

