/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.servicecomb.discovery.registry;

import com.huaweicloud.common.transport.ServiceCombSSLProperties;
import com.huaweicloud.servicecomb.discovery.ConditionalOnServiceCombEnabled;
import com.huaweicloud.servicecomb.discovery.client.ServiceCombClient;
import com.huaweicloud.servicecomb.discovery.discovery.ServiceCombDiscoveryProperties;
import com.huaweicloud.servicecomb.discovery.event.ServiceCombEventBus;
import com.huaweicloud.servicecomb.discovery.registry.HeartbeatScheduler;
import com.huaweicloud.servicecomb.discovery.registry.ServiceCombAutoServiceRegistration;
import com.huaweicloud.servicecomb.discovery.registry.ServiceCombRegistration;
import com.huaweicloud.servicecomb.discovery.registry.ServiceCombServiceRegistry;
import com.huaweicloud.servicecomb.discovery.registry.ServiceCombWatcher;
import com.huaweicloud.servicecomb.discovery.registry.TagsProperties;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.serviceregistry.AutoServiceRegistrationAutoConfiguration;
import org.springframework.cloud.client.serviceregistry.AutoServiceRegistrationConfiguration;
import org.springframework.cloud.client.serviceregistry.AutoServiceRegistrationProperties;
import org.springframework.cloud.client.serviceregistry.ServiceRegistryAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"spring.cloud.servicecomb.discovery.enabled"}, matchIfMissing=true)
@ConditionalOnServiceCombEnabled
@EnableConfigurationProperties
@AutoConfigureBefore(value={ServiceRegistryAutoConfiguration.class})
@AutoConfigureAfter(value={AutoServiceRegistrationConfiguration.class, AutoServiceRegistrationAutoConfiguration.class})
public class ServiceCombRegistryAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public HeartbeatScheduler heartbeatScheduler(ServiceCombDiscoveryProperties serviceCombDiscoveryProperties, ServiceCombClient serviceCombClient, TagsProperties tagsProperties) {
        return new HeartbeatScheduler(serviceCombDiscoveryProperties, serviceCombClient);
    }

    @Bean
    public ServiceCombServiceRegistry serviceCombServiceRegistry(ServiceCombClient serviceCombClient, HeartbeatScheduler heartbeatScheduler, ServiceCombDiscoveryProperties serviceCombDiscoveryProperties, ServiceCombWatcher serviceCombWatcher, TagsProperties tagsProperties) {
        return new ServiceCombServiceRegistry(serviceCombClient, heartbeatScheduler, serviceCombDiscoveryProperties, serviceCombWatcher, tagsProperties);
    }

    @Bean
    @ConditionalOnBean(value={AutoServiceRegistrationProperties.class})
    public ServiceCombRegistration serviceCombRegistration(ServiceCombDiscoveryProperties serviceCombDiscoveryProperties) {
        return new ServiceCombRegistration(serviceCombDiscoveryProperties);
    }

    @Bean
    @ConditionalOnBean(value={AutoServiceRegistrationProperties.class})
    public ServiceCombAutoServiceRegistration serviceCombAutoServiceRegistration(ServiceCombServiceRegistry registry, AutoServiceRegistrationProperties autoServiceRegistrationProperties, ServiceCombRegistration registration) {
        return new ServiceCombAutoServiceRegistration(registry, autoServiceRegistrationProperties, registration);
    }

    @Bean
    public ServiceCombEventBus serviceCombEventBus() {
        return new ServiceCombEventBus();
    }

    @Bean
    public ServiceCombWatcher serviceCombWatcher(ServiceCombEventBus eventBus, ServiceCombSSLProperties serviceCombSSLProperties, ServiceCombDiscoveryProperties serviceCombDiscoveryProperties) {
        return new ServiceCombWatcher(eventBus, serviceCombSSLProperties, serviceCombDiscoveryProperties);
    }
}

