/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.servicecomb.discovery.ribbon;

import com.huaweicloud.servicecomb.discovery.client.ServiceCombClient;
import com.huaweicloud.servicecomb.discovery.discovery.ServiceCombDiscoveryProperties;
import com.huaweicloud.servicecomb.discovery.event.ServiceCombEventBus;
import com.huaweicloud.servicecomb.discovery.ribbon.ServiceCombIPing;
import com.huaweicloud.servicecomb.discovery.ribbon.ServiceCombServerList;
import com.huaweicloud.servicecomb.discovery.ribbon.ServiceCombServerListUpdater;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.IPing;
import com.netflix.loadbalancer.ServerList;
import com.netflix.loadbalancer.ServerListUpdater;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ServiceCombRibbonClientConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public ServerList<?> ribbonServerList(IClientConfig config, ServiceCombDiscoveryProperties serviceCombProperties, ServiceCombClient serviceCombClient) {
        ServiceCombServerList serverList = new ServiceCombServerList(serviceCombProperties, serviceCombClient);
        serverList.initWithNiwsConfig(config);
        return serverList;
    }

    @Bean
    @ConditionalOnProperty(value={"spring.cloud.servicecomb.discovery.ping"})
    public IPing ping() {
        return new ServiceCombIPing();
    }

    @Bean
    public ServerListUpdater serviceCombServerListUpdater(ServiceCombEventBus eventBus) {
        return new ServiceCombServerListUpdater(eventBus);
    }
}

