/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.servicecomb.discovery.ribbon;

import com.huaweicloud.servicecomb.discovery.event.ServerListRefreshEvent;
import com.huaweicloud.servicecomb.discovery.event.ServiceCombEventBus;
import com.netflix.loadbalancer.PollingServerListUpdater;
import com.netflix.loadbalancer.ServerListUpdater;
import java.util.Date;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceCombServerListUpdater
extends PollingServerListUpdater {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceCombServerListUpdater.class);
    private final AtomicBoolean isActive = new AtomicBoolean(false);
    private final AtomicLong lastUpdated = new AtomicLong(System.currentTimeMillis());
    private ScheduledExecutorService refreshExecutor = Executors.newScheduledThreadPool(1, r -> {
        Thread thread = new Thread(r);
        thread.setName("com.huaweicloud.servercenter.watch.refresh");
        thread.setDaemon(true);
        return thread;
    });
    private ServiceCombEventBus eventBus;

    public ServiceCombServerListUpdater(ServiceCombEventBus eventBus) {
        this.eventBus = eventBus;
    }

    public void start(ServerListUpdater.UpdateAction updateAction) {
        super.start(updateAction);
        if (this.isActive.compareAndSet(false, true)) {
            this.eventBus.register(event -> {
                if (!(event instanceof ServerListRefreshEvent)) {
                    return;
                }
                if (!this.refreshExecutor.isShutdown()) {
                    try {
                        this.refreshExecutor.submit(() -> {
                            try {
                                updateAction.doUpdate();
                                this.lastUpdated.set(System.currentTimeMillis());
                            }
                            catch (Exception e) {
                                LOGGER.warn("failed to update serverList", (Throwable)e);
                            }
                        });
                    }
                    catch (Exception e) {
                        LOGGER.error("error submitting watch task to executor", (Throwable)e);
                    }
                }
            });
        }
    }

    public void stop() {
        super.stop();
        if (this.isActive.compareAndSet(true, false)) {
            this.refreshExecutor.shutdown();
        } else {
            LOGGER.info("Not active, no-op");
        }
    }

    public String getLastUpdate() {
        Date watchTime;
        Date pullTime = new Date(super.getLastUpdate());
        return pullTime.after(watchTime = new Date(this.lastUpdated.get())) ? pullTime.toString() : watchTime.toString();
    }

    public long getDurationSinceLastUpdateMs() {
        return super.getDurationSinceLastUpdateMs();
    }

    public int getNumberMissedCycles() {
        return super.getNumberMissedCycles();
    }

    public int getCoreThreads() {
        return super.getCoreThreads();
    }
}

