/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.common.util;

import com.ibatis.common.util.PaginatedList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class PaginatedArrayList
implements PaginatedList {
    private static final ArrayList EMPTY_LIST = new ArrayList(0);
    private List list;
    private List page;
    private int pageSize;
    private int index;

    public PaginatedArrayList(int pageSize) {
        this.pageSize = pageSize;
        this.index = 0;
        this.list = new ArrayList();
        this.repaginate();
    }

    public PaginatedArrayList(int initialCapacity, int pageSize) {
        this.pageSize = pageSize;
        this.index = 0;
        this.list = new ArrayList(initialCapacity);
        this.repaginate();
    }

    public PaginatedArrayList(Collection c, int pageSize) {
        this.pageSize = pageSize;
        this.index = 0;
        this.list = new ArrayList(c);
        this.repaginate();
    }

    private void repaginate() {
        if (this.list.isEmpty()) {
            this.page = EMPTY_LIST;
        } else {
            int start = this.index * this.pageSize;
            int end = start + this.pageSize - 1;
            if (end >= this.list.size()) {
                end = this.list.size() - 1;
            }
            if (start >= this.list.size()) {
                this.index = 0;
                this.repaginate();
            } else if (start < 0) {
                this.index = this.list.size() / this.pageSize;
                if (this.list.size() % this.pageSize == 0) {
                    --this.index;
                }
                this.repaginate();
            } else {
                this.page = this.list.subList(start, end + 1);
            }
        }
    }

    public int size() {
        return this.page.size();
    }

    public boolean isEmpty() {
        return this.page.isEmpty();
    }

    public boolean contains(Object o) {
        return this.page.contains(o);
    }

    public Iterator iterator() {
        return this.page.iterator();
    }

    public Object[] toArray() {
        return this.page.toArray();
    }

    public Object[] toArray(Object[] a) {
        return this.page.toArray(a);
    }

    public boolean containsAll(Collection c) {
        return this.page.containsAll(c);
    }

    public Object get(int index) {
        return this.page.get(index);
    }

    public int indexOf(Object o) {
        return this.page.indexOf(o);
    }

    public int lastIndexOf(Object o) {
        return this.page.lastIndexOf(o);
    }

    public ListIterator listIterator() {
        return this.page.listIterator();
    }

    public ListIterator listIterator(int index) {
        return this.page.listIterator(index);
    }

    public List subList(int fromIndex, int toIndex) {
        return this.page.subList(fromIndex, toIndex);
    }

    public boolean add(Object o) {
        boolean b = this.list.add(o);
        this.repaginate();
        return b;
    }

    public boolean remove(Object o) {
        boolean b = this.list.remove(o);
        this.repaginate();
        return b;
    }

    public boolean addAll(Collection c) {
        boolean b = this.list.addAll(c);
        this.repaginate();
        return b;
    }

    public boolean addAll(int index, Collection c) {
        boolean b = this.list.addAll(index, c);
        this.repaginate();
        return b;
    }

    public boolean removeAll(Collection c) {
        boolean b = this.list.removeAll(c);
        this.repaginate();
        return b;
    }

    public boolean retainAll(Collection c) {
        boolean b = this.list.retainAll(c);
        this.repaginate();
        return b;
    }

    public void clear() {
        this.list.clear();
        this.repaginate();
    }

    public Object set(int index, Object element) {
        Object o = this.list.set(index, element);
        this.repaginate();
        return o;
    }

    public void add(int index, Object element) {
        this.list.add(index, element);
        this.repaginate();
    }

    public Object remove(int index) {
        Object o = this.list.remove(index);
        this.repaginate();
        return o;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public boolean isFirstPage() {
        return this.index == 0;
    }

    public boolean isMiddlePage() {
        return !this.isFirstPage() && !this.isLastPage();
    }

    public boolean isLastPage() {
        return this.list.size() - (this.index + 1) * this.pageSize < 1;
    }

    public boolean isNextPageAvailable() {
        return !this.isLastPage();
    }

    public boolean isPreviousPageAvailable() {
        return !this.isFirstPage();
    }

    public boolean nextPage() {
        if (this.isNextPageAvailable()) {
            ++this.index;
            this.repaginate();
            return true;
        }
        return false;
    }

    public boolean previousPage() {
        if (this.isPreviousPageAvailable()) {
            --this.index;
            this.repaginate();
            return true;
        }
        return false;
    }

    public void gotoPage(int pageNumber) {
        this.index = pageNumber;
        this.repaginate();
    }

    public int getPageIndex() {
        return this.index;
    }
}

