/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.resource;

import java.net.URL;
import java.util.Map;
import org.beetl.core.GroupTemplate;
import org.beetl.core.Resource;
import org.beetl.core.ResourceLoader;
import org.beetl.core.misc.BeetlUtil;
import org.beetl.core.resource.ClasspathResource;

public class ClasspathResourceLoader
implements ResourceLoader {
    private String root = null;
    boolean autoCheck = false;
    protected String charset = "UTF-8";
    String functionRoot = "functions";
    GroupTemplate gt = null;
    String functionSuffix = "fn";
    ClassLoader classLoader = null;

    public ClasspathResourceLoader() {
        this.classLoader = this.getClass().getClassLoader();
        this.root = "";
    }

    public ClasspathResourceLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.root = "";
    }

    public ClasspathResourceLoader(ClassLoader classLoader, String root) {
        this.classLoader = classLoader;
        this.root = this.checkRoot(root);
    }

    public ClasspathResourceLoader(ClassLoader classLoader, String root, String charset) {
        this(classLoader, root);
        this.charset = charset;
    }

    public ClasspathResourceLoader(String root) {
        this();
        this.root = this.checkRoot(root);
    }

    public ClasspathResourceLoader(String root, String charset) {
        this(root);
        this.charset = charset;
    }

    @Override
    public Resource getResource(String key) {
        ClasspathResource resource = new ClasspathResource(key, this.getChildPath(this.root, key), this);
        return resource;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean isModified(Resource key) {
        if (this.autoCheck) {
            return key.isModified();
        }
        return false;
    }

    public boolean isAutoCheck() {
        return this.autoCheck;
    }

    public void setAutoCheck(boolean autoCheck) {
        this.autoCheck = autoCheck;
    }

    public String getRoot() {
        return this.root;
    }

    @Override
    public void init(GroupTemplate gt) {
        Map<String, String> resourceMap = gt.getConf().getResourceMap();
        if (resourceMap.get("root") != null) {
            String temp = resourceMap.get("root");
            temp = this.checkRoot(temp);
            this.root = this.getChildPath(this.root, temp);
        }
        if (this.charset == null) {
            this.charset = resourceMap.get("charset");
        }
        this.functionSuffix = resourceMap.get("functionSuffix");
        this.autoCheck = Boolean.parseBoolean(resourceMap.get("autoCheck"));
        this.functionRoot = resourceMap.get("functionRoot");
    }

    @Override
    public boolean exist(String key) {
        String path = this.getChildPath(this.root, key);
        URL url = this.classLoader.getResource(path);
        if (url == null) {
            url = this.classLoader.getClass().getResource(path);
        }
        return url != null;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    @Override
    public String getResourceId(Resource resource, String id) {
        if (resource == null) {
            return id;
        }
        return BeetlUtil.getRelPath(resource.getId(), id);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public String getInfo() {
        return "ClassLoader:" + this.classLoader + " Path:" + this.root;
    }

    protected String checkRoot(String path) {
        if (path == null || path.length() == 0 || path.equals("/")) {
            return "";
        }
        if (path.endsWith("/")) {
            return path.substring(0, path.length() - 1);
        }
        if (path.startsWith("/")) {
            return path.substring(1, path.length());
        }
        return path;
    }

    protected String getChildPath(String path, String child) {
        if (child.length() == 0) {
            return path;
        }
        if (child.startsWith("/")) {
            return path + child;
        }
        return path + "/" + child;
    }
}

