/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.text;

import java.util.Map;
import java.util.Stack;
import org.beetl.core.exception.BeetlException;
import org.beetl.core.exception.HTMLTagParserException;
import org.beetl.core.statement.GrammarToken;
import org.beetl.core.text.Fragment;
import org.beetl.core.text.HTMLTagContentParser;
import org.beetl.core.text.ScriptFragment;
import org.beetl.core.text.Source;

public class HtmlTagStartFragment
extends ScriptFragment {
    HTMLTagContentParser html = null;
    boolean appendCr = false;

    public HtmlTagStartFragment(Source source) {
        super(source);
    }

    @Override
    public StringBuilder getScript() {
        String tagName = null;
        Stack<String> htmlTagStack = this.source.htmlTagConfig.htmlTagStack;
        try {
            if (this.html.hasVarBinding && this.html.hasExportBinding) {
                throw new RuntimeException("\u4e0d\u80fd\u540c\u65f6\u6709var \u548c export \uff0c\u53ea\u80fd\u9009\u4e00\u4e2a");
            }
            if (this.html.hasVarBinding) {
                this.script.append("htmltagvar");
            } else if (this.html.hasExportBinding) {
                this.script.append("htmltagexport");
            } else {
                this.script.append("htmltag");
            }
            tagName = this.html.getTagName();
            this.script.append("('").append(tagName).append("',");
            Map<String, String> map = this.html.getExpMap();
            Map<String, Character> quat = this.html.getQuatMap();
            if (map.size() != 0) {
                this.script.append("{");
            }
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (this.html.crKey.contains(key)) {
                    this.script.append('\n');
                }
                this.script.append("\"" + key + "\"").append(":");
                String attrValue = this.parseAttr(quat.get(key).charValue(), value);
                this.script.append(attrValue);
                this.script.append(",");
            }
            if (map.size() != 0) {
                this.script.append(this.html.getHtmlColMapAsString());
                this.script.append("}");
            } else {
                this.script.setLength(this.script.length() - 1);
            }
            if (this.html.hasVarBinding || this.html.hasExportBinding) {
                if (map.size() == 0) {
                    this.script.append(",{}");
                }
                if (this.html.varBidingStr.trim().length() == 0) {
                    String defaultVarName = null;
                    int index = tagName.lastIndexOf(":");
                    defaultVarName = index == -1 ? tagName : tagName.substring(index + 1);
                    this.script.append(",").append("'").append(defaultVarName).append("'");
                } else {
                    this.script.append(",").append("'").append(this.html.varBidingStr).append("'");
                }
            }
            this.script.append("){");
            if (this.html.isEmptyTag()) {
                this.script.append("}");
            } else {
                htmlTagStack.push(tagName);
            }
            if (this.appendCr) {
                this.script.append('\n');
            }
            return this.script;
        }
        catch (RuntimeException re) {
            if (tagName == null) {
                tagName = "\u672a\u77e5\u6807\u7b7e";
            }
            GrammarToken token = GrammarToken.createToken(tagName, this.startLine + 1);
            HTMLTagParserException ex = new HTMLTagParserException(re.getMessage());
            ex.pushToken(token);
            ex.line = this.source.curLine + 1;
            throw ex;
        }
    }

    @Override
    public Fragment consumeAndReturnNext() {
        String htmlTagBindingAttribute = this.source.htmlTagConfig.htmlTagBindingAttribute;
        this.html = new HTMLTagContentParser(this.source.getParser().attributeNameConvert, this.source.cs, this.source.p, htmlTagBindingAttribute, true);
        try {
            this.html.parser();
        }
        catch (RuntimeException ex) {
            BeetlException exception = new BeetlException("PARSER_HTML_TAG_ERROR", ex.getMessage(), ex);
            String tagName = "<>";
            if (this.html.tagName != null) {
                tagName = "<" + this.html.tagName + ">";
            }
            GrammarToken grammarToken = GrammarToken.createToken(tagName, this.source.curLine + 1);
            exception.pushToken(grammarToken);
            throw exception;
        }
        this.source.move(this.html.index);
        this.endLine = this.startLine + this.html.crKey.size();
        return super.findNext();
    }

    public String parseAttr(char q, String attr) {
        String phStart = this.source.htmlTagConfig.phStart;
        String phEnd = this.source.htmlTagConfig.phEnd;
        StringBuilder sb = new StringBuilder(attr.length() + 10);
        int start = 0;
        int end = 0;
        int index = -1;
        while ((index = attr.indexOf(phStart, start)) != -1) {
            int holdStart = index;
            while ((end = attr.indexOf(phEnd, holdStart)) != -1 && attr.charAt(end - 1) == '\\') {
                holdStart = end + 1;
            }
            if (end == -1) {
                throw new RuntimeException(attr + " \u6807\u7b7e\u5c5e\u6027\u9519\u8bef\uff0c\u6709\u7ad9\u4f4d\u7b26\u53f7\uff0c\u4f46\u627e\u4e0d\u5230\u5230\u7ed3\u675f\u7b26\u53f7");
            }
            if (index != 0) {
                sb.append(q).append(attr.substring(start, index)).append(q).append("+");
            }
            String value = attr.substring(index + phStart.length(), end);
            value = value.replace("\\}", "}");
            sb.append("(").append(value).append(")").append("+");
            start = end + phEnd.length();
        }
        if (start == 0) {
            return sb.append(q).append(attr).append(q).toString();
        }
        if (start != attr.length()) {
            sb.append(q).append(attr.substring(start, attr.length())).append(q);
        } else {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    @Override
    public void appendCr() {
        this.appendCr = true;
    }
}

