/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.om.asm;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.beetl.core.exception.BeetlException;
import org.beetl.core.om.asm.ClassDescription;
import org.beetl.core.om.asm.FieldDescription;
import org.beetl.core.om.asm.MethodDescription;
import org.beetl.ow2.asm.ClassReader;
import org.beetl.ow2.asm.Type;
import org.beetl.ow2.asm.tree.ClassNode;
import org.beetl.ow2.asm.tree.FieldNode;

final class BeanEnhanceUtils {
    private static Set<String> ignoreSet = new HashSet<String>();

    private BeanEnhanceUtils() {
    }

    static ClassDescription getClassDescription(Class<?> beanClass, boolean usePropertyDescriptor) {
        ClassDescription classDescription = new ClassDescription();
        InputStream in = null;
        try {
            BeanEnhanceUtils.setPropertyDescriptors(classDescription, beanClass);
            if (usePropertyDescriptor) {
                BeanEnhanceUtils.buildFieldDescMapByProperty(classDescription);
            } else {
                in = beanClass.getClassLoader().getResourceAsStream(BeanEnhanceUtils.getInternalName(beanClass.getName()) + ".class");
                ClassReader reader = new ClassReader(in);
                ClassNode cn = new ClassNode();
                reader.accept(cn, 0);
                BeanEnhanceUtils.buildFieldDescMapByAsm(classDescription, cn);
            }
            classDescription.target = beanClass;
            classDescription.generalGetMethodDesc = BeanEnhanceUtils.getGeneralGetMethodDescription(beanClass);
            classDescription.hasField = !classDescription.fieldDescMap.isEmpty();
        }
        catch (IntrospectionException | IOException e) {
            throw new BeetlException("ERROR", "ASM\u589e\u5f3a\u529f\u80fd\uff0c\u751f\u6210\u7c7b:" + beanClass.getName() + "\u65f6\u53d1\u751f\u9519\u8bef", e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
        return classDescription;
    }

    private static void setPropertyDescriptors(ClassDescription classDescription, Class<?> beanClass) throws IntrospectionException {
        PropertyDescriptor[] propDescriptors = Introspector.getBeanInfo(beanClass).getPropertyDescriptors();
        ArrayList<PropertyDescriptor> propList = new ArrayList<PropertyDescriptor>(propDescriptors.length);
        propList.addAll(Arrays.asList(propDescriptors));
        classDescription.propertyDescriptors = propList;
    }

    private static void buildFieldDescMapByProperty(ClassDescription classDescription) {
        List<PropertyDescriptor> propList = classDescription.propertyDescriptors;
        ArrayList<FieldDescription> fieldDescs = new ArrayList<FieldDescription>(propList.size() << 1);
        for (PropertyDescriptor prop : propList) {
            Method curPropReadMethod = prop.getReadMethod();
            if (curPropReadMethod == null || ignoreSet.contains(curPropReadMethod.getName())) continue;
            fieldDescs.add(new FieldDescription(prop.getName(), Type.getType(curPropReadMethod.getReturnType()).toString(), curPropReadMethod.getName(), BeanEnhanceUtils.getMethodDesc(curPropReadMethod)));
            if (prop.getPropertyType() != Boolean.class && prop.getPropertyType() != Boolean.TYPE) continue;
            fieldDescs.add(new FieldDescription(curPropReadMethod.getName(), Type.getType(curPropReadMethod.getReturnType()).toString(), curPropReadMethod.getName(), BeanEnhanceUtils.getMethodDesc(curPropReadMethod)));
        }
        BeanEnhanceUtils.buildFieldDescMap(classDescription, fieldDescs);
    }

    private static void buildFieldDescMap(ClassDescription classDescription, List<FieldDescription> allFieldDescs) {
        allFieldDescs.sort(Comparator.comparingInt(p -> p.name.hashCode()));
        LinkedHashMap<Integer, List<FieldDescription>> filedDescMap = new LinkedHashMap<Integer, List<FieldDescription>>();
        int hashCode = 0;
        ArrayList<FieldDescription> filedDescs = null;
        for (FieldDescription fieldDesc : allFieldDescs) {
            hashCode = fieldDesc.name.hashCode();
            filedDescs = (ArrayList<FieldDescription>)filedDescMap.get(hashCode);
            if (filedDescs == null) {
                filedDescs = new ArrayList<FieldDescription>();
            }
            filedDescs.add(fieldDesc);
            filedDescMap.put(hashCode, filedDescs);
        }
        classDescription.fieldDescMap = filedDescMap;
    }

    private static String getMethodDesc(Method readMethod) {
        String descriptor = Type.getMethodDescriptor(readMethod);
        return descriptor.substring(descriptor.indexOf(40));
    }

    private static void buildFieldDescMapByAsm(ClassDescription classDescription, ClassNode cn) {
        List<FieldNode> fieldList = cn.fields;
        List<FieldDescription> allFiledDescs = BeanEnhanceUtils.convertFieldNodeToFieldDesc(classDescription, fieldList);
        BeanEnhanceUtils.buildFieldDescMap(classDescription, allFiledDescs);
    }

    private static List<FieldDescription> convertFieldNodeToFieldDesc(ClassDescription classDescription, List<FieldNode> fieldList) {
        ArrayList<FieldDescription> fieldDescs = new ArrayList<FieldDescription>(fieldList.size() * 2);
        FieldDescription filedDesc = null;
        for (FieldNode fieldNode : fieldList) {
            filedDesc = new FieldDescription(fieldNode.name, fieldNode.desc, BeanEnhanceUtils.createGetterMethodName(classDescription, fieldNode.name), "()" + fieldNode.desc);
            fieldDescs.add(filedDesc);
            if (!"Z".equals(filedDesc.desc) || !filedDesc.name.startsWith("is")) continue;
            fieldDescs.add(BeanEnhanceUtils.getBooleanFieldDescription(filedDesc));
        }
        return fieldDescs;
    }

    private static FieldDescription getBooleanFieldDescription(FieldDescription curFiledDesc) {
        FieldDescription booleanDesc = new FieldDescription();
        String name = curFiledDesc.name.substring(2);
        booleanDesc.name = name.substring(0, 1).toLowerCase() + name.substring(1);
        booleanDesc.desc = curFiledDesc.desc;
        booleanDesc.readMethodName = curFiledDesc.readMethodName;
        booleanDesc.readMethodDesc = curFiledDesc.readMethodDesc;
        return booleanDesc;
    }

    private static MethodDescription getGeneralGetMethodDescription(Class<?> target) {
        MethodDescription md = new MethodDescription();
        md.name = "get";
        try {
            Method getMethod = target.getMethod(md.name, Object.class);
            md.parameterInternalName = "java/lang/Object";
            md.desc = BeanEnhanceUtils.getMethodDesc(getMethod);
            md.returnTypeInternalName = BeanEnhanceUtils.getInternalName(getMethod.getReturnType().getName());
            return md;
        }
        catch (Exception getMethod) {
            try {
                Method getMethod2 = target.getMethod(md.name, String.class);
                md.parameterInternalName = "java/lang/String";
                md.desc = BeanEnhanceUtils.getMethodDesc(getMethod2);
                md.returnTypeInternalName = BeanEnhanceUtils.getInternalName(getMethod2.getReturnType().getName());
                return md;
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    private static String createGetterMethodName(ClassDescription classDescription, String propertyName) {
        for (PropertyDescriptor ps : classDescription.propertyDescriptors) {
            if (ps.getName().equals(propertyName)) {
                return ps.getReadMethod().getName();
            }
            if (!propertyName.startsWith("is") || !ps.getReadMethod().getName().equals(propertyName)) continue;
            return ps.getReadMethod().getName();
        }
        throw new IllegalStateException("\u627e\u4e0d\u5230Getter\u65b9\u6cd5 " + propertyName);
    }

    static String getSimpleClassName(String className) {
        return className.substring(className.lastIndexOf(".") + 1);
    }

    static String getInternalName(String className) {
        return className.replace('.', '/');
    }

    static int[] convertIntegerToPrimitiveType(Integer[] source) {
        int[] target = new int[source.length];
        for (int i = 0; i < source.length; ++i) {
            target[i] = source[i];
        }
        return target;
    }

    static {
        ignoreSet.add("getClass");
    }
}

