/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.internal.core;

import com.ibm.db2.cmx.internal.core.CMXConnection;
import com.ibm.db2.cmx.internal.core.CMXConnectionEventListener;
import com.ibm.db2.cmx.internal.core.Constants;
import com.ibm.db2.cmx.internal.core.CoreProcessor;
import com.ibm.db2.cmx.internal.core.Message;
import com.ibm.db2.cmx.internal.core.MessageReader;
import com.ibm.db2.cmx.internal.core.Processor;
import com.ibm.db2.cmx.internal.core.Request;
import com.ibm.db2.cmx.runtime.internal.trace.DataLogger;
import com.ibm.db2.cmx.runtime.internal.trace.Log;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.SocketChannel;
import java.rmi.server.UID;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConnectionImpl
implements CMXConnection,
Runnable {
    private String uid_ = null;
    private SocketChannel socketChannel_;
    private SocketAddress socketAddress_;
    Logger logger_ = null;
    CoreProcessor coreProcessor_;
    private Request cmxEnvelope_ = new Request(this);
    private ArrayList<Message> messageQueue_ = new ArrayList();
    private MessageReader messageReader_ = null;
    HashMap<String, Processor> supportedProcessors_ = new HashMap();
    HashMap<String, Integer> connectedProcessorVersions_ = new HashMap();
    private ArrayList<CMXConnectionEventListener> connectionEventListeners_ = null;
    private Object currentlyExecutingSynchronousLock_ = new Object();
    private String url_;
    private long connectTimestampMillis_;
    Thread messageReaderThread_ = null;
    Thread queueReaderThread_ = null;
    private int numSharedConnections_ = 0;
    private String hostAddress_ = null;
    private int remotePort_ = 0;
    private int localPort_ = 0;
    private Message replyMessage_ = null;

    @Override
    public String getUID() {
        if (this.uid_ == null) {
            this.uid_ = new UID().toString();
        }
        return this.uid_;
    }

    public ConnectionImpl(SocketAddress socketAddress, Processor[] processorArray) throws IOException {
        this.logger_ = Log.getCMXClientLogger();
        this.coreProcessor_ = new CoreProcessor();
        this.socketChannel_ = SocketChannel.open();
        this.socketAddress_ = socketAddress;
        this.clientConnect();
        this.init(processorArray);
    }

    public ConnectionImpl(SocketChannel socketChannel, Processor[] processorArray, Logger logger) {
        this.logger_ = logger;
        this.coreProcessor_ = new CoreProcessor();
        this.socketChannel_ = socketChannel;
        this.init(processorArray);
    }

    @Override
    public synchronized void incrementSharedCount() {
        ++this.numSharedConnections_;
    }

    @Override
    public String getUrl() {
        return this.url_;
    }

    private void init(Processor[] processorArray) {
        if (processorArray != null) {
            for (int i10 = 0; i10 < processorArray.length; ++i10) {
                this.supportedProcessors_.put(processorArray[i10].getProcessorName(), processorArray[i10]);
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.hostAddress_ = this.socketChannel_.socket().getInetAddress().getHostAddress();
        stringBuilder.append(this.hostAddress_);
        stringBuilder.append(':');
        this.remotePort_ = this.socketChannel_.socket().getPort();
        stringBuilder.append(this.remotePort_);
        this.url_ = stringBuilder.toString();
        this.localPort_ = this.socketChannel_.socket().getLocalPort();
        this.connectTimestampMillis_ = System.currentTimeMillis();
        if (this.messageReader_ == null) {
            this.messageReader_ = new MessageReader(this);
        }
        this.startThreads();
    }

    private void clientConnect() throws IOException {
        if (this.socketAddress_ != null || this.socketChannel_ == null || !this.socketChannel_.isConnected()) {
            this.socketChannel_.socket().connect(this.socketAddress_, Constants.SOCKET_CONNECT_TIMEOUT);
        }
    }

    private void startThreads() {
        if (this.queueReaderThread_ == null || !this.queueReaderThread_.isAlive()) {
            this.queueReaderThread_ = AccessController.doPrivileged(new NewThreadAction(this, "queuereader:" + DataLogger.getShortName(this), true, 1));
        }
        if (this.messageReaderThread_ == null || !this.messageReaderThread_.isAlive()) {
            this.messageReaderThread_ = AccessController.doPrivileged(new NewThreadAction(this.messageReader_, "messagereader:" + DataLogger.getShortName(this), true, 1));
        }
    }

    @Override
    public void addConnectionEventListner(CMXConnectionEventListener cMXConnectionEventListener) {
        if (this.connectionEventListeners_ == null) {
            this.connectionEventListeners_ = new ArrayList();
        }
        if (!this.connectionEventListeners_.contains(cMXConnectionEventListener)) {
            this.connectionEventListeners_.add(cMXConnectionEventListener);
        }
    }

    @Override
    public void removeConnectionEventListner(CMXConnectionEventListener cMXConnectionEventListener) {
        if (this.connectionEventListeners_ == null) {
            return;
        }
        this.connectionEventListeners_.remove(cMXConnectionEventListener);
    }

    SocketChannel getSocketChannel() {
        return this.socketChannel_;
    }

    @Override
    public boolean isConnected() {
        return this.socketChannel_.isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void queueMessage(Message message) throws Exception {
        if (this.logger_.isLoggable(Level.FINER)) {
            DataLogger.logAtLevelFiner(this.logger_, this, "queueMessage", "ENTRY " + Arrays.deepToString(new Object[]{message}));
        }
        this.checkPreConditions(message);
        ArrayList<Message> arrayList = this.messageQueue_;
        synchronized (arrayList) {
            this.messageQueue_.add(message);
            this.messageQueue_.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Message sendRequest(Message message) throws Exception {
        Message message2;
        this.checkPreConditions(message);
        Object object = this.currentlyExecutingSynchronousLock_;
        synchronized (object) {
            int n2 = this.flushMessage(message, (byte)1);
            message2 = this.readMessage(n2);
        }
        return message2;
    }

    @Override
    public void reconnect() throws IOException {
        if (this.socketAddress_ != null) {
            this.clientConnect();
            this.startThreads();
            for (String string : this.connectedProcessorVersions_.keySet()) {
                this.connectedProcessorVersions_.put(string, new Integer(-1));
                int n2 = this.connectToProcessor(this.supportedProcessors_.get(string));
                if (n2 != -1) continue;
                DataLogger.lowImpactLogger(this.logger_, this, "reconnect", "WARNING: Reconnect attempted to connect to an incompatible server version.", null);
            }
            DataLogger.logConnectedComponents(this.logger_, this, "reconnect", "reconnected socket connection");
        }
    }

    @Override
    public boolean isProcessorSupported(String string) {
        return this.supportedProcessors_.containsKey(string);
    }

    private boolean isProcessorConnected(String string) {
        return this.connectedProcessorVersions_.containsKey(string);
    }

    private void checkPreConditions(Message message) throws Exception {
        if (!this.isConnected()) {
            throw new Exception("connection is closed");
        }
        String string = message.getProcessorName();
        if (string.equals("CMXCoreProcessor")) {
            return;
        }
        if (!this.isProcessorConnected(message.getProcessorName())) {
            throw new Exception("processor is not connected");
        }
    }

    private Message readMessage(int n2) throws Exception {
        this.replyMessage_ = null;
        if (this.replyMessage_ == null) {
            this.currentlyExecutingSynchronousLock_.wait(Constants.REPLY_TIMEOUT);
            if (this.replyMessage_ == null) {
                throw new Exception("reply was not received.  timed out");
            }
        }
        Message message = this.replyMessage_;
        this.replyMessage_ = null;
        if (message.getProcessorName().equals("CMXCoreProcessor")) {
            this.coreProcessor_.checkForError(message);
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setReply(Message message) {
        DataLogger.logMonitorMessage(this.logger_, this, "setReply", "Reply received");
        Object object = this.currentlyExecutingSynchronousLock_;
        synchronized (object) {
            this.replyMessage_ = message;
            this.currentlyExecutingSynchronousLock_.notify();
        }
    }

    void notifyConnectionClosed() {
        if (this.logger_.isLoggable(Level.FINER)) {
            DataLogger.enter(this.logger_, this, "notifyConnectionClosed");
        }
        if (this.connectionEventListeners_ == null) {
            return;
        }
        CMXConnectionEventListener[] cMXConnectionEventListenerArray = this.connectionEventListeners_.toArray(new CMXConnectionEventListener[this.connectionEventListeners_.size()]);
        for (int i10 = 0; i10 < cMXConnectionEventListenerArray.length; ++i10) {
            CMXConnectionEventListener cMXConnectionEventListener = cMXConnectionEventListenerArray[i10];
            cMXConnectionEventListener.processEvent(0, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (this.isConnected()) {
                Message message = null;
                try {
                    ArrayList<Message> arrayList = this.messageQueue_;
                    synchronized (arrayList) {
                        if (this.messageQueue_.isEmpty()) {
                            this.messageQueue_.wait();
                        }
                        if (this.messageQueue_.isEmpty()) {
                            break;
                        }
                        message = this.messageQueue_.remove(0);
                    }
                }
                catch (InterruptedException interruptedException) {
                    DataLogger.logTrappedMonitoringException(this.logger_, null, "run", interruptedException, null);
                }
                if (!this.isConnected()) break;
                if (message == null) continue;
                this.flushMessage(message, (byte)3);
                if (!this.logger_.isLoggable(Level.FINE)) continue;
                DataLogger.logConnectedComponents(this.logger_, this, "run", "Monitor message was flushed");
            }
            if (this.logger_.isLoggable(Level.FINE)) {
                DataLogger.logConnectedComponents(this.logger_, this, "run", "Monitoring connection terminating, socket not connected");
            }
        }
        catch (IOException iOException) {
            DataLogger.logTrappedMonitoringException(this.logger_, this, "run", iOException, null);
        }
        finally {
            try {
                if (!this.isConnected()) {
                    this.messageQueue_.clear();
                }
                this.notifyConnectionClosed();
                this.socketChannel_.close();
            }
            catch (IOException iOException) {
                DataLogger.logTrappedMonitoringException(this.logger_, this, "run", iOException, "error closing socket streams");
            }
            this.queueReaderThread_ = null;
        }
    }

    @Override
    public void sendMessage(Message message) throws IOException {
        this.flushMessage(message, (byte)3);
    }

    synchronized int flushMessage(Message message, byte by2) throws IOException {
        if (this.logger_.isLoggable(Level.FINER)) {
            DataLogger.logMonitorBuffer(this.logger_, this, "flushMessage", "processor: " + message.getProcessorName() + " payload(UTF-8): ", message);
        }
        return this.cmxEnvelope_.flushMessage(message, this.socketChannel_, by2);
    }

    @Override
    public int connectToProcessor(Processor processor) {
        if (this.logger_.isLoggable(Level.FINER)) {
            DataLogger.logAtLevelFiner(this.logger_, this, "connectToProcessor", "ENTRY " + Arrays.deepToString(new Object[]{processor}));
        }
        int n2 = -1;
        Integer n3 = this.connectedProcessorVersions_.get(processor.getProcessorName());
        if (n3 != null) {
            n2 = n3;
        }
        if (n2 > 0) {
            DataLogger.logMonitorMessage(this.logger_, this, "connectToProcessor", "Processor already connected");
        } else {
            this.supportedProcessors_.put(processor.getProcessorName(), processor);
            try {
                if (this.logger_.isLoggable(Level.FINE)) {
                    DataLogger.logConnectedComponents(this.logger_, this, "connectToProcessor", "Sending connect to processor request");
                }
                Message message = this.sendRequest(this.coreProcessor_.createConnectToProcessorRequest(processor));
                n2 = this.coreProcessor_.parseConnectReply(message);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                DataLogger.logTrappedMonitoringException(this.logger_, this, "connectToProcessor", exception, null);
            }
            if (n2 > 0) {
                this.connectedProcessorVersions_.put(processor.getProcessorName(), new Integer(n2));
            }
        }
        if (this.logger_.isLoggable(Level.FINER)) {
            DataLogger.exit(this.logger_, this, "connectToProcessor", n2);
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        if (this.logger_.isLoggable(Level.FINEST)) {
            this.logger_.finest("numSharedConnections pre close = " + this.numSharedConnections_);
        }
        if (this.numSharedConnections_ > 0) {
            ConnectionImpl connectionImpl = this;
            synchronized (connectionImpl) {
                --this.numSharedConnections_;
            }
        }
        if (this.socketChannel_ != null && this.socketChannel_.isOpen()) {
            this.socketChannel_.close();
        }
        ArrayList<Message> arrayList = this.messageQueue_;
        synchronized (arrayList) {
            this.messageQueue_.notify();
        }
    }

    @Override
    public long getConnectTimestamp() {
        return this.connectTimestampMillis_;
    }

    @Override
    public int getNegotiatedProcessorVersion(String string) {
        Integer n2 = this.connectedProcessorVersions_.get(string);
        if (n2 == null) {
            return -1;
        }
        return n2;
    }

    @Override
    public String getHostAdress() {
        return this.hostAddress_;
    }

    @Override
    public int getLocalPort() {
        return this.localPort_;
    }

    @Override
    public int getRemotePort() {
        return this.remotePort_;
    }

    public static class NewThreadAction
    implements PrivilegedAction<Thread> {
        private Runnable runnable_ = null;
        private String name_ = null;
        private boolean daemon_ = true;
        private int priority_ = 1;

        public NewThreadAction(Runnable runnable, String string, boolean bl2, int n2) {
            this.runnable_ = runnable;
            this.name_ = string;
            this.daemon_ = bl2;
            this.priority_ = n2;
        }

        @Override
        public Thread run() {
            Thread thread = new Thread(this.runnable_);
            thread.setName(this.name_);
            thread.setDaemon(this.daemon_);
            thread.setPriority(this.priority_);
            thread.start();
            return thread;
        }
    }
}

